/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cyberagent.android.gpuimage.filter;

import android.opengl.GLES20;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageFilter;

public class GPUImageHalftoneFilter
extends GPUImageFilter {
    public static final String HALFTONE_FRAGMENT_SHADER = "varying highp vec2 textureCoordinate;\nuniform sampler2D inputImageTexture;\nuniform highp float fractionalWidthOfPixel;\nuniform highp float aspectRatio;\nconst highp vec3 W = vec3(0.2125, 0.7154, 0.0721);\nvoid main()\n{\n  highp vec2 sampleDivisor = vec2(fractionalWidthOfPixel, fractionalWidthOfPixel / aspectRatio);\n  highp vec2 samplePos = textureCoordinate - mod(textureCoordinate, sampleDivisor) + 0.5 * sampleDivisor;\n  highp vec2 textureCoordinateToUse = vec2(textureCoordinate.x, (textureCoordinate.y * aspectRatio + 0.5 - 0.5 * aspectRatio));\n  highp vec2 adjustedSamplePos = vec2(samplePos.x, (samplePos.y * aspectRatio + 0.5 - 0.5 * aspectRatio));\n  highp float distanceFromSamplePoint = distance(adjustedSamplePos, textureCoordinateToUse);\n  lowp vec3 sampledColor = texture2D(inputImageTexture, samplePos).rgb;\n  highp float dotScaling = 1.0 - dot(sampledColor, W);\n  lowp float checkForPresenceWithinDot = 1.0 - step(distanceFromSamplePoint, (fractionalWidthOfPixel * 0.5) * dotScaling);\n  gl_FragColor = vec4(vec3(checkForPresenceWithinDot), 1.0);\n}";
    private int fractionalWidthOfPixelLocation;
    private int aspectRatioLocation;
    private float fractionalWidthOfAPixel;
    private float aspectRatio;

    public GPUImageHalftoneFilter() {
        this(0.01f);
    }

    public GPUImageHalftoneFilter(float fractionalWidthOfAPixel) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", HALFTONE_FRAGMENT_SHADER);
        this.fractionalWidthOfAPixel = fractionalWidthOfAPixel;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.fractionalWidthOfPixelLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"fractionalWidthOfPixel");
        this.aspectRatioLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"aspectRatio");
        this.setFractionalWidthOfAPixel(this.fractionalWidthOfAPixel);
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        super.onOutputSizeChanged(width, height);
        this.setAspectRatio((float)height / (float)width);
    }

    public void setFractionalWidthOfAPixel(float fractionalWidthOfAPixel) {
        this.fractionalWidthOfAPixel = fractionalWidthOfAPixel;
        this.setFloat(this.fractionalWidthOfPixelLocation, this.fractionalWidthOfAPixel);
    }

    public void setAspectRatio(float aspectRatio) {
        this.aspectRatio = aspectRatio;
        this.setFloat(this.aspectRatioLocation, this.aspectRatio);
    }
}

