/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cyberagent.android.gpuimage;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ConfigurationInfo;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.hardware.Camera;
import android.media.ExifInterface;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.opengl.GLSurfaceView;
import android.os.AsyncTask;
import android.os.Environment;
import android.os.Handler;
import android.view.Display;
import android.view.WindowManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import jp.co.cyberagent.android.gpuimage.GLTextureView;
import jp.co.cyberagent.android.gpuimage.GPUImageRenderer;
import jp.co.cyberagent.android.gpuimage.PixelBuffer;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageFilter;
import jp.co.cyberagent.android.gpuimage.util.Rotation;

public class GPUImage {
    static final int SURFACE_TYPE_SURFACE_VIEW = 0;
    static final int SURFACE_TYPE_TEXTURE_VIEW = 1;
    private final Context context;
    private final GPUImageRenderer renderer;
    private int surfaceType = 0;
    private GLSurfaceView glSurfaceView;
    private GLTextureView glTextureView;
    private GPUImageFilter filter;
    private Bitmap currentBitmap;
    private ScaleType scaleType = ScaleType.CENTER_CROP;

    public GPUImage(Context context) {
        if (!this.supportsOpenGLES2(context)) {
            throw new IllegalStateException("OpenGL ES 2.0 is not supported on this phone.");
        }
        this.context = context;
        this.filter = new GPUImageFilter();
        this.renderer = new GPUImageRenderer(this.filter);
    }

    private boolean supportsOpenGLES2(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        ConfigurationInfo configurationInfo = activityManager.getDeviceConfigurationInfo();
        return configurationInfo.reqGlEsVersion >= 131072;
    }

    public void setGLSurfaceView(GLSurfaceView view) {
        this.surfaceType = 0;
        this.glSurfaceView = view;
        this.glSurfaceView.setEGLContextClientVersion(2);
        this.glSurfaceView.setEGLConfigChooser(8, 8, 8, 8, 16, 0);
        this.glSurfaceView.getHolder().setFormat(1);
        this.glSurfaceView.setRenderer((GLSurfaceView.Renderer)this.renderer);
        this.glSurfaceView.setRenderMode(0);
        this.glSurfaceView.requestRender();
    }

    public void setGLTextureView(GLTextureView view) {
        this.surfaceType = 1;
        this.glTextureView = view;
        this.glTextureView.setEGLContextClientVersion(2);
        this.glTextureView.setEGLConfigChooser(8, 8, 8, 8, 16, 0);
        this.glTextureView.setOpaque(false);
        this.glTextureView.setRenderer(this.renderer);
        this.glTextureView.setRenderMode(0);
        this.glTextureView.requestRender();
    }

    public void setBackgroundColor(float red, float green, float blue) {
        this.renderer.setBackgroundColor(red, green, blue);
    }

    public void requestRender() {
        if (this.surfaceType == 0) {
            if (this.glSurfaceView != null) {
                this.glSurfaceView.requestRender();
            }
        } else if (this.surfaceType == 1 && this.glTextureView != null) {
            this.glTextureView.requestRender();
        }
    }

    @Deprecated
    public void setUpCamera(Camera camera) {
        this.setUpCamera(camera, 0, false, false);
    }

    @Deprecated
    public void setUpCamera(Camera camera, int degrees, boolean flipHorizontal, boolean flipVertical) {
        if (this.surfaceType == 0) {
            this.glSurfaceView.setRenderMode(1);
        } else if (this.surfaceType == 1) {
            this.glTextureView.setRenderMode(1);
        }
        this.renderer.setUpSurfaceTexture(camera);
        Rotation rotation = Rotation.NORMAL;
        switch (degrees) {
            case 90: {
                rotation = Rotation.ROTATION_90;
                break;
            }
            case 180: {
                rotation = Rotation.ROTATION_180;
                break;
            }
            case 270: {
                rotation = Rotation.ROTATION_270;
            }
        }
        this.renderer.setRotationCamera(rotation, flipHorizontal, flipVertical);
    }

    public void setFilter(GPUImageFilter filter) {
        this.filter = filter;
        this.renderer.setFilter(this.filter);
        this.requestRender();
    }

    public void setImage(Bitmap bitmap) {
        this.currentBitmap = bitmap;
        this.renderer.setImageBitmap(bitmap, false);
        this.requestRender();
    }

    public void updatePreviewFrame(byte[] data, int width, int height) {
        this.renderer.onPreviewFrame(data, width, height);
    }

    public void setScaleType(ScaleType scaleType) {
        this.scaleType = scaleType;
        this.renderer.setScaleType(scaleType);
        this.renderer.deleteImage();
        this.currentBitmap = null;
        this.requestRender();
    }

    public void setRotation(Rotation rotation) {
        this.renderer.setRotation(rotation);
    }

    public void setRotation(Rotation rotation, boolean flipHorizontal, boolean flipVertical) {
        this.renderer.setRotation(rotation, flipHorizontal, flipVertical);
    }

    public void deleteImage() {
        this.renderer.deleteImage();
        this.currentBitmap = null;
        this.requestRender();
    }

    public void setImage(Uri uri) {
        new LoadImageUriTask(this, uri).execute(new Void[0]);
    }

    public void setImage(File file) {
        new LoadImageFileTask(this, file).execute(new Void[0]);
    }

    private String getPath(Uri uri) {
        String[] projection = new String[]{"_data"};
        Cursor cursor = this.context.getContentResolver().query(uri, projection, null, null, null);
        String path = null;
        if (cursor == null) {
            return null;
        }
        if (cursor.moveToFirst()) {
            int pathIndex = cursor.getColumnIndexOrThrow("_data");
            path = cursor.getString(pathIndex);
        }
        cursor.close();
        return path;
    }

    public Bitmap getBitmapWithFilterApplied() {
        return this.getBitmapWithFilterApplied(this.currentBitmap);
    }

    public Bitmap getBitmapWithFilterApplied(Bitmap bitmap) {
        return this.getBitmapWithFilterApplied(bitmap, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap getBitmapWithFilterApplied(Bitmap bitmap, boolean recycle) {
        if (this.glSurfaceView != null || this.glTextureView != null) {
            this.renderer.deleteImage();
            this.renderer.runOnDraw(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    GPUImageFilter gPUImageFilter = GPUImage.this.filter;
                    synchronized (gPUImageFilter) {
                        GPUImage.this.filter.destroy();
                        GPUImage.this.filter.notify();
                    }
                }
            });
            GPUImageFilter gPUImageFilter = this.filter;
            synchronized (gPUImageFilter) {
                this.requestRender();
                try {
                    this.filter.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        GPUImageRenderer renderer = new GPUImageRenderer(this.filter);
        renderer.setRotation(Rotation.NORMAL, this.renderer.isFlippedHorizontally(), this.renderer.isFlippedVertically());
        renderer.setScaleType(this.scaleType);
        PixelBuffer buffer = new PixelBuffer(bitmap.getWidth(), bitmap.getHeight());
        buffer.setRenderer(renderer);
        renderer.setImageBitmap(bitmap, recycle);
        Bitmap result = buffer.getBitmap();
        this.filter.destroy();
        renderer.deleteImage();
        buffer.destroy();
        this.renderer.setFilter(this.filter);
        if (this.currentBitmap != null) {
            this.renderer.setImageBitmap(this.currentBitmap, false);
        }
        this.requestRender();
        return result;
    }

    public static void getBitmapForMultipleFilters(Bitmap bitmap, List<GPUImageFilter> filters, ResponseListener<Bitmap> listener) {
        if (filters.isEmpty()) {
            return;
        }
        GPUImageRenderer renderer = new GPUImageRenderer(filters.get(0));
        renderer.setImageBitmap(bitmap, false);
        PixelBuffer buffer = new PixelBuffer(bitmap.getWidth(), bitmap.getHeight());
        buffer.setRenderer(renderer);
        for (GPUImageFilter filter : filters) {
            renderer.setFilter(filter);
            listener.response(buffer.getBitmap());
            filter.destroy();
        }
        renderer.deleteImage();
        buffer.destroy();
    }

    public void saveToPictures(String folderName, String fileName, OnPictureSavedListener listener) {
        this.saveToPictures(this.currentBitmap, folderName, fileName, listener);
    }

    public void saveToPictures(Bitmap bitmap, String folderName, String fileName, OnPictureSavedListener listener) {
        new SaveTask(bitmap, folderName, fileName, listener).execute(new Void[0]);
    }

    void runOnGLThread(Runnable runnable) {
        this.renderer.runOnDrawEnd(runnable);
    }

    private int getOutputWidth() {
        if (this.renderer != null && this.renderer.getFrameWidth() != 0) {
            return this.renderer.getFrameWidth();
        }
        if (this.currentBitmap != null) {
            return this.currentBitmap.getWidth();
        }
        WindowManager windowManager = (WindowManager)this.context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        return display.getWidth();
    }

    private int getOutputHeight() {
        if (this.renderer != null && this.renderer.getFrameHeight() != 0) {
            return this.renderer.getFrameHeight();
        }
        if (this.currentBitmap != null) {
            return this.currentBitmap.getHeight();
        }
        WindowManager windowManager = (WindowManager)this.context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        return display.getHeight();
    }

    public static interface ResponseListener<T> {
        public void response(T var1);
    }

    private abstract class LoadImageTask
    extends AsyncTask<Void, Void, Bitmap> {
        private final GPUImage gpuImage;
        private int outputWidth;
        private int outputHeight;

        public LoadImageTask(GPUImage gpuImage) {
            this.gpuImage = gpuImage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Bitmap doInBackground(Void ... params) {
            if (GPUImage.this.renderer != null && GPUImage.this.renderer.getFrameWidth() == 0) {
                try {
                    Object object = ((GPUImage)GPUImage.this).renderer.surfaceChangedWaiter;
                    synchronized (object) {
                        ((GPUImage)GPUImage.this).renderer.surfaceChangedWaiter.wait(3000L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.outputWidth = GPUImage.this.getOutputWidth();
            this.outputHeight = GPUImage.this.getOutputHeight();
            return this.loadResizedImage();
        }

        protected void onPostExecute(Bitmap bitmap) {
            super.onPostExecute((Object)bitmap);
            this.gpuImage.deleteImage();
            this.gpuImage.setImage(bitmap);
        }

        protected abstract Bitmap decode(BitmapFactory.Options var1);

        private Bitmap loadResizedImage() {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            this.decode(options);
            int scale = 1;
            while (this.checkSize(options.outWidth / scale > this.outputWidth, options.outHeight / scale > this.outputHeight)) {
                ++scale;
            }
            if (--scale < 1) {
                scale = 1;
            }
            options = new BitmapFactory.Options();
            options.inSampleSize = scale;
            options.inPreferredConfig = Bitmap.Config.RGB_565;
            options.inPurgeable = true;
            options.inTempStorage = new byte[32768];
            Bitmap bitmap = this.decode(options);
            if (bitmap == null) {
                return null;
            }
            bitmap = this.rotateImage(bitmap);
            bitmap = this.scaleBitmap(bitmap);
            return bitmap;
        }

        private Bitmap scaleBitmap(Bitmap bitmap) {
            int diffHeight;
            int diffWidth;
            int height;
            int width = bitmap.getWidth();
            int[] newSize = this.getScaleSize(width, height = bitmap.getHeight());
            Bitmap workBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)newSize[0], (int)newSize[1], (boolean)true);
            if (workBitmap != bitmap) {
                bitmap.recycle();
                bitmap = workBitmap;
                System.gc();
            }
            if (GPUImage.this.scaleType == ScaleType.CENTER_CROP && (workBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)((diffWidth = newSize[0] - this.outputWidth) / 2), (int)((diffHeight = newSize[1] - this.outputHeight) / 2), (int)(newSize[0] - diffWidth), (int)(newSize[1] - diffHeight))) != bitmap) {
                bitmap.recycle();
                bitmap = workBitmap;
            }
            return bitmap;
        }

        private int[] getScaleSize(int width, int height) {
            float newWidth;
            float newHeight;
            boolean adjustWidth;
            float withRatio = (float)width / (float)this.outputWidth;
            float heightRatio = (float)height / (float)this.outputHeight;
            boolean bl = GPUImage.this.scaleType == ScaleType.CENTER_CROP ? withRatio > heightRatio : (adjustWidth = withRatio < heightRatio);
            if (adjustWidth) {
                newHeight = this.outputHeight;
                newWidth = newHeight / (float)height * (float)width;
            } else {
                newWidth = this.outputWidth;
                newHeight = newWidth / (float)width * (float)height;
            }
            return new int[]{Math.round(newWidth), Math.round(newHeight)};
        }

        private boolean checkSize(boolean widthBigger, boolean heightBigger) {
            if (GPUImage.this.scaleType == ScaleType.CENTER_CROP) {
                return widthBigger && heightBigger;
            }
            return widthBigger || heightBigger;
        }

        private Bitmap rotateImage(Bitmap bitmap) {
            if (bitmap == null) {
                return null;
            }
            Bitmap rotatedBitmap = bitmap;
            try {
                int orientation = this.getImageOrientation();
                if (orientation != 0) {
                    Matrix matrix = new Matrix();
                    matrix.postRotate((float)orientation);
                    rotatedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                    bitmap.recycle();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return rotatedBitmap;
        }

        protected abstract int getImageOrientation() throws IOException;
    }

    private class LoadImageFileTask
    extends LoadImageTask {
        private final File imageFile;

        public LoadImageFileTask(GPUImage gpuImage, File file) {
            super(gpuImage);
            this.imageFile = file;
        }

        @Override
        protected Bitmap decode(BitmapFactory.Options options) {
            return BitmapFactory.decodeFile((String)this.imageFile.getAbsolutePath(), (BitmapFactory.Options)options);
        }

        @Override
        protected int getImageOrientation() throws IOException {
            ExifInterface exif = new ExifInterface(this.imageFile.getAbsolutePath());
            int orientation = exif.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 1: {
                    return 0;
                }
                case 6: {
                    return 90;
                }
                case 3: {
                    return 180;
                }
                case 8: {
                    return 270;
                }
            }
            return 0;
        }
    }

    private class LoadImageUriTask
    extends LoadImageTask {
        private final Uri uri;

        public LoadImageUriTask(GPUImage gpuImage, Uri uri) {
            super(gpuImage);
            this.uri = uri;
        }

        @Override
        protected Bitmap decode(BitmapFactory.Options options) {
            try {
                InputStream inputStream = this.uri.getScheme().startsWith("http") || this.uri.getScheme().startsWith("https") ? new URL(this.uri.toString()).openStream() : (this.uri.getPath().startsWith("/android_asset/") ? GPUImage.this.context.getAssets().open(this.uri.getPath().substring("/android_asset/".length())) : GPUImage.this.context.getContentResolver().openInputStream(this.uri));
                return BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        protected int getImageOrientation() throws IOException {
            Cursor cursor = GPUImage.this.context.getContentResolver().query(this.uri, new String[]{"orientation"}, null, null, null);
            if (cursor == null || cursor.getCount() != 1) {
                return 0;
            }
            cursor.moveToFirst();
            int orientation = cursor.getInt(0);
            cursor.close();
            return orientation;
        }
    }

    public static interface OnPictureSavedListener {
        public void onPictureSaved(Uri var1);
    }

    @Deprecated
    private class SaveTask
    extends AsyncTask<Void, Void, Void> {
        private final Bitmap bitmap;
        private final String folderName;
        private final String fileName;
        private final OnPictureSavedListener listener;
        private final Handler handler;

        public SaveTask(Bitmap bitmap, String folderName, String fileName, OnPictureSavedListener listener) {
            this.bitmap = bitmap;
            this.folderName = folderName;
            this.fileName = fileName;
            this.listener = listener;
            this.handler = new Handler();
        }

        protected Void doInBackground(Void ... params) {
            Bitmap result = GPUImage.this.getBitmapWithFilterApplied(this.bitmap);
            this.saveImage(this.folderName, this.fileName, result);
            return null;
        }

        private void saveImage(String folderName, String fileName, Bitmap image) {
            File path = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
            File file = new File(path, folderName + "/" + fileName);
            try {
                file.getParentFile().mkdirs();
                image.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)new FileOutputStream(file));
                MediaScannerConnection.scanFile((Context)GPUImage.this.context, (String[])new String[]{file.toString()}, null, (MediaScannerConnection.OnScanCompletedListener)new MediaScannerConnection.OnScanCompletedListener(){

                    public void onScanCompleted(String path, final Uri uri) {
                        if (SaveTask.this.listener != null) {
                            SaveTask.this.handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    SaveTask.this.listener.onPictureSaved(uri);
                                }
                            });
                        }
                    }
                });
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public static enum ScaleType {
        CENTER_INSIDE,
        CENTER_CROP;

    }
}

