/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.ssm;

import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagementClient;
import com.amazonaws.services.simplesystemsmanagement.model.Parameter;
import com.amazonaws.services.simplesystemsmanagement.model.ParameterAlreadyExistsException;
import com.amazonaws.services.simplesystemsmanagement.model.PutParameterRequest;
import com.amazonaws.services.simplesystemsmanagement.model.PutParameterResult;
import java.util.ArrayList;
import java.util.List;
import jp.classmethod.aws.gradle.ssm.AmazonSSMPluginExtention;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonSSMPutParameterTask
extends ConventionTask {
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private boolean overwrite;
    private String prefix;
    private PutParameterResult putParameterResult;

    public AmazonSSMPutParameterTask() {
        this.setDescription("Put SSM Parameters.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void putParameter() {
        List<Parameter> parameters = this.getParameters();
        if (parameters.isEmpty()) {
            return;
        }
        if (this.getPrefix() == null) {
            this.setPrefix("");
        }
        AmazonSSMPluginExtention ext = (AmazonSSMPluginExtention)this.getProject().getExtensions().getByType(AmazonSSMPluginExtention.class);
        AWSSimpleSystemsManagementClient ssm = (AWSSimpleSystemsManagementClient)ext.getClient();
        parameters.stream().map(param -> new PutParameterRequest().withName(this.getPrefix() + param.getName()).withType(param.getType()).withValue(param.getValue()).withOverwrite(Boolean.valueOf(this.isOverwrite()))).forEach(request -> {
            try {
                ssm.putParameter(request);
            }
            catch (ParameterAlreadyExistsException e) {
                this.getLogger().warn("parameter {} already exists", (Object)request.getName());
            }
        });
        this.getLogger().info("Successfully Put SSM Parameters.");
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public PutParameterResult getPutParameterResult() {
        return this.putParameterResult;
    }
}

