/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.StorageClass;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import jp.classmethod.aws.gradle.s3.AmazonS3PluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.TaskAction;

public class SyncTask
extends ConventionTask {
    private String bucketName;
    private String prefix = "";
    private File source;
    private boolean delete;
    private int threads = 5;
    private StorageClass storageClass = StorageClass.Standard;
    private Closure<ObjectMetadata> metadataProvider;
    private CannedAccessControlList acl;

    private static String md5(File file) {
        try {
            return Files.hash((File)file, (HashFunction)Hashing.md5()).toString();
        }
        catch (IOException e) {
            return "";
        }
    }

    public void setAcl(String aclName) {
        this.acl = CannedAccessControlList.valueOf((String)aclName);
    }

    @TaskAction
    public void uploadAction() throws InterruptedException {
        String bucketName = this.getBucketName();
        String prefix = this.getPrefix();
        File source = this.getSource();
        if (bucketName == null) {
            throw new GradleException("bucketName is not specified");
        }
        if (source == null) {
            throw new GradleException("source is not specified");
        }
        if (!source.isDirectory()) {
            throw new GradleException("source must be directory");
        }
        prefix = prefix.startsWith("/") ? prefix.substring(1) : prefix;
        AmazonS3PluginExtension ext = (AmazonS3PluginExtension)this.getProject().getExtensions().getByType(AmazonS3PluginExtension.class);
        AmazonS3 s3 = (AmazonS3)ext.getClient();
        this.upload(s3, prefix);
        if (this.isDelete()) {
            this.deleteAbsent(s3, prefix);
        }
    }

    private void upload(final AmazonS3 s3, final String prefix) throws InterruptedException {
        final String bucketName = this.getBucketName();
        File source = this.getSource();
        final Closure<ObjectMetadata> metadataProvider = this.getMetadataProvider();
        final CannedAccessControlList acl = this.getAcl();
        final ExecutorService es = Executors.newFixedThreadPool(this.threads);
        this.getLogger().info("Start uploading");
        this.getLogger().info("Uploading... {} to s3://{}/{}", new Object[]{source, bucketName, prefix});
        this.getProject().fileTree((Object)source).visit((FileVisitor)new EmptyFileVisitor(){

            public void visitFile(FileVisitDetails element) {
                es.execute(new UploadTask(s3, element, bucketName, prefix, SyncTask.this.storageClass, acl, (Closure<ObjectMetadata>)metadataProvider, SyncTask.this.getLogger()));
            }
        });
        es.shutdown();
        es.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        this.getLogger().info("Finish uploading");
    }

    private void deleteAbsent(AmazonS3 s3, String prefix) {
        String bucketName = this.getBucketName();
        String pathPrefix = this.getNormalizedPathPrefix();
        s3.listObjects(bucketName, prefix).getObjectSummaries().forEach(os -> {
            File f = this.getProject().file((Object)(pathPrefix + os.getKey().substring(prefix.length())));
            if (!f.exists()) {
                this.getLogger().info("deleting... s3://{}/{}", (Object)bucketName, (Object)os.getKey());
                s3.deleteObject(bucketName, os.getKey());
            }
        });
    }

    private String getNormalizedPathPrefix() {
        String pathPrefix = this.getSource().toString();
        pathPrefix = pathPrefix + (pathPrefix.endsWith("/") ? "" : "/");
        return pathPrefix;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public File getSource() {
        return this.source;
    }

    public void setSource(File source) {
        this.source = source;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public StorageClass getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(StorageClass storageClass) {
        this.storageClass = storageClass;
    }

    public Closure<ObjectMetadata> getMetadataProvider() {
        return this.metadataProvider;
    }

    public void setMetadataProvider(Closure<ObjectMetadata> metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    public CannedAccessControlList getAcl() {
        return this.acl;
    }

    private static class UploadTask
    implements Runnable {
        private AmazonS3 s3;
        private FileVisitDetails element;
        private String bucketName;
        private String prefix;
        private Closure<ObjectMetadata> metadataProvider;
        private StorageClass storageClass;
        private CannedAccessControlList acl;
        private Logger logger;

        UploadTask(AmazonS3 s3, FileVisitDetails element, String bucketName, String prefix, StorageClass storageClass, CannedAccessControlList acl, Closure<ObjectMetadata> metadataProvider, Logger logger) {
            this.s3 = s3;
            this.element = element;
            this.bucketName = bucketName;
            this.prefix = prefix;
            this.storageClass = storageClass;
            this.acl = acl;
            this.metadataProvider = metadataProvider;
            this.logger = logger;
        }

        @Override
        public void run() {
            String relativePath = this.prefix + this.element.getRelativePath().toString();
            String key = relativePath.startsWith("/") ? relativePath.substring(1) : relativePath;
            boolean doUpload = false;
            try {
                ObjectMetadata metadata = this.s3.getObjectMetadata(this.bucketName, key);
                if (!metadata.getETag().equalsIgnoreCase(SyncTask.md5(this.element.getFile()))) {
                    doUpload = true;
                }
            }
            catch (AmazonS3Exception e) {
                doUpload = true;
            }
            if (doUpload) {
                this.logger.info(" => s3://{}/{}", (Object)this.bucketName, (Object)key);
                this.s3.putObject(new PutObjectRequest(this.bucketName, key, this.element.getFile()).withStorageClass(this.storageClass).withCannedAcl(this.acl).withMetadata(this.metadataProvider == null ? null : (ObjectMetadata)this.metadataProvider.call(new Object[]{this.bucketName, key, this.element.getFile()})));
            } else {
                this.logger.info(" => s3://{}/{} (SKIP)", (Object)this.bucketName, (Object)key);
            }
        }
    }
}

