/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.s3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ObjectListing;
import jp.classmethod.aws.gradle.s3.AmazonS3PluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class DeleteBucketTask
extends ConventionTask {
    String bucketName;
    boolean ifExists;
    boolean deleteObjects;

    public DeleteBucketTask() {
        this.setDescription("Create the Amazon S3 bucket.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void deleteBucket() {
        String bucketName = this.getBucketName();
        boolean ifExists = this.isIfExists();
        if (bucketName == null) {
            throw new GradleException("bucketName is not specified");
        }
        AmazonS3PluginExtension ext = (AmazonS3PluginExtension)this.getProject().getExtensions().getByType(AmazonS3PluginExtension.class);
        AmazonS3 s3 = (AmazonS3)ext.getClient();
        if (!ifExists || this.exists(s3)) {
            if (this.deleteObjects) {
                this.getLogger().info("Delete all S3 objects in bucket [{}]", (Object)bucketName);
                ObjectListing objectListing = s3.listObjects(bucketName);
                while (!objectListing.getObjectSummaries().isEmpty()) {
                    objectListing.getObjectSummaries().forEach(summary -> {
                        this.getLogger().info(" => delete s3://{}/{}", (Object)bucketName, (Object)summary.getKey());
                        s3.deleteObject(bucketName, summary.getKey());
                    });
                    objectListing = s3.listNextBatchOfObjects(objectListing);
                }
            }
            s3.deleteBucket(bucketName);
            this.getLogger().info("S3 bucket {} is deleted", (Object)bucketName);
        } else {
            this.getLogger().debug("S3 bucket {} does not exist", (Object)bucketName);
        }
    }

    private boolean exists(AmazonS3 s3) {
        String bucketName = this.getBucketName();
        try {
            s3.getBucketLocation(bucketName);
            return true;
        }
        catch (AmazonClientException e) {
            return false;
        }
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    public void setIfExists(boolean ifExists) {
        this.ifExists = ifExists;
    }

    public boolean isDeleteObjects() {
        return this.deleteObjects;
    }

    public void setDeleteObjects(boolean deleteObjects) {
        this.deleteObjects = deleteObjects;
    }
}

