/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.rds;

import com.amazonaws.services.rds.AmazonRDS;
import com.amazonaws.services.rds.model.DBInstance;
import com.amazonaws.services.rds.model.DBInstanceNotFoundException;
import com.amazonaws.services.rds.model.DeleteDBInstanceRequest;
import jp.classmethod.aws.gradle.rds.AmazonRDSPluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonRDSDeleteDBInstanceTask
extends ConventionTask {
    private String dbInstanceIdentifier;
    private boolean skipFinalSnapshot;
    private String finalDBSnapshotIdentifier;
    private DBInstance dbInstance;

    public AmazonRDSDeleteDBInstanceTask() {
        this.setDescription("Delete RDS instance.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void deleteDBInstance() {
        String dbInstanceIdentifier = this.getDbInstanceIdentifier();
        if (dbInstanceIdentifier == null) {
            throw new GradleException("dbInstanceIdentifier is required");
        }
        AmazonRDSPluginExtension ext = (AmazonRDSPluginExtension)this.getProject().getExtensions().getByType(AmazonRDSPluginExtension.class);
        AmazonRDS rds = (AmazonRDS)ext.getClient();
        try {
            DeleteDBInstanceRequest request = new DeleteDBInstanceRequest().withDBInstanceIdentifier(dbInstanceIdentifier).withSkipFinalSnapshot(Boolean.valueOf(this.isSkipFinalSnapshot())).withFinalDBSnapshotIdentifier(this.getFinalDBSnapshotIdentifier());
            this.dbInstance = rds.deleteDBInstance(request);
            this.getLogger().info("Delete RDS instance requested: {}", (Object)this.dbInstance.getDBInstanceIdentifier());
        }
        catch (DBInstanceNotFoundException e) {
            this.getLogger().warn(e.getMessage());
        }
    }

    public String getDbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public void setDbInstanceIdentifier(String dbInstanceIdentifier) {
        this.dbInstanceIdentifier = dbInstanceIdentifier;
    }

    public boolean isSkipFinalSnapshot() {
        return this.skipFinalSnapshot;
    }

    public void setSkipFinalSnapshot(boolean skipFinalSnapshot) {
        this.skipFinalSnapshot = skipFinalSnapshot;
    }

    public String getFinalDBSnapshotIdentifier() {
        return this.finalDBSnapshotIdentifier;
    }

    public void setFinalDBSnapshotIdentifier(String finalDBSnapshotIdentifier) {
        this.finalDBSnapshotIdentifier = finalDBSnapshotIdentifier;
    }

    public DBInstance getDbInstance() {
        return this.dbInstance;
    }
}

