/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.rds;

import com.amazonaws.services.rds.AmazonRDS;
import com.amazonaws.services.rds.model.CreateDBInstanceRequest;
import com.amazonaws.services.rds.model.DBInstance;
import com.amazonaws.services.rds.model.Tag;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jp.classmethod.aws.gradle.rds.AmazonRDSPluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonRDSCreateDBInstanceTask
extends ConventionTask {
    private String dbName;
    private String dbInstanceIdentifier;
    private Integer allocatedStorage;
    private String dbInstanceClass;
    private String engine;
    private String masterUsername;
    private String masterUserPassword;
    private List<String> vpcSecurityGroupIds;
    private String dbSubnetGroupName;
    private String preferredMaintenanceWindow;
    private String dbParameterGroupName;
    private Integer backupRetentionPeriod;
    private String preferredBackupWindow;
    private Integer port;
    private Boolean multiAZ;
    private String engineVersion;
    private Boolean autoMinorVersionUpgrade;
    private String licenseModel;
    private Integer iops;
    private String optionGroupName;
    private Boolean publiclyAccessible;
    private String characterSetName;
    private String storageType;
    private String tdeCredentialArn;
    private String tdeCredentialPassword;
    private Boolean storageEncrypted;
    private String kmsKeyId;
    private Boolean copyTagsToSnapshot;
    private Integer promotionTier;
    private String dbClusterIdentifier;
    private String availabilityZone;
    private List<String> securityGroups;
    private DBInstance dbInstance;
    private Map<String, String> tags;

    public AmazonRDSCreateDBInstanceTask() {
        this.setDescription("Create RDS instance.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void createDBInstance() {
        String dbInstanceIdentifier = this.getDbInstanceIdentifier();
        String dbInstanceClass = this.getDbInstanceClass();
        String engine = this.getEngine();
        if (dbInstanceClass == null) {
            throw new GradleException("dbInstanceClass is required");
        }
        if (dbInstanceIdentifier == null) {
            throw new GradleException("dbInstanceIdentifier is required");
        }
        if (engine == null) {
            throw new GradleException("engine is required");
        }
        AmazonRDSPluginExtension ext = (AmazonRDSPluginExtension)this.getProject().getExtensions().getByType(AmazonRDSPluginExtension.class);
        AmazonRDS rds = (AmazonRDS)ext.getClient();
        CreateDBInstanceRequest request = new CreateDBInstanceRequest().withDBName(this.getDbName()).withDBInstanceIdentifier(dbInstanceIdentifier).withAllocatedStorage(this.getAllocatedStorage()).withDBInstanceClass(dbInstanceClass).withEngine(engine).withMasterUsername(this.getMasterUsername()).withMasterUserPassword(this.getMasterUserPassword()).withVpcSecurityGroupIds(this.getVpcSecurityGroupIds()).withDBSecurityGroups(this.getSecurityGroups()).withDBSubnetGroupName(this.getDbSubnetGroupName()).withPreferredMaintenanceWindow(this.getPreferredMaintenanceWindow()).withDBParameterGroupName(this.getDbParameterGroupName()).withBackupRetentionPeriod(this.getBackupRetentionPeriod()).withPreferredBackupWindow(this.getPreferredBackupWindow()).withPort(this.getPort()).withMultiAZ(this.getMultiAZ()).withEngineVersion(this.getEngineVersion()).withAutoMinorVersionUpgrade(this.getAutoMinorVersionUpgrade()).withLicenseModel(this.getLicenseModel()).withIops(this.getIops()).withOptionGroupName(this.getOptionGroupName()).withPubliclyAccessible(this.getPubliclyAccessible()).withCharacterSetName(this.getCharacterSetName()).withStorageType(this.getStorageType()).withTdeCredentialArn(this.getTdeCredentialArn()).withTdeCredentialPassword(this.getTdeCredentialPassword()).withStorageEncrypted(this.getStorageEncrypted()).withKmsKeyId(this.getKmsKeyId()).withCopyTagsToSnapshot(this.getCopyTagsToSnapshot()).withPromotionTier(this.getPromotionTier()).withDBClusterIdentifier(this.getDbClusterIdentifier()).withAvailabilityZone(this.getAvailabilityZone()).withTags((Collection)this.getTags().entrySet().stream().map(it -> new Tag().withKey(((String)it.getKey()).toString()).withValue(((String)it.getValue()).toString())).collect(Collectors.toList()));
        this.dbInstance = rds.createDBInstance(request);
        this.getLogger().info("Create RDS instance requested: {}", (Object)this.dbInstance.getDBInstanceIdentifier());
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getDbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public void setDbInstanceIdentifier(String dbInstanceIdentifier) {
        this.dbInstanceIdentifier = dbInstanceIdentifier;
    }

    public Integer getAllocatedStorage() {
        return this.allocatedStorage;
    }

    public void setAllocatedStorage(Integer allocatedStorage) {
        this.allocatedStorage = allocatedStorage;
    }

    public String getDbInstanceClass() {
        return this.dbInstanceClass;
    }

    public void setDbInstanceClass(String dbInstanceClass) {
        this.dbInstanceClass = dbInstanceClass;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public String getMasterUsername() {
        return this.masterUsername;
    }

    public void setMasterUsername(String masterUsername) {
        this.masterUsername = masterUsername;
    }

    public String getMasterUserPassword() {
        return this.masterUserPassword;
    }

    public void setMasterUserPassword(String masterUserPassword) {
        this.masterUserPassword = masterUserPassword;
    }

    public List<String> getVpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public void setVpcSecurityGroupIds(List<String> vpcSecurityGroupIds) {
        this.vpcSecurityGroupIds = vpcSecurityGroupIds;
    }

    public String getDbSubnetGroupName() {
        return this.dbSubnetGroupName;
    }

    public void setDbSubnetGroupName(String dbSubnetGroupName) {
        this.dbSubnetGroupName = dbSubnetGroupName;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public String getDbParameterGroupName() {
        return this.dbParameterGroupName;
    }

    public void setDbParameterGroupName(String dbParameterGroupName) {
        this.dbParameterGroupName = dbParameterGroupName;
    }

    public Integer getBackupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
        this.backupRetentionPeriod = backupRetentionPeriod;
    }

    public String getPreferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public void setPreferredBackupWindow(String preferredBackupWindow) {
        this.preferredBackupWindow = preferredBackupWindow;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Boolean getMultiAZ() {
        return this.multiAZ;
    }

    public void setMultiAZ(Boolean multiAZ) {
        this.multiAZ = multiAZ;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public Boolean getAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
    }

    public String getLicenseModel() {
        return this.licenseModel;
    }

    public void setLicenseModel(String licenseModel) {
        this.licenseModel = licenseModel;
    }

    public Integer getIops() {
        return this.iops;
    }

    public void setIops(Integer iops) {
        this.iops = iops;
    }

    public String getOptionGroupName() {
        return this.optionGroupName;
    }

    public void setOptionGroupName(String optionGroupName) {
        this.optionGroupName = optionGroupName;
    }

    public Boolean getPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    public void setPubliclyAccessible(Boolean publiclyAccessible) {
        this.publiclyAccessible = publiclyAccessible;
    }

    public String getCharacterSetName() {
        return this.characterSetName;
    }

    public void setCharacterSetName(String characterSetName) {
        this.characterSetName = characterSetName;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    public String getTdeCredentialArn() {
        return this.tdeCredentialArn;
    }

    public void setTdeCredentialArn(String tdeCredentialArn) {
        this.tdeCredentialArn = tdeCredentialArn;
    }

    public String getTdeCredentialPassword() {
        return this.tdeCredentialPassword;
    }

    public void setTdeCredentialPassword(String tdeCredentialPassword) {
        this.tdeCredentialPassword = tdeCredentialPassword;
    }

    public Boolean getStorageEncrypted() {
        return this.storageEncrypted;
    }

    public void setStorageEncrypted(Boolean storageEncrypted) {
        this.storageEncrypted = storageEncrypted;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public Boolean getCopyTagsToSnapshot() {
        return this.copyTagsToSnapshot;
    }

    public void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
        this.copyTagsToSnapshot = copyTagsToSnapshot;
    }

    public Integer getPromotionTier() {
        return this.promotionTier;
    }

    public void setPromotionTier(Integer promotionTier) {
        this.promotionTier = promotionTier;
    }

    public String getDbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public void setDbClusterIdentifier(String dbClusterIdentifier) {
        this.dbClusterIdentifier = dbClusterIdentifier;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public List<String> getSecurityGroups() {
        return this.securityGroups;
    }

    public void setSecurityGroups(List<String> securityGroups) {
        this.securityGroups = securityGroups;
    }

    public DBInstance getDbInstance() {
        return this.dbInstance;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }
}

