/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.lambda;

import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.DeleteFunctionRequest;
import java.io.FileNotFoundException;
import java.io.IOException;
import jp.classmethod.aws.gradle.lambda.AWSLambdaPluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AWSLambdaDeleteFunctionTask
extends ConventionTask {
    private String functionName;

    public AWSLambdaDeleteFunctionTask() {
        this.setDescription("Delete Lambda function.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void deleteFunction() throws FileNotFoundException, IOException {
        String functionName = this.getFunctionName();
        if (functionName == null) {
            throw new GradleException("functionName is required");
        }
        AWSLambdaPluginExtension ext = (AWSLambdaPluginExtension)this.getProject().getExtensions().getByType(AWSLambdaPluginExtension.class);
        AWSLambda lambda = (AWSLambda)ext.getClient();
        DeleteFunctionRequest request = new DeleteFunctionRequest().withFunctionName(functionName);
        lambda.deleteFunction(request);
        this.getLogger().info("Delete Lambda function requested: {}", (Object)functionName);
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }
}

