/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.lambda;

import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.AliasRoutingConfiguration;
import com.amazonaws.services.lambda.model.CreateAliasRequest;
import com.amazonaws.services.lambda.model.CreateAliasResult;
import groovy.lang.Closure;
import jp.classmethod.aws.gradle.lambda.AWSLambdaPluginExtension;
import jp.classmethod.aws.gradle.lambda.RoutingConfig;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AWSLambdaCreateAliasTask
extends ConventionTask {
    private String functionName;
    private String aliasName;
    private String functionVersion;
    private String aliasDescription;
    private RoutingConfig routingConfig;
    private CreateAliasResult createAliasResult;

    @TaskAction
    public void createAlias() {
        String functionName = this.getFunctionName();
        String aliasName = this.getAliasName();
        String functionVersion = this.getFunctionVersion();
        if (functionName == null) {
            throw new GradleException("functionName is required");
        }
        if (aliasName == null) {
            throw new GradleException("name for alias is required");
        }
        if (functionVersion == null) {
            throw new GradleException("functionVersion for alias is required");
        }
        CreateAliasRequest request = new CreateAliasRequest().withFunctionName(functionName).withFunctionVersion(functionVersion).withName(aliasName);
        AWSLambda lambda = this.getAwsLambdaClient();
        if (this.getDescription() != null) {
            request.withDescription(this.getDescription());
        }
        if (this.getRoutingConfig() != null) {
            RoutingConfig routingConfig = this.getRoutingConfig();
            AliasRoutingConfiguration aliasRoutingConfiguration = routingConfig.getAliasRoutingConfiguration(functionName, functionVersion);
            request.withRoutingConfig(aliasRoutingConfiguration);
        }
        this.createAliasResult = lambda.createAlias(request);
    }

    private AWSLambda getAwsLambdaClient() {
        AWSLambdaPluginExtension ext = (AWSLambdaPluginExtension)this.getProject().getExtensions().getByType(AWSLambdaPluginExtension.class);
        return (AWSLambda)ext.getClient();
    }

    public void routingConfig(Closure<RoutingConfig> c) {
        c.setResolveStrategy(1);
        if (this.routingConfig == null) {
            this.routingConfig = new RoutingConfig();
        }
        c.setDelegate((Object)this.routingConfig);
        c.call();
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public void setAliasName(String aliasName) {
        this.aliasName = aliasName;
    }

    public String getFunctionVersion() {
        return this.functionVersion;
    }

    public void setFunctionVersion(String functionVersion) {
        this.functionVersion = functionVersion;
    }

    public String getAliasDescription() {
        return this.aliasDescription;
    }

    public void setAliasDescription(String aliasDescription) {
        this.aliasDescription = aliasDescription;
    }

    public RoutingConfig getRoutingConfig() {
        return this.routingConfig;
    }

    public void setRoutingConfig(RoutingConfig routingConfig) {
        this.routingConfig = routingConfig;
    }

    public CreateAliasResult getCreateAliasResult() {
        return this.createAliasResult;
    }
}

