/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.elasticbeanstalk;

import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsResult;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentDescription;
import com.amazonaws.services.elasticbeanstalk.model.ListAvailableSolutionStacksResult;
import groovy.lang.Closure;
import java.util.List;
import jp.classmethod.aws.gradle.common.BaseRegionAwarePluginExtension;
import jp.classmethod.aws.gradle.elasticbeanstalk.EbAppVersionExtension;
import jp.classmethod.aws.gradle.elasticbeanstalk.EbConfigurationTemplateExtension;
import jp.classmethod.aws.gradle.elasticbeanstalk.EbEnvironmentExtension;
import jp.classmethod.aws.gradle.elasticbeanstalk.Tier;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;

public class AwsBeanstalkPluginExtension
extends BaseRegionAwarePluginExtension<AWSElasticBeanstalkClient> {
    public static final String NAME = "beanstalk";
    private String appName;
    private String appDesc = "";
    private EbAppVersionExtension version;
    private NamedDomainObjectContainer<EbConfigurationTemplateExtension> configurationTemplates;
    private EbEnvironmentExtension environment;
    private Tier tier = Tier.WebServer;

    public void version(Closure<?> closure) {
        closure.setResolveStrategy(1);
        closure.setDelegate((Object)this.version);
        closure.call();
    }

    public void configurationTemplates(Closure<?> closure) {
        this.configurationTemplates.configure(closure);
    }

    public void environment(Closure<?> closure) {
        this.environment.configure(closure);
    }

    public AwsBeanstalkPluginExtension(Project project) {
        super(project, AWSElasticBeanstalkClient.class);
        this.version = new EbAppVersionExtension();
        this.configurationTemplates = project.container(EbConfigurationTemplateExtension.class);
        this.environment = new EbEnvironmentExtension();
    }

    public String getEbEnvironmentCNAME(String environmentName) {
        DescribeEnvironmentsResult der = ((AWSElasticBeanstalkClient)this.getClient()).describeEnvironments(new DescribeEnvironmentsRequest().withApplicationName(this.appName).withEnvironmentNames(new String[]{environmentName}));
        EnvironmentDescription env = (EnvironmentDescription)der.getEnvironments().get(0);
        return env.getCNAME();
    }

    public List<EnvironmentDescription> getEnvironmentDescs(List<String> environmentNames) {
        DescribeEnvironmentsRequest req = new DescribeEnvironmentsRequest().withApplicationName(this.appName);
        if (!environmentNames.isEmpty()) {
            req.setEnvironmentNames(environmentNames);
        }
        DescribeEnvironmentsResult der = ((AWSElasticBeanstalkClient)this.getClient()).describeEnvironments(req);
        return der.getEnvironments();
    }

    public String getElbName(EnvironmentDescription env) {
        String elbName = env.getEndpointURL();
        elbName = elbName.substring(0, elbName.indexOf(46));
        elbName = elbName.substring(0, elbName.lastIndexOf(45));
        return elbName;
    }

    public String latestSolutionStackName(String os, String platform) {
        ListAvailableSolutionStacksResult lassr = ((AWSElasticBeanstalkClient)this.getClient()).listAvailableSolutionStacks();
        return lassr.getSolutionStacks().stream().filter(n -> n.startsWith(os) && n.contains(" running " + platform)).findFirst().orElse(null);
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppDesc() {
        return this.appDesc;
    }

    public void setAppDesc(String appDesc) {
        this.appDesc = appDesc;
    }

    public EbAppVersionExtension getVersion() {
        return this.version;
    }

    public NamedDomainObjectContainer<EbConfigurationTemplateExtension> getConfigurationTemplates() {
        return this.configurationTemplates;
    }

    public EbEnvironmentExtension getEnvironment() {
        return this.environment;
    }

    public Tier getTier() {
        return this.tier;
    }

    public void setTier(Tier tier) {
        this.tier = tier;
    }
}

