/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.elasticbeanstalk;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import jp.classmethod.aws.gradle.AwsPlugin;
import jp.classmethod.aws.gradle.elasticbeanstalk.AWSElasticBeanstalkCleanupApplicationVersionTask;
import jp.classmethod.aws.gradle.elasticbeanstalk.AWSElasticBeanstalkCreateApplicationTask;
import jp.classmethod.aws.gradle.elasticbeanstalk.AWSElasticBeanstalkCreateApplicationVersionTask;
import jp.classmethod.aws.gradle.elasticbeanstalk.AWSElasticBeanstalkCreateConfigurationTemplateTask;
import jp.classmethod.aws.gradle.elasticbeanstalk.AWSElasticBeanstalkCreateEnvironmentTask;
import jp.classmethod.aws.gradle.elasticbeanstalk.AWSElasticBeanstalkDeleteApplicationTask;
import jp.classmethod.aws.gradle.elasticbeanstalk.AWSElasticBeanstalkTerminateEnvironmentTask;
import jp.classmethod.aws.gradle.elasticbeanstalk.AWSElasticBeanstalkWaitEnvironmentStatusTask;
import jp.classmethod.aws.gradle.elasticbeanstalk.AwsBeanstalkPluginExtension;
import jp.classmethod.aws.gradle.elasticbeanstalk.EbConfigurationTemplateExtension;
import jp.classmethod.aws.gradle.elasticbeanstalk.Tier;
import jp.classmethod.aws.gradle.s3.AmazonS3Plugin;
import jp.classmethod.aws.gradle.s3.AmazonS3ProgressiveFileUploadTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.tasks.bundling.War;

public class AwsBeanstalkPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(AwsPlugin.class);
        project.getPluginManager().apply(AmazonS3Plugin.class);
        project.getExtensions().create("beanstalk", AwsBeanstalkPluginExtension.class, new Object[]{project});
        this.applyTasks(project);
    }

    private void applyTasks(Project project) {
        AwsBeanstalkPluginExtension ebExt = (AwsBeanstalkPluginExtension)project.getExtensions().findByType(AwsBeanstalkPluginExtension.class);
        AWSElasticBeanstalkCreateApplicationTask awsEbMigrateApplication = (AWSElasticBeanstalkCreateApplicationTask)project.getTasks().create("awsEbMigrateApplication", AWSElasticBeanstalkCreateApplicationTask.class, task -> task.doFirst(t -> {
            task.setAppName(ebExt.getAppName());
            task.setAppDesc(ebExt.getAppDesc());
        }));
        AmazonS3ProgressiveFileUploadTask awsUploadWar = (AmazonS3ProgressiveFileUploadTask)project.getTasks().create("awsEbUploadBundle", AmazonS3ProgressiveFileUploadTask.class, task -> {
            War warTask;
            WarPlugin war = (WarPlugin)project.getPlugins().findPlugin(WarPlugin.class);
            War war2 = warTask = war == null ? null : (War)project.getTasks().getByName("war");
            if (war != null) {
                task.dependsOn(new Object[]{warTask});
            }
            task.onlyIf(t -> ebExt.getVersion().getFile() != null || war != null);
            task.doFirst(t -> {
                task.setBucketName(ebExt.getVersion().getBucket());
                task.setKey(ebExt.getVersion().getKey());
                if (warTask != null && ebExt.getVersion().getFile() == null) {
                    task.setFile(warTask.getArchivePath());
                } else {
                    task.setFile(ebExt.getVersion().getFile());
                }
            });
        });
        AWSElasticBeanstalkCreateApplicationVersionTask awsEbCreateApplicationVersion = (AWSElasticBeanstalkCreateApplicationVersionTask)project.getTasks().create("awsEbCreateApplicationVersion", AWSElasticBeanstalkCreateApplicationVersionTask.class, task -> {
            task.dependsOn(new Object[]{awsEbMigrateApplication, awsUploadWar});
            task.doFirst(t -> {
                task.setAppName(ebExt.getAppName());
                task.setVersionLabel(ebExt.getVersion().getLabel());
                task.setBucketName(ebExt.getVersion().getBucket());
                task.setKey(ebExt.getVersion().getKey());
            });
        });
        AWSElasticBeanstalkCreateConfigurationTemplateTask awsEbMigrateConfigurationTemplates = (AWSElasticBeanstalkCreateConfigurationTemplateTask)project.getTasks().create("awsEbMigrateConfigurationTemplates", AWSElasticBeanstalkCreateConfigurationTemplateTask.class, task -> {
            task.dependsOn(new Object[]{awsEbMigrateApplication});
            task.doFirst(t -> {
                task.setAppName(ebExt.getAppName());
                task.setConfigurationTemplates((Collection<EbConfigurationTemplateExtension>)ebExt.getConfigurationTemplates());
            });
        });
        AWSElasticBeanstalkCreateEnvironmentTask awsEbMigrateEnvironment = (AWSElasticBeanstalkCreateEnvironmentTask)project.getTasks().create("awsEbMigrateEnvironment", AWSElasticBeanstalkCreateEnvironmentTask.class, task -> {
            task.dependsOn(new Object[]{awsEbMigrateConfigurationTemplates, awsEbCreateApplicationVersion});
            task.doFirst(t -> {
                task.setAppName(ebExt.getAppName());
                task.setEnvName(ebExt.getEnvironment().getEnvName());
                task.setEnvDesc(ebExt.getEnvironment().getEnvDesc());
                task.setTemplateName(ebExt.getEnvironment().getTemplateName());
                task.setVersionLabel(ebExt.getEnvironment().getVersionLabel());
                task.setTier(ebExt.getTier() != null ? ebExt.getTier() : Tier.WebServer);
                if (!Strings.isNullOrEmpty((String)ebExt.getEnvironment().getCnamePrefix())) {
                    task.setCnamePrefix(ebExt.getEnvironment().getCnamePrefix());
                }
                if (ebExt.getEnvironment().getTags() != null) {
                    task.setTags(ebExt.getEnvironment().getTags());
                }
            });
        });
        AWSElasticBeanstalkTerminateEnvironmentTask awsEbTerminateEnvironment = (AWSElasticBeanstalkTerminateEnvironmentTask)project.getTasks().create("awsEbTerminateEnvironment", AWSElasticBeanstalkTerminateEnvironmentTask.class, task -> task.doFirst(t -> {
            task.setAppName(ebExt.getAppName());
            task.setEnvName(ebExt.getEnvironment().getEnvName());
        }));
        project.getTasks().create("awsEbWaitEnvironmentReady", AWSElasticBeanstalkWaitEnvironmentStatusTask.class, task -> {
            task.mustRunAfter(new Object[]{awsEbMigrateEnvironment});
            task.doFirst(t -> {
                task.setAppName(ebExt.getAppName());
                task.setEnvName(ebExt.getEnvironment().getEnvName());
            });
        });
        AWSElasticBeanstalkWaitEnvironmentStatusTask awsEbWaitEnvironmentTerminated = (AWSElasticBeanstalkWaitEnvironmentStatusTask)project.getTasks().create("awsEbWaitEnvironmentTerminated", AWSElasticBeanstalkWaitEnvironmentStatusTask.class, task -> {
            task.mustRunAfter(new Object[]{awsEbTerminateEnvironment});
            task.doFirst(t -> {
                task.setAppName(ebExt.getAppName());
                task.setEnvName(ebExt.getEnvironment().getEnvName());
                task.setSuccessStatuses(Arrays.asList("Terminated"));
                task.setWaitStatuses(Arrays.asList("Launching", "Updating", "Terminating", "Ready"));
            });
        });
        Task awsEbTerminateEnvironmentAndWaitTerminated = project.getTasks().create("awsEbTerminateEnvironmentAndWaitTerminated").dependsOn(new Object[]{awsEbTerminateEnvironment, awsEbWaitEnvironmentTerminated});
        project.getTasks().create("awsEbCleanupApplicationVersions", AWSElasticBeanstalkCleanupApplicationVersionTask.class, task -> task.doFirst(t -> task.setAppName(ebExt.getAppName())));
        project.getTasks().create("awsEbDeleteApplication", AWSElasticBeanstalkDeleteApplicationTask.class, task -> {
            task.dependsOn(new Object[]{awsEbTerminateEnvironmentAndWaitTerminated});
            task.doFirst(t -> task.setAppName(ebExt.getAppName()));
        });
    }
}

