/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.elasticbeanstalk;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsResult;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentDescription;
import java.util.Arrays;
import java.util.List;
import jp.classmethod.aws.gradle.elasticbeanstalk.AwsBeanstalkPluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AWSElasticBeanstalkWaitEnvironmentStatusTask
extends ConventionTask {
    private String appName;
    private String envName;
    private List<String> successStatuses = Arrays.asList("Ready", "Terminated");
    private List<String> waitStatuses = Arrays.asList("Launching", "Updating", "Terminating");
    private int loopTimeout = 900;
    private int loopWait = 10;

    public AWSElasticBeanstalkWaitEnvironmentStatusTask() {
        this.setDescription("Wait ElasticBeanstalk environment for specific status.");
        this.setGroup("AWS");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TaskAction
    public void waitEnvironmentForStatus() {
        String appName = this.getAppName();
        String envName = this.getEnvName();
        int loopTimeout = this.getLoopTimeout();
        int loopWait = this.getLoopWait();
        if (appName == null) {
            throw new GradleException("applicationName is not specified");
        }
        AwsBeanstalkPluginExtension ext = (AwsBeanstalkPluginExtension)this.getProject().getExtensions().getByType(AwsBeanstalkPluginExtension.class);
        AWSElasticBeanstalk eb = (AWSElasticBeanstalk)ext.getClient();
        long start = System.currentTimeMillis();
        while (true) {
            if (System.currentTimeMillis() > start + (long)(loopTimeout * 1000)) {
                throw new GradleException("Timeout");
            }
            try {
                DescribeEnvironmentsResult der = eb.describeEnvironments(new DescribeEnvironmentsRequest().withApplicationName(appName).withEnvironmentNames(new String[]{envName}));
                if (der.getEnvironments() == null || der.getEnvironments().isEmpty()) {
                    this.getLogger().info("environment " + envName + " @ " + appName + " not found");
                    return;
                }
                EnvironmentDescription ed = (EnvironmentDescription)der.getEnvironments().get(0);
                if (this.successStatuses.contains(ed.getStatus())) {
                    this.getLogger().info("Status of environment " + envName + " @ " + appName + " is now " + ed.getStatus() + ".");
                    return;
                }
                if (!this.waitStatuses.contains(ed.getStatus())) throw new GradleException("Status of environment " + envName + " @ " + appName + " is " + ed.getStatus() + ".  It seems to be failed.");
                this.getLogger().info("Status of environment " + envName + " @ " + appName + " is " + ed.getStatus() + "...");
                try {
                    Thread.sleep(loopWait * 1000);
                }
                catch (InterruptedException e) {
                    throw new GradleException("interrupted", (Throwable)e);
                }
            }
            catch (AmazonServiceException e) {
                throw new GradleException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getEnvName() {
        return this.envName;
    }

    public void setEnvName(String envName) {
        this.envName = envName;
    }

    public List<String> getSuccessStatuses() {
        return this.successStatuses;
    }

    public void setSuccessStatuses(List<String> successStatuses) {
        this.successStatuses = successStatuses;
    }

    public List<String> getWaitStatuses() {
        return this.waitStatuses;
    }

    public void setWaitStatuses(List<String> waitStatuses) {
        this.waitStatuses = waitStatuses;
    }

    public int getLoopTimeout() {
        return this.loopTimeout;
    }

    public void setLoopTimeout(int loopTimeout) {
        this.loopTimeout = loopTimeout;
    }

    public int getLoopWait() {
        return this.loopWait;
    }

    public void setLoopWait(int loopWait) {
        this.loopWait = loopWait;
    }
}

