/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.elasticbeanstalk;

import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk;
import com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationVersionRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsResult;
import java.util.List;
import java.util.stream.Collectors;
import jp.classmethod.aws.gradle.elasticbeanstalk.AwsBeanstalkPluginExtension;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AWSElasticBeanstalkCleanupApplicationVersionTask
extends ConventionTask {
    private String appName;
    private boolean deleteSourceBundle = true;

    public AWSElasticBeanstalkCleanupApplicationVersionTask() {
        this.setDescription("Cleanup unused SNAPSHOT ElasticBeanstalk Application Version.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void deleteVersion() {
        String appName = this.getAppName();
        boolean deleteSourceBundle = this.isDeleteSourceBundle();
        AwsBeanstalkPluginExtension ext = (AwsBeanstalkPluginExtension)this.getProject().getExtensions().getByType(AwsBeanstalkPluginExtension.class);
        AWSElasticBeanstalk eb = (AWSElasticBeanstalk)ext.getClient();
        DescribeEnvironmentsResult der = eb.describeEnvironments(new DescribeEnvironmentsRequest().withApplicationName(appName));
        List usingVersions = der.getEnvironments().stream().map(ed -> ed.getVersionLabel()).collect(Collectors.toList());
        DescribeApplicationVersionsResult davr = eb.describeApplicationVersions(new DescribeApplicationVersionsRequest().withApplicationName(appName));
        List<String> versionLabelsToDelete = davr.getApplicationVersions().stream().filter(avd -> !usingVersions.contains(avd.getVersionLabel()) && avd.getVersionLabel().contains("-SNAPSHOT-")).map(avd -> avd.getVersionLabel()).collect(Collectors.toList());
        versionLabelsToDelete.forEach(versionLabel -> {
            this.getLogger().info("version " + versionLabel + " deleted");
            eb.deleteApplicationVersion(new DeleteApplicationVersionRequest().withApplicationName(appName).withVersionLabel(versionLabel).withDeleteSourceBundle(Boolean.valueOf(deleteSourceBundle)));
        });
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public boolean isDeleteSourceBundle() {
        return this.deleteSourceBundle;
    }

    public void setDeleteSourceBundle(boolean deleteSourceBundle) {
        this.deleteSourceBundle = deleteSourceBundle;
    }
}

