/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.common;

import com.amazonaws.AmazonWebServiceClient;
import jp.classmethod.aws.gradle.AwsPluginExtension;
import jp.classmethod.aws.gradle.common.BasePluginExtension;
import org.gradle.api.Project;

public class BaseRegionAwarePluginExtension<T extends AmazonWebServiceClient>
extends BasePluginExtension<T> {
    private String region;

    public BaseRegionAwarePluginExtension(Project project, Class<T> awsClientClass) {
        super(project, awsClientClass);
    }

    @Override
    protected T initClient() {
        AwsPluginExtension aws = (AwsPluginExtension)this.getProject().getExtensions().getByType(AwsPluginExtension.class);
        Object client = super.initClient();
        if (this.isRegionRequired() || this.region != null) {
            client.setRegion(aws.getActiveRegion(this.region));
        }
        return client;
    }

    protected boolean isRegionRequired() {
        return true;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }
}

