/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.cloudformation;

import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.DescribeStacksRequest;
import com.amazonaws.services.cloudformation.model.DescribeStacksResult;
import com.amazonaws.services.cloudformation.model.Stack;
import java.util.List;
import jp.classmethod.aws.gradle.cloudformation.StatusWaiter;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;

public class StackStatusWaiter
extends StatusWaiter {
    private final List<String> successStatuses;
    private final List<String> waitStatuses;

    public StackStatusWaiter(AmazonCloudFormation cfn, String stackName, Logger logger, List<String> successStatuses, List<String> waitStatuses, int loopTimeout, int loopWait) {
        super(cfn, stackName, logger, loopTimeout, loopWait);
        this.successStatuses = successStatuses;
        this.waitStatuses = waitStatuses;
    }

    @Override
    public StatusWaiter.GetStatusResult getStatus() {
        DescribeStacksRequest describeStackRequest = new DescribeStacksRequest().withStackName(this.stackName);
        DescribeStacksResult describeStackResult = this.cfn.describeStacks(describeStackRequest);
        Stack stack = (Stack)describeStackResult.getStacks().get(0);
        if (stack == null) {
            throw new GradleException("stack " + this.stackName + " does not exist");
        }
        String status = stack.getStackStatus();
        if (this.successStatuses.contains(status)) {
            this.printOutputs(stack);
            return StatusWaiter.GetStatusResult.SUCCESS;
        }
        if (this.waitStatuses.contains(status)) {
            return StatusWaiter.GetStatusResult.WAITING;
        }
        return StatusWaiter.GetStatusResult.FAILURE;
    }

    @Override
    public String describeSubject() {
        return "stack " + this.stackName;
    }

    private void printOutputs(Stack stack) {
        this.logger.info("==== Outputs ====");
        stack.getOutputs().stream().forEach(o -> this.logger.info("{} ({}) = {}", new Object[]{o.getOutputKey(), o.getDescription(), o.getOutputValue()}));
    }
}

