/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.cloudformation;

import java.io.IOException;
import jp.classmethod.aws.gradle.cloudformation.AmazonCloudFormationPluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonCloudFormationValidateTemplateUrlTask
extends ConventionTask {
    private String cfnTemplateUrl;

    public AmazonCloudFormationValidateTemplateUrlTask() {
        this.setDescription("Validate template URL.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void validateTemplateUrl() throws InterruptedException, IOException {
        String cfnTemplateUrl = this.getCfnTemplateUrl();
        AmazonCloudFormationPluginExtension ext = (AmazonCloudFormationPluginExtension)this.getProject().getExtensions().getByType(AmazonCloudFormationPluginExtension.class);
        if (!ext.isValidTemplateUrl(cfnTemplateUrl)) {
            throw new GradleException("cloudFormation template has invalid format");
        }
    }

    public String getCfnTemplateUrl() {
        return this.cfnTemplateUrl;
    }

    public void setCfnTemplateUrl(String cfnTemplateUrl) {
        this.cfnTemplateUrl = cfnTemplateUrl;
    }
}

