/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.cloudformation;

import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.UpdateTerminationProtectionRequest;
import jp.classmethod.aws.gradle.cloudformation.AmazonCloudFormationPluginExtension;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonCloudFormationStackTerminationProtectionTask
extends ConventionTask {
    private String stackName;
    private boolean terminationProtected = false;

    public AmazonCloudFormationStackTerminationProtectionTask() {
        this.setDescription("Update CloudFormation stack termination protection");
        this.setGroup("AWS");
    }

    @TaskAction
    public void setStackTerminationProtection() {
        AmazonCloudFormationPluginExtension ext = (AmazonCloudFormationPluginExtension)this.getProject().getExtensions().getByType(AmazonCloudFormationPluginExtension.class);
        AmazonCloudFormation cfn = (AmazonCloudFormation)ext.getClient();
        String stackName = this.getStackName();
        boolean isTerminationProtected = this.isTerminationProtected();
        this.getLogger().info("updating termination protection for stack " + stackName + " to " + isTerminationProtected);
        cfn.updateTerminationProtection(new UpdateTerminationProtectionRequest().withEnableTerminationProtection(Boolean.valueOf(isTerminationProtected)).withStackName(stackName));
    }

    public String getStackName() {
        return this.stackName;
    }

    public void setStackName(String stackName) {
        this.stackName = stackName;
    }

    public boolean isTerminationProtected() {
        return this.terminationProtected;
    }

    public void setTerminationProtected(boolean terminationProtected) {
        this.terminationProtected = terminationProtected;
    }
}

