/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.cloudformation;

import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.cloudformation.model.Tag;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.stream.Collectors;
import jp.classmethod.aws.gradle.AwsPlugin;
import jp.classmethod.aws.gradle.cloudformation.AmazonCloudFormationCreateChangeSetTask;
import jp.classmethod.aws.gradle.cloudformation.AmazonCloudFormationDeleteStackTask;
import jp.classmethod.aws.gradle.cloudformation.AmazonCloudFormationExecuteChangeSetTask;
import jp.classmethod.aws.gradle.cloudformation.AmazonCloudFormationMigrateStackTask;
import jp.classmethod.aws.gradle.cloudformation.AmazonCloudFormationPluginExtension;
import jp.classmethod.aws.gradle.cloudformation.AmazonCloudFormationStackPolicyTask;
import jp.classmethod.aws.gradle.cloudformation.AmazonCloudFormationStackTerminationProtectionTask;
import jp.classmethod.aws.gradle.cloudformation.AmazonCloudFormationValidateTemplateUrlTask;
import jp.classmethod.aws.gradle.cloudformation.AmazonCloudFormationWaitChangeSetStatusTask;
import jp.classmethod.aws.gradle.cloudformation.AmazonCloudFormationWaitStackStatusTask;
import jp.classmethod.aws.gradle.s3.AmazonS3FileUploadTask;
import jp.classmethod.aws.gradle.s3.AmazonS3Plugin;
import org.apache.commons.io.FilenameUtils;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class AmazonCloudFormationPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(AwsPlugin.class);
        project.getPluginManager().apply(AmazonS3Plugin.class);
        project.getExtensions().create("cloudFormation", AmazonCloudFormationPluginExtension.class, new Object[]{project});
        this.applyTasks(project);
    }

    private void applyTasks(Project project) {
        AmazonCloudFormationPluginExtension cfnExt = (AmazonCloudFormationPluginExtension)project.getExtensions().findByType(AmazonCloudFormationPluginExtension.class);
        AmazonS3FileUploadTask awsCfnUploadTemplate = (AmazonS3FileUploadTask)project.getTasks().create("awsCfnUploadTemplate", AmazonS3FileUploadTask.class, task -> {
            task.setDescription("Upload cfn template file to the Amazon S3 bucket.");
            task.conventionMapping("file", () -> cfnExt.getTemplateFile());
            task.conventionMapping("bucketName", () -> cfnExt.getTemplateBucket());
            task.conventionMapping("key", () -> {
                String name = cfnExt.getTemplateFile().getName();
                return this.createKey(name, project.getVersion(), cfnExt.getTemplateKeyPrefix());
            });
            task.doLast(t -> cfnExt.setTemplateURL(((AmazonS3FileUploadTask)((Object)((Object)t))).getResourceUrl()));
        });
        AmazonS3FileUploadTask awsCfnUploadPolicy = (AmazonS3FileUploadTask)project.getTasks().create("awsCfnUploadStackPolicy", AmazonS3FileUploadTask.class, task -> {
            task.setDescription("Upload cfn stack policy file to the Amazon S3 bucket.");
            task.conventionMapping("file", () -> cfnExt.getStackPolicyFile());
            task.conventionMapping("bucketName", () -> cfnExt.getStackPolicyBucket());
            task.conventionMapping("key", () -> {
                String name = cfnExt.getStackPolicyFile().getName();
                return this.createKey(name, project.getVersion(), cfnExt.getStackPolicyKeyPrefix());
            });
            task.doLast(t -> cfnExt.setStackPolicyURL(((AmazonS3FileUploadTask)((Object)((Object)t))).getResourceUrl()));
        });
        AmazonCloudFormationMigrateStackTask awsCfnMigrateStack = (AmazonCloudFormationMigrateStackTask)project.getTasks().create("awsCfnMigrateStack", AmazonCloudFormationMigrateStackTask.class, task -> {
            task.setDescription("Create/Migrate cfn stack.");
            task.mustRunAfter(new Object[]{awsCfnUploadTemplate});
            task.mustRunAfter(new Object[]{awsCfnUploadPolicy});
            task.conventionMapping("stackName", () -> cfnExt.getStackName());
            task.conventionMapping("capabilityIam", () -> cfnExt.isCapabilityIam());
            task.conventionMapping("useCapabilityIam", () -> cfnExt.getUseCapabilityIam());
            task.conventionMapping("cfnStackParams", () -> cfnExt.getStackParams().entrySet().stream().map(it -> new Parameter().withParameterKey(it.getKey().toString()).withParameterValue(it.getValue().toString())).collect(Collectors.toList()));
            task.conventionMapping("cfnStackTags", () -> cfnExt.getStackTags().entrySet().stream().map(it -> new Tag().withKey(it.getKey().toString()).withValue(it.getValue().toString())).collect(Collectors.toList()));
            task.conventionMapping("cfnTemplateUrl", () -> cfnExt.getTemplateURL());
            task.conventionMapping("cfnTemplateFile", () -> cfnExt.getTemplateFile());
            task.conventionMapping("cfnStackPolicyUrl", () -> cfnExt.getStackPolicyURL());
            task.conventionMapping("cfnStackPolicyFile", () -> cfnExt.getStackPolicyFile());
            task.conventionMapping("cfnOnFailure", () -> cfnExt.getOnFailure());
        });
        project.getTasks().create("awsCfnValidateTemplateUrl", AmazonCloudFormationValidateTemplateUrlTask.class, task -> {
            task.setDescription("Validate template URL.");
            task.conventionMapping("cfnTemplateUrl", () -> cfnExt.getTemplateURL());
            task.dependsOn(new Object[]{awsCfnUploadTemplate});
        });
        AmazonCloudFormationCreateChangeSetTask awsCfnCreateChangeSet = (AmazonCloudFormationCreateChangeSetTask)project.getTasks().create("awsCfnCreateChangeSet", AmazonCloudFormationCreateChangeSetTask.class, task -> {
            task.setDescription("Create cfn change set.");
            task.mustRunAfter(new Object[]{awsCfnUploadTemplate});
            task.conventionMapping("stackName", () -> cfnExt.getStackName());
            task.conventionMapping("capabilityIam", () -> cfnExt.isCapabilityIam());
            task.conventionMapping("useCapabilityIam", () -> cfnExt.getUseCapabilityIam());
            task.conventionMapping("cfnStackParams", () -> cfnExt.getStackParams().entrySet().stream().map(it -> new Parameter().withParameterKey(it.getKey().toString()).withParameterValue(it.getValue().toString())).collect(Collectors.toList()));
            task.conventionMapping("cfnStackTags", () -> cfnExt.getStackTags().entrySet().stream().map(it -> new Tag().withKey(it.getKey().toString()).withValue(it.getValue().toString())).collect(Collectors.toList()));
            task.conventionMapping("cfnRoleArn", () -> cfnExt.getCfnRoleArn());
            task.conventionMapping("cfnTemplateUrl", () -> cfnExt.getTemplateURL());
            task.conventionMapping("cfnTemplateFile", () -> cfnExt.getTemplateFile());
        });
        AmazonCloudFormationWaitStackStatusTask awsCfnWaitStackCompleteAfterCreateChangeSet = (AmazonCloudFormationWaitStackStatusTask)project.getTasks().create("awsCfnWaitStackCompleteAfterCreateChangeSet", AmazonCloudFormationWaitStackStatusTask.class, task -> {
            task.setDescription("Wait cfn stack for CREATE_COMPLETE, UPDATE_COMPLETE or REVIEW_IN_PROGRESS status.");
            task.mustRunAfter(new Object[]{awsCfnCreateChangeSet});
            task.setSuccessStatuses(Arrays.asList("CREATE_COMPLETE", "UPDATE_COMPLETE", "REVIEW_IN_PROGRESS"));
            task.conventionMapping("stackName", () -> cfnExt.getStackName());
        });
        AmazonCloudFormationWaitChangeSetStatusTask awsCfnWaitCreateChangeSetComplete = (AmazonCloudFormationWaitChangeSetStatusTask)project.getTasks().create("awsWaitCreateChangeSetComplete", AmazonCloudFormationWaitChangeSetStatusTask.class, task -> {
            task.setDescription("Wait cfn change set for CREATE_COMPLETE status");
            task.mustRunAfter(new Object[]{awsCfnWaitStackCompleteAfterCreateChangeSet});
            task.setSuccessStatuses(Arrays.asList("CREATE_COMPLETE"));
            task.conventionMapping("stackName", () -> cfnExt.getStackName());
        });
        AmazonCloudFormationExecuteChangeSetTask awsCfnExecuteChangeSet = (AmazonCloudFormationExecuteChangeSetTask)project.getTasks().create("awsCfnExecuteChangeSet", AmazonCloudFormationExecuteChangeSetTask.class, task -> {
            task.mustRunAfter(new Object[]{awsCfnWaitCreateChangeSetComplete});
            task.setDescription("execute latest cfn change set.");
            task.conventionMapping("stackName", () -> cfnExt.getStackName());
        });
        project.getTasks().create("awsCfnWaitStackReady", AmazonCloudFormationWaitStackStatusTask.class, task -> {
            task.setDescription("Wait cfn stack for *_COMPLETE status.");
            task.mustRunAfter(new Object[]{awsCfnMigrateStack});
            task.conventionMapping("stackName", () -> cfnExt.getStackName());
        });
        AmazonCloudFormationWaitStackStatusTask awsCfnWaitStackComplete = (AmazonCloudFormationWaitStackStatusTask)project.getTasks().create("awsCfnWaitStackComplete", AmazonCloudFormationWaitStackStatusTask.class, task -> {
            task.setDescription("Wait cfn stack for CREATE_COMPLETE or UPDATE_COMPLETE status.");
            task.mustRunAfter(new Object[]{awsCfnMigrateStack});
            task.mustRunAfter(new Object[]{awsCfnExecuteChangeSet});
            task.setSuccessStatuses(Arrays.asList("CREATE_COMPLETE", "UPDATE_COMPLETE"));
            task.conventionMapping("stackName", () -> cfnExt.getStackName());
        });
        project.getTasks().create("awsCfnMigrateStackAndWaitCompleted").dependsOn(new Object[]{awsCfnMigrateStack, awsCfnWaitStackComplete}).setDescription("Create/Migrate cfn stack, and wait stack for CREATE_COMPLETE or UPDATE_COMPLETE status.");
        project.getTasks().create("awsCfnDeploy").dependsOn(new Object[]{awsCfnCreateChangeSet, awsCfnWaitStackCompleteAfterCreateChangeSet, awsCfnWaitCreateChangeSetComplete, awsCfnExecuteChangeSet, awsCfnWaitStackComplete}).setDescription("Create and execute a change set, waiting for completion. Useful for deploying CloudFormation templatescontaining transforms.");
        AmazonCloudFormationDeleteStackTask awsCfnDeleteStack = (AmazonCloudFormationDeleteStackTask)project.getTasks().create("awsCfnDeleteStack", AmazonCloudFormationDeleteStackTask.class, task -> {
            task.setDescription("Delete cfn stack.");
            task.conventionMapping("stackName", () -> cfnExt.getStackName());
        });
        AmazonCloudFormationWaitStackStatusTask awsCfnWaitStackDeleted = (AmazonCloudFormationWaitStackStatusTask)project.getTasks().create("awsCfnWaitStackDeleted", AmazonCloudFormationWaitStackStatusTask.class, task -> {
            task.setDescription("Wait cfn stack for DELETE_COMPLETE status.");
            task.mustRunAfter(new Object[]{awsCfnDeleteStack});
            task.setSuccessStatuses(Arrays.asList("DELETE_COMPLETE"));
            task.conventionMapping("stackName", () -> cfnExt.getStackName());
        });
        project.getTasks().create("awsCfnDeleteStackAndWaitCompleted").dependsOn(new Object[]{awsCfnDeleteStack, awsCfnWaitStackDeleted}).setDescription("Delete cfn stack, and wait stack for DELETE_COMPLETE status.");
        project.getTasks().create("awsCfnUpdateStackTerminationProtection", AmazonCloudFormationStackTerminationProtectionTask.class, task -> {
            task.setDescription("Update CloudFormation stack termination protection");
            task.conventionMapping("stackName", () -> cfnExt.getStackName());
            task.conventionMapping("terminationProtected", () -> cfnExt.isTerminationProtected());
        });
        project.getTasks().create("awsCfnSetStackPolicy", AmazonCloudFormationStackPolicyTask.class, task -> {
            task.setDescription("Set CloudFormation stack policy");
            task.conventionMapping("stackName", () -> cfnExt.getStackName());
            task.conventionMapping("cfnStackPolicyUrl", () -> cfnExt.getStackPolicyURL());
            task.conventionMapping("cfnStackPolicyFile", () -> cfnExt.getStackPolicyFile());
        });
    }

    private String createKey(String name, Object version, String prefix) {
        String path = name.substring(FilenameUtils.getPrefix((String)name).length());
        String baseName = FilenameUtils.getBaseName((String)name);
        String extension = FilenameUtils.getExtension((String)name);
        return String.format(Locale.ENGLISH, "%s/%s/%s-%s-%s%s", prefix, path, baseName, version, this.createTimestamp(), extension.length() > 0 ? "." + extension : "");
    }

    private String createTimestamp() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'_'HHmmss", Locale.ENGLISH);
        sdf.setTimeZone(TimeZone.getDefault());
        return sdf.format(new Date());
    }
}

