/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.cloudformation;

import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.DeleteStackRequest;
import jp.classmethod.aws.gradle.cloudformation.AmazonCloudFormationPluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonCloudFormationDeleteStackTask
extends ConventionTask {
    private String stackName;

    public AmazonCloudFormationDeleteStackTask() {
        this.setDescription("Delete cfn stack.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void deleteStack() {
        String stackName = this.getStackName();
        if (stackName == null) {
            throw new GradleException("stackName is not specified");
        }
        AmazonCloudFormationPluginExtension ext = (AmazonCloudFormationPluginExtension)this.getProject().getExtensions().getByType(AmazonCloudFormationPluginExtension.class);
        AmazonCloudFormation cfn = (AmazonCloudFormation)ext.getClient();
        cfn.deleteStack(new DeleteStackRequest().withStackName(stackName));
        this.getLogger().info("delete stack " + stackName + " requested");
    }

    public String getStackName() {
        return this.stackName;
    }

    public void setStackName(String stackName) {
        this.stackName = stackName;
    }
}

