/*
 * Decompiled with CFR 0.152.
 */
package javax.security.identitystore;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.security.CallerPrincipal;

public class CredentialValidationResult {
    public static final CredentialValidationResult INVALID_RESULT = new CredentialValidationResult(Status.INVALID);
    public static final CredentialValidationResult NOT_VALIDATED_RESULT = new CredentialValidationResult(Status.NOT_VALIDATED);
    private final Status status;
    private final String storeId;
    private final String callerUniqueId;
    private final CallerPrincipal callerPrincipal;
    private final Set<String> groups;

    private CredentialValidationResult(Status status) {
        this(status, null, null, null, null);
    }

    public CredentialValidationResult(String callerName) {
        this(new CallerPrincipal(callerName), null);
    }

    public CredentialValidationResult(CallerPrincipal callerPrincipal) {
        this(callerPrincipal, null);
    }

    public CredentialValidationResult(String callerName, Set<String> groups) {
        this(new CallerPrincipal(callerName), groups);
    }

    public CredentialValidationResult(CallerPrincipal callerPrincipal, Set<String> groups) {
        this(null, callerPrincipal, null, groups);
    }

    public CredentialValidationResult(String storeId, String callerName, String callerUniqueId, Set<String> groups) {
        this(storeId, new CallerPrincipal(callerName), callerUniqueId, groups);
    }

    public CredentialValidationResult(String storeId, CallerPrincipal callerPrincipal, String callerUniqueId, Set<String> groups) {
        this(Status.VALID, storeId, callerPrincipal, callerUniqueId, groups);
    }

    private CredentialValidationResult(Status status, String storeId, CallerPrincipal callerPrincipal, String callerUniqueId, Set<String> groups) {
        if (status != Status.VALID && (storeId != null || callerPrincipal != null || callerUniqueId != null || groups != null)) {
            throw new IllegalArgumentException("Bad status");
        }
        if (status == Status.VALID && (callerPrincipal == null || callerPrincipal.getName().trim().isEmpty())) {
            throw new IllegalArgumentException("Null or empty CallerPrincipal");
        }
        this.status = Status.VALID;
        this.storeId = storeId;
        this.callerPrincipal = callerPrincipal;
        this.callerUniqueId = callerUniqueId;
        this.groups = groups != null ? Collections.unmodifiableSet(new HashSet<String>(groups)) : Collections.emptySet();
    }

    public Status getStatus() {
        return this.status;
    }

    public String getIdentityStoreId() {
        return this.storeId;
    }

    public CallerPrincipal getCallerPrincipal() {
        return this.callerPrincipal;
    }

    public String getCallerUniqueId() {
        return this.callerUniqueId;
    }

    public Set<String> getCallerGroups() {
        return this.groups;
    }

    public static enum Status {
        NOT_VALIDATED,
        INVALID,
        VALID;

    }
}

