/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.provider.h2;

import io.zonky.test.db.provider.support.AbstractEmbeddedDatabase;
import javax.sql.DataSource;
import org.h2.tools.Server;

public class H2EmbeddedDatabase
extends AbstractEmbeddedDatabase {
    private final Server server;
    private final DataSource dataSource;
    private final String dbName;

    public H2EmbeddedDatabase(Server server, DataSource dataSource, String dbName, Runnable closeCallback) {
        super(closeCallback);
        this.server = server;
        this.dataSource = dataSource;
        this.dbName = dbName;
    }

    @Override
    protected DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public String getJdbcUrl() {
        if (this.server != null) {
            return String.format("jdbc:h2:tcp://localhost:%s/mem:%s;USER=sa", this.server.getPort(), this.dbName);
        }
        return String.format("jdbc:h2:mem:%s;USER=sa", this.dbName);
    }

    public String getDatabaseName() {
        return this.dbName;
    }

    public int getPortNumber() {
        if (this.server != null) {
            return this.server.getPort();
        }
        return 0;
    }
}

