/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.config;

import io.zonky.test.db.config.ConditionalOnMissingBean;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.MultiValueMap;

@Order(value=0x7FFFFFFF)
class OnBeanCondition
implements ConfigurationCondition {
    OnBeanCondition() {
    }

    public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
        return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
    }

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        List<String> candidates = this.getCandidates(metadata, ConditionalOnMissingBean.class);
        for (String beanName : candidates) {
            if (!beanFactory.containsBean(beanName)) continue;
            return false;
        }
        return true;
    }

    private List<String> getCandidates(AnnotatedTypeMetadata metadata, Class<?> annotationType) {
        MultiValueMap attributes = metadata.getAllAnnotationAttributes(annotationType.getName(), true);
        if (attributes == null || attributes.get((Object)"name") == null) {
            throw new IllegalStateException("@ConditionalOnMissingBean did not specify a bean name");
        }
        return ((List)attributes.get((Object)"name")).stream().flatMap(o -> Arrays.stream((String[])o)).collect(Collectors.toList());
    }
}

