/*
 * Decompiled with CFR 0.152.
 */
package io.wusa;

import io.wusa.IVersionFactory;
import io.wusa.Suffix;
import io.wusa.Version;
import io.wusa.exception.NoValidSemverTagFoundException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0007H\u0002J\"\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/wusa/SemanticVersionFactory;", "Lio/wusa/IVersionFactory;", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "suffixRegex", "Lkotlin/text/Regex;", "versionRegex", "createFromString", "Lio/wusa/Version;", "describe", "", "parseSuffix", "Lio/wusa/Suffix;", "parseVersion", "version", "removeSuffixFromDescribe", "suffix", "semver-git-plugin"})
public final class SemanticVersionFactory
implements IVersionFactory {
    private final Logger LOG = LoggerFactory.getLogger(SemanticVersionFactory.class);
    private final Regex suffixRegex;
    private final Regex versionRegex;

    @Override
    @NotNull
    public Version createFromString(@NotNull String describe) throws NoValidSemverTagFoundException {
        Intrinsics.checkParameterIsNotNull((Object)describe, (String)"describe");
        try {
            Suffix suffix = this.parseSuffix(this.suffixRegex, describe);
            String version = this.removeSuffixFromDescribe(describe, suffix, this.suffixRegex);
            Version parsedVersion = this.parseVersion(version, this.versionRegex);
            parsedVersion.setSuffix(suffix);
            return parsedVersion;
        }
        catch (IllegalArgumentException ex) {
            throw (Throwable)new NoValidSemverTagFoundException("The last tag is not a semantic version: " + describe + '.');
        }
    }

    private final String removeSuffixFromDescribe(String describe, Suffix suffix, Regex suffixRegex) {
        String version = describe;
        if (suffix != null) {
            version = suffixRegex.replace((CharSequence)describe, "");
        }
        return version;
    }

    private final Suffix parseSuffix(Regex suffixRegex, String describe) {
        Suffix suffix;
        MatchResult matchResult = Regex.find$default((Regex)suffixRegex, (CharSequence)describe, (int)0, (int)2, null);
        if (matchResult != null && (matchResult = matchResult.getDestructured()) != null) {
            boolean bl;
            MatchResult matchResult2 = matchResult;
            boolean bl2 = false;
            boolean bl3 = false;
            MatchResult $count_sha_dirty = matchResult2;
            boolean bl4 = false;
            Object object = $count_sha_dirty;
            boolean bl5 = false;
            String count = (String)object.getMatch().getGroupValues().get(1);
            object = $count_sha_dirty;
            bl5 = false;
            String sha = (String)object.getMatch().getGroupValues().get(2);
            object = $count_sha_dirty;
            bl5 = false;
            String dirty = (String)object.getMatch().getGroupValues().get(3);
            object = count;
            bl5 = false;
            int n = Integer.parseInt((String)object);
            object = dirty;
            String string = sha;
            bl5 = false;
            boolean bl6 = bl = object.length() > 0;
            String string2 = string;
            int n2 = n;
            suffix = new Suffix(n2, string2, bl6);
        } else {
            suffix = null;
        }
        return suffix;
    }

    private final Version parseVersion(String version, Regex versionRegex) throws IllegalArgumentException {
        MatchResult matchResult = versionRegex.matchEntire((CharSequence)version);
        if (matchResult == null || (matchResult = matchResult.getDestructured()) == null) {
            throw (Throwable)new IllegalArgumentException("Bad input '" + version + '\'');
        }
        MatchResult matchResult2 = matchResult;
        boolean bl = false;
        boolean bl2 = false;
        MatchResult $major_minor_patch_prerelease_build = matchResult2;
        boolean bl3 = false;
        Object object = $major_minor_patch_prerelease_build;
        boolean bl4 = false;
        String major = (String)object.getMatch().getGroupValues().get(1);
        object = $major_minor_patch_prerelease_build;
        bl4 = false;
        String minor = (String)object.getMatch().getGroupValues().get(2);
        object = $major_minor_patch_prerelease_build;
        bl4 = false;
        String patch = (String)object.getMatch().getGroupValues().get(3);
        object = $major_minor_patch_prerelease_build;
        bl4 = false;
        String prerelease = (String)object.getMatch().getGroupValues().get(4);
        object = $major_minor_patch_prerelease_build;
        bl4 = false;
        String build = (String)object.getMatch().getGroupValues().get(5);
        object = major;
        bl4 = false;
        int n = Integer.parseInt((String)object);
        object = minor;
        bl4 = false;
        int n2 = Integer.parseInt((String)object);
        object = patch;
        bl4 = false;
        int n3 = Integer.parseInt((String)object);
        Suffix suffix = null;
        String string = build;
        String string2 = prerelease;
        int n4 = n3;
        int n5 = n2;
        int n6 = n;
        return new Version(n6, n5, n4, string2, string, suffix);
    }

    public SemanticVersionFactory() {
        Regex regex;
        String string = "(?:-(?<count>[0-9]+)(?:-g(?<sha>[0-9a-f]{1,7}))(?<dirty>-dirty)?)$";
        SemanticVersionFactory semanticVersionFactory = this;
        boolean bl = false;
        semanticVersionFactory.suffixRegex = regex = new Regex(string);
        string = "^[vV]?(?<major>0|[1-9]\\d*)\\.(?<minor>0|[1-9]\\d*)\\.(?<patch>0|[1-9]\\d*)(?:-(?<prerelease>(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+(?<build>[a-zA-Z0-9][a-zA-Z0-9\\.-]+)?)?$";
        semanticVersionFactory = this;
        bl = false;
        semanticVersionFactory.versionRegex = regex = new Regex(string);
    }
}

