/*
 * Decompiled with CFR 0.152.
 */
package io.vin.android.scanner.core;

import android.content.Context;
import android.graphics.Point;
import android.hardware.Camera;
import android.os.Build;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Display;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.ViewGroup;
import android.view.WindowManager;
import io.vin.android.scanner.util.DisplayUtils;
import java.util.List;

public class CameraPreview
extends SurfaceView
implements SurfaceHolder.Callback {
    private static final String TAG = "CameraPreview";
    Camera.AutoFocusCallback autoFocusCB = new MyAutoFocusCallback();
    private Runnable doAutoFocus = new AutoFocusRunable();
    private boolean mAutoFocus = true;
    private Handler mAutoFocusHandler;
    private Camera mCamera;
    private Camera.PreviewCallback mPreviewCallback;
    private boolean mPreviewing = true;
    private boolean mSurfaceCreated = false;
    private long autoFocusInterval = 1000L;

    public CameraPreview(Context context) {
        super(context);
    }

    public CameraPreview(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setCamera(Camera camera, Camera.PreviewCallback previewCallback) {
        this.mCamera = camera;
        this.mPreviewCallback = previewCallback;
        this.mAutoFocusHandler = new Handler();
    }

    public void initCameraPreview() {
        if (this.mCamera != null) {
            this.getHolder().addCallback((SurfaceHolder.Callback)this);
            this.getHolder().setType(3);
            if (this.mPreviewing) {
                this.requestLayout();
            } else {
                this.showCameraPreview();
            }
        }
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        this.mSurfaceCreated = true;
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int i, int i2, int i3) {
        if (surfaceHolder.getSurface() != null) {
            this.stopCameraPreview();
            this.showCameraPreview();
        }
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        this.mSurfaceCreated = false;
        this.stopCameraPreview();
    }

    public void showCameraPreview() {
        if (this.mCamera != null) {
            try {
                ViewGroup.LayoutParams params = this.getLayoutParams();
                Display display = ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay();
                Point outSize = new Point();
                if (Build.VERSION.SDK_INT >= 13) {
                    display.getSize(outSize);
                }
                params.width = outSize.x;
                params.height = outSize.y;
                this.setLayoutParams(params);
                this.mPreviewing = true;
                this.setupCameraParameters();
                this.mCamera.setPreviewDisplay(this.getHolder());
                this.mCamera.setDisplayOrientation(this.getDisplayOrientation());
                this.mCamera.setOneShotPreviewCallback(this.mPreviewCallback);
                this.mCamera.startPreview();
                if (this.mAutoFocus) {
                    try {
                        this.mCamera.autoFocus(this.autoFocusCB);
                    }
                    catch (RuntimeException e) {
                        this.mAutoFocusHandler.postDelayed(this.doAutoFocus, this.autoFocusInterval);
                    }
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)e.toString(), (Throwable)e);
            }
        }
    }

    public void stopCameraPreview() {
        if (this.mCamera != null) {
            try {
                this.mPreviewing = false;
                this.mCamera.cancelAutoFocus();
                this.mCamera.setOneShotPreviewCallback(null);
                this.mCamera.stopPreview();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)e.toString(), (Throwable)e);
            }
        }
    }

    public void setupCameraParameters() {
        Camera.Size optimalSize = this.getOptimalPreviewSize();
        Camera.Parameters parameters = this.mCamera.getParameters();
        parameters.setPreviewSize(optimalSize.width, optimalSize.height);
        this.mCamera.setParameters(parameters);
    }

    public int getDisplayOrientation() {
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)0, (Camera.CameraInfo)info);
        int degrees = 0;
        switch (((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay().getRotation()) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if (info.facing == 1) {
            return (360 - (info.orientation + degrees) % 360) % 360;
        }
        return (info.orientation - degrees + 360) % 360;
    }

    private Camera.Size getOptimalPreviewSize() {
        if (this.mCamera == null) {
            return null;
        }
        List sizes = this.mCamera.getParameters().getSupportedPreviewSizes();
        Point screenResolution = DisplayUtils.getScreenResolution(this.getContext());
        int w = 0;
        int h = 0;
        Log.i((String)TAG, (String)("screen ---------> w: " + screenResolution.x + "  h: " + screenResolution.y));
        Log.i((String)TAG, (String)("view ---------> w: " + this.getWidth() + "  h: " + this.getHeight()));
        if (null == null || null == null) {
            w = screenResolution.x;
            h = screenResolution.y;
            if (DisplayUtils.getScreenOrientation(this.getContext()) == 1) {
                w = screenResolution.y;
                h = screenResolution.x;
            }
        }
        double targetRatio = (double)w / (double)h;
        if (sizes == null) {
            return null;
        }
        Camera.Size optimalSize = null;
        double minDiff = Double.MAX_VALUE;
        int targetHeight = h;
        for (Camera.Size size : sizes) {
            if (!(Math.abs((double)size.width / (double)size.height - targetRatio) <= 0.1) || !((double)Math.abs(size.height - targetHeight) < minDiff)) continue;
            optimalSize = size;
            minDiff = Math.abs(size.height - targetHeight);
        }
        if (optimalSize != null) {
            return optimalSize;
        }
        minDiff = Double.MAX_VALUE;
        for (Camera.Size size2 : sizes) {
            if (!((double)Math.abs(size2.height - targetHeight) < minDiff)) continue;
            optimalSize = size2;
            minDiff = Math.abs(size2.height - targetHeight);
        }
        return optimalSize;
    }

    public void setAutoFocus(boolean state) {
        if (this.mCamera != null && this.mPreviewing && state != this.mAutoFocus) {
            this.mAutoFocus = state;
            if (this.mAutoFocus) {
                try {
                    Log.v((String)TAG, (String)"Starting autofocus");
                    this.mCamera.autoFocus(this.autoFocusCB);
                }
                catch (RuntimeException e) {
                    this.mAutoFocusHandler.postDelayed(this.doAutoFocus, 1000L);
                }
                return;
            }
            Log.v((String)TAG, (String)"Cancelling autofocus");
            this.mCamera.cancelAutoFocus();
        }
    }

    public void setAutoFocusInterval(long millisecond) {
        this.autoFocusInterval = millisecond;
    }

    class MyAutoFocusCallback
    implements Camera.AutoFocusCallback {
        MyAutoFocusCallback() {
        }

        public void onAutoFocus(boolean success, Camera camera) {
            CameraPreview.this.mAutoFocusHandler.postDelayed(CameraPreview.this.doAutoFocus, CameraPreview.this.autoFocusInterval);
            Log.d((String)CameraPreview.TAG, (String)"autoFocusCB");
        }
    }

    class AutoFocusRunable
    implements Runnable {
        AutoFocusRunable() {
        }

        @Override
        public void run() {
            if (CameraPreview.this.mCamera != null && CameraPreview.this.mPreviewing && CameraPreview.this.mAutoFocus && CameraPreview.this.mSurfaceCreated) {
                try {
                    CameraPreview.this.mCamera.autoFocus(CameraPreview.this.autoFocusCB);
                }
                catch (RuntimeException e) {
                    CameraPreview.this.mAutoFocusHandler.postDelayed(CameraPreview.this.doAutoFocus, CameraPreview.this.autoFocusInterval);
                }
            }
        }
    }
}

