/*
 * Decompiled with CFR 0.152.
 */
package io.vin.android.scanner.core;

import android.content.Context;
import android.graphics.ImageFormat;
import android.hardware.Camera;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Display;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.WindowManager;
import io.vin.android.scanner.util.DisplayUtils;
import java.util.List;

public class Camera1View
extends SurfaceView
implements SurfaceHolder.Callback {
    private static final String TAG = "Camera1View";
    private static final int STOPPED = 0;
    private static final int STARTED = 1;
    public static final int PARAMETERS_MODE_FULL_MANUAL = 0;
    public static final int PARAMETERS_MODE_SEMI_AUTO = 1;
    public static final int PARAMETERS_MODE_AUTO = 2;
    private boolean mSupportCamera = false;
    private boolean mEnabled = true;
    private boolean mSurfaceExist = false;
    private int mState = 0;
    private final Object mSyncObject = new Object();
    private int mCameraId = -1;
    private Camera mCamera;
    private SurfaceHolder mHolder;
    private Camera.PreviewCallback mPreviewCallback;
    private int mParametersMode = 2;
    private ParametersCallback mParametersCallback;
    private boolean mAutoFocus = false;
    private long mAutoFocusInterval = 1000L;
    private boolean mSupportFocusModeContinuousPicture = false;
    private Handler mAutoFocusHandler;
    private float mAspectTolerance = 0.2f;
    private Runnable doAutoFocus = new Runnable(){

        @Override
        public void run() {
            Camera1View.this.safeAutoFocus();
        }
    };
    Camera.AutoFocusCallback autoFocusCB = new Camera.AutoFocusCallback(){

        public void onAutoFocus(boolean success, Camera camera) {
            if (Camera1View.this.mAutoFocus) {
                Camera1View.this.scheduleAutoFocus();
            }
        }
    };

    public Camera1View(Context context) {
        super(context);
        this.mSupportCamera = this.checkCameraHardware(this.getContext());
        this.initSurfaceHolder();
    }

    public Camera1View(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mSupportCamera = this.checkCameraHardware(this.getContext());
        this.initSurfaceHolder();
    }

    public Camera1View(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mSupportCamera = this.checkCameraHardware(this.getContext());
        this.initSurfaceHolder();
    }

    private void initCamera() {
        if (!this.mSupportCamera) {
            return;
        }
        try {
            int numberOfCameras = Camera.getNumberOfCameras();
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            for (int i = 0; i < numberOfCameras; ++i) {
                Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
                if (cameraInfo.facing != 0) continue;
                this.mCameraId = i;
                this.mCamera = Camera.open((int)i);
                return;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initSurfaceHolder() {
        if (this.getHolder().getSurface() == null) {
            return;
        }
        this.mHolder = this.getHolder();
        this.mHolder.addCallback((SurfaceHolder.Callback)this);
        this.mHolder.setType(3);
    }

    public void surfaceCreated(SurfaceHolder holder) {
        Log.d((String)TAG, (String)"surfaceCreated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
        Log.d((String)TAG, (String)"surfaceChanged");
        Object object = this.mSyncObject;
        synchronized (object) {
            if (!this.mSurfaceExist) {
                this.mSurfaceExist = true;
                this.checkCurrentState();
            } else {
                this.mSurfaceExist = false;
                this.checkCurrentState();
                this.mSurfaceExist = true;
                this.checkCurrentState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void surfaceDestroyed(SurfaceHolder holder) {
        Log.d((String)TAG, (String)"surfaceDestroyed");
        Object object = this.mSyncObject;
        synchronized (object) {
            this.mSurfaceExist = false;
            this.checkCurrentState();
        }
    }

    private void checkCurrentState() {
        Log.d((String)TAG, (String)"call checkCurrentState");
        int targetState = this.mSupportCamera && this.mEnabled && this.mSurfaceExist && this.getVisibility() == 0 ? 1 : 0;
        if (targetState != this.mState) {
            this.processExitState(this.mState);
            this.mState = targetState;
            this.processEnterState(this.mState);
        }
    }

    private void processExitState(int state) {
        Log.d((String)TAG, (String)("call processExitState: " + state));
        switch (state) {
            case 1: {
                this.onExitStartedState();
                break;
            }
            case 0: {
                this.onExitStoppedState();
            }
        }
    }

    private void processEnterState(int state) {
        Log.d((String)TAG, (String)("call processEnterState: " + state));
        switch (state) {
            case 1: {
                this.onEnterStartedState();
                break;
            }
            case 0: {
                this.onEnterStoppedState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onExitStartedState() {
        Object object = this.mSyncObject;
        synchronized (object) {
            if (this.mCamera != null) {
                try {
                    this.mCamera.setPreviewCallback(null);
                    this.mCamera.stopPreview();
                    this.mCamera.release();
                    this.mCamera = null;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void onExitStoppedState() {
    }

    private void onEnterStartedState() {
        if (this.mHolder.getSurface() != null) {
            this.initCamera();
            try {
                this.mCamera.setPreviewDisplay(this.mHolder);
                this.mCamera.setDisplayOrientation(this.getDisplayOrientation(this.getContext(), this.mCameraId));
                if (this.mParametersCallback != null) {
                    if (this.mParametersMode == 0) {
                        this.mParametersCallback.setParameters(this.mCamera);
                    } else if (this.mParametersMode == 1) {
                        this.mParametersCallback.setParameters(this.mCamera);
                        this.defultParameters(this.mCamera);
                    } else if (this.mParametersMode == 2) {
                        this.defultParameters(this.mCamera);
                    } else {
                        this.defultParameters(this.mCamera);
                    }
                } else {
                    this.defultParameters(this.mCamera);
                }
                this.mCamera.startPreview();
                if (this.mAutoFocus && !this.supportFocusModeContinuousPicture(this.mCamera)) {
                    this.scheduleAutoFocus();
                }
                Camera.Parameters parameters = this.mCamera.getParameters();
                int previewWidth = parameters.getPreviewSize().width;
                int previewHeight = parameters.getPreviewSize().height;
                int bitsPerPixel = ImageFormat.getBitsPerPixel((int)parameters.getPreviewFormat());
                int bufferSize = previewWidth * previewHeight * bitsPerPixel / 8 + 1;
                this.mCamera.addCallbackBuffer(new byte[bufferSize]);
                this.mCamera.setPreviewCallbackWithBuffer((data, camera) -> {
                    if (this.mPreviewCallback != null) {
                        this.mPreviewCallback.onPreviewFrame(data, camera);
                    }
                    this.mCamera.addCallbackBuffer(data);
                });
            }
            catch (Exception e) {
                Log.d((String)TAG, (String)("Error starting camera preview: " + e.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onEnterStoppedState() {
        Object object = this.mSyncObject;
        synchronized (object) {
            if (this.mCamera != null) {
                try {
                    this.mCamera.setPreviewCallback(null);
                    this.mCamera.stopPreview();
                    this.mCamera.release();
                    this.mCamera = null;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public Camera getCamera() {
        return this.mCamera;
    }

    public int getDisplayOrientation() {
        int degrees = 0;
        degrees = this.mCameraId == -1 ? 90 : this.getDisplayOrientation(this.getContext(), this.mCameraId);
        return degrees;
    }

    public void setParametersMode(int mode) {
        this.mParametersMode = mode;
    }

    public void setParametersCallback(ParametersCallback callback) {
        this.mParametersCallback = callback;
    }

    public void setPreviewCallback(Camera.PreviewCallback callback) {
        this.mPreviewCallback = callback;
    }

    public void takePicture(Camera.ShutterCallback shutter, Camera.PictureCallback raw, Camera.PictureCallback jpeg) {
        if (this.isCameraAvailable()) {
            try {
                this.mCamera.takePicture(shutter, raw, (data, camera) -> {
                    boolean tmpAutoFocus = this.mAutoFocus;
                    this.setAutoFocus(false);
                    jpeg.onPictureTaken(data, camera);
                    this.mCamera.startPreview();
                    this.setAutoFocus(tmpAutoFocus);
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableView() {
        Object object = this.mSyncObject;
        synchronized (object) {
            this.mEnabled = true;
            this.checkCurrentState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableView() {
        Object object = this.mSyncObject;
        synchronized (object) {
            this.mEnabled = false;
            this.checkCurrentState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setFlash(boolean flag) {
        Object object = this.mSyncObject;
        synchronized (object) {
            if (!this.isCameraAvailable()) return;
            try {
                if (this.mCamera == null) return;
                if (!this.isFlashSupported(this.mCamera)) return;
                Camera.Parameters parameters = this.mCamera.getParameters();
                if (flag) {
                    if (parameters.getFlashMode().equals("torch")) return;
                    parameters.setFlashMode("torch");
                } else {
                    if (parameters.getFlashMode().equals("off")) return;
                    parameters.setFlashMode("off");
                }
                this.mCamera.setParameters(parameters);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
    }

    public void setAutoFocus(boolean state) {
        if (this.mAutoFocus == state) {
            return;
        }
        this.mAutoFocus = state;
        if (this.mAutoFocus) {
            if (this.mAutoFocusHandler == null) {
                this.mAutoFocusHandler = new Handler();
            }
            if (this.isCameraAvailable() && !this.supportFocusModeContinuousPicture(this.mCamera)) {
                this.scheduleAutoFocus();
            }
        } else {
            if (this.mAutoFocusHandler != null) {
                this.mAutoFocusHandler = null;
            }
            if (this.isCameraAvailable()) {
                try {
                    this.mCamera.cancelAutoFocus();
                }
                catch (RuntimeException rex) {
                    rex.printStackTrace();
                }
            }
        }
    }

    public void setAutoFocusInterval(long millisecond) {
        this.mAutoFocusInterval = millisecond;
    }

    private void scheduleAutoFocus() {
        this.mAutoFocusHandler.postDelayed(this.doAutoFocus, this.mAutoFocusInterval);
    }

    private void safeAutoFocus() {
        if (this.mAutoFocus && this.isCameraAvailable()) {
            try {
                this.mCamera.autoFocus(this.autoFocusCB);
            }
            catch (RuntimeException re) {
                this.scheduleAutoFocus();
            }
        }
    }

    private boolean supportFocusModeContinuousPicture(Camera camera) {
        this.mSupportFocusModeContinuousPicture = false;
        return this.mSupportFocusModeContinuousPicture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCameraAvailable() {
        Object object = this.mSyncObject;
        synchronized (object) {
            boolean result = false;
            int targetState = this.mSupportCamera && this.mEnabled && this.mSurfaceExist && this.getVisibility() == 0 ? 1 : 0;
            if (this.mState == 1 && targetState == this.mState) {
                result = true;
            }
            return result;
        }
    }

    private boolean isFlashSupported(Camera camera) {
        if (camera == null) {
            return false;
        }
        Camera.Parameters parameters = camera.getParameters();
        if (parameters.getFlashMode() == null) {
            return false;
        }
        List supportedFlashModes = parameters.getSupportedFlashModes();
        return supportedFlashModes != null && !supportedFlashModes.isEmpty() && (supportedFlashModes.size() != 1 || !((String)supportedFlashModes.get(0)).equals("off"));
    }

    private void defultParameters(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        if (Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.startsWith("unknown") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.MANUFACTURER.contains("Genymotion") || Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || "google_sdk".equals(Build.PRODUCT)) {
            parameters.setPreviewFormat(842094169);
        } else {
            parameters.setPreviewFormat(17);
        }
        Camera.Size optimalPreviewSize = this.getOptimalPreviewSize2(parameters.getSupportedPreviewSizes(), this.getWidth(), this.getHeight());
        parameters.setPreviewSize(optimalPreviewSize.width, optimalPreviewSize.height);
        List pictureFormats = parameters.getSupportedPictureFormats();
        if (pictureFormats != null && pictureFormats.size() > 0 && pictureFormats.contains(256)) {
            parameters.setPictureFormat(256);
        }
        camera.setParameters(parameters);
    }

    private boolean checkOnUIThreadOrNot() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    private int getDisplayOrientation(Context context, int cameraId) {
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)info);
        int degrees = 0;
        switch (((WindowManager)context.getApplicationContext().getSystemService("window")).getDefaultDisplay().getRotation()) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if (info.facing == 1) {
            return (360 - (info.orientation + degrees) % 360) % 360;
        }
        return (info.orientation - degrees + 360) % 360;
    }

    private boolean checkCameraHardware(Context context) {
        return context.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.camera");
    }

    private Camera.Size getOptimalPreviewSize(List<Camera.Size> sizes, int viewWidth, int viewHeight) {
        Log.d((String)TAG, (String)("widgetSize: " + viewWidth + "x" + viewHeight));
        if (sizes == null) {
            return null;
        }
        int w = viewWidth;
        int h = viewHeight;
        Display display = ((WindowManager)this.getContext().getApplicationContext().getSystemService("window")).getDefaultDisplay();
        if (display.getWidth() <= display.getHeight()) {
            w = viewHeight;
            h = viewWidth;
        }
        double targetRatio = (double)w / (double)h;
        Camera.Size optimalSize = null;
        double minDiff = Double.MAX_VALUE;
        int targetHeight = h;
        for (Camera.Size size : sizes) {
            if (!(Math.abs((double)size.width / (double)size.height - targetRatio) <= 0.1) || !((double)Math.abs(size.height - targetHeight) < minDiff)) continue;
            optimalSize = size;
            minDiff = Math.abs(size.height - targetHeight);
        }
        if (optimalSize != null) {
            Log.d((String)TAG, (String)("OptimalPreviewSize: " + optimalSize.width + "x" + optimalSize.height));
            return optimalSize;
        }
        minDiff = Double.MAX_VALUE;
        for (Camera.Size size2 : sizes) {
            if (!((double)Math.abs(size2.height - targetHeight) < minDiff)) continue;
            optimalSize = size2;
            minDiff = Math.abs(size2.height - targetHeight);
        }
        Log.d((String)TAG, (String)("OptimalPreviewSize: " + optimalSize.width + "x" + optimalSize.height));
        return optimalSize;
    }

    private Camera.Size getOptimalPreviewSize2(List<Camera.Size> sizes, int viewWidth, int viewHeight) {
        int w = this.getWidth();
        int h = this.getHeight();
        if (DisplayUtils.getScreenOrientation(this.getContext()) == 1) {
            int portraitWidth = h;
            h = w;
            w = portraitWidth;
        }
        double targetRatio = (double)w / (double)h;
        if (sizes == null) {
            return null;
        }
        Camera.Size optimalSize = null;
        double minDiff = Double.MAX_VALUE;
        int targetHeight = h;
        for (Camera.Size size : sizes) {
            double ratio = (double)size.width / (double)size.height;
            if (Math.abs(ratio - targetRatio) > (double)this.mAspectTolerance || !((double)Math.abs(size.height - targetHeight) < minDiff)) continue;
            optimalSize = size;
            minDiff = Math.abs(size.height - targetHeight);
        }
        if (optimalSize != null && targetHeight - optimalSize.height * 2 > 0) {
            optimalSize = null;
        }
        if (optimalSize == null) {
            minDiff = Double.MAX_VALUE;
            for (Camera.Size size : sizes) {
                if (!((double)Math.abs(size.height - targetHeight) < minDiff)) continue;
                optimalSize = size;
                minDiff = Math.abs(size.height - targetHeight);
            }
        }
        return optimalSize;
    }

    public static interface ParametersCallback {
        public void setParameters(Camera var1);
    }
}

