/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.impl.pool.ConnectResult;
import io.vertx.core.net.impl.pool.ConnectionPool;
import io.vertx.core.net.impl.pool.Endpoint;
import io.vertx.core.net.impl.pool.Lease;
import io.vertx.core.net.impl.pool.PoolConnector;
import io.vertx.ext.mail.MailConfig;
import io.vertx.ext.mail.impl.SMTPConnection;
import java.util.List;

class SMTPEndPoint
extends Endpoint<Lease<SMTPConnection>>
implements PoolConnector<SMTPConnection> {
    private final NetClient netClient;
    private final MailConfig config;
    private final ConnectionPool<SMTPConnection> pool;

    SMTPEndPoint(NetClient netClient, MailConfig config, Runnable dispose) {
        super(dispose);
        this.config = config;
        this.netClient = netClient;
        int maxSockets = config.getMaxPoolSize();
        this.pool = ConnectionPool.pool((PoolConnector)this, (int[])new int[]{maxSockets}, (int)-1);
    }

    public void requestConnection(ContextInternal ctx, long timeout, Handler<AsyncResult<Lease<SMTPConnection>>> handler) {
        ContextInternal eventLoopContext = ctx.isEventLoopContext() ? ctx : ctx.owner().createEventLoopContext(ctx.nettyEventLoop(), ctx.workerPool(), ctx.classLoader());
        this.pool.acquire(eventLoopContext, 0, handler);
    }

    void checkExpired(Handler<AsyncResult<List<SMTPConnection>>> handler) {
        this.pool.evict(conn -> !conn.isValid(), handler);
    }

    public void connect(ContextInternal context, PoolConnector.Listener listener, Handler<AsyncResult<ConnectResult<SMTPConnection>>> handler) {
        this.netClient.connect(this.config.getPort(), this.config.getHostname()).onComplete(ar -> {
            if (ar.succeeded()) {
                this.incRefCount();
                SMTPConnection connection = new SMTPConnection(this.config, (NetSocket)ar.result(), context, (Handler<Void>)((Handler)v -> {
                    this.decRefCount();
                    listener.onRemove();
                }));
                handler.handle((Object)Future.succeededFuture((Object)new ConnectResult((Object)connection, 1L, 0L)));
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
    }

    void close(Promise<List<Future<SMTPConnection>>> promise) {
        this.pool.close(promise);
    }

    public boolean isValid(SMTPConnection connection) {
        return connection.isValid();
    }

    int size() {
        return this.pool.size();
    }
}

