/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.ext.mail.DKIMSignOptions;
import io.vertx.ext.mail.LoginOption;
import io.vertx.ext.mail.StartTLSOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@DataObject
public class MailConfig
extends NetClientOptions {
    public static final LoginOption DEFAULT_LOGIN = LoginOption.NONE;
    public static final StartTLSOptions DEFAULT_TLS = StartTLSOptions.OPTIONAL;
    public static final int DEFAULT_PORT = 25;
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_MAX_POOL_SIZE = 10;
    public static final boolean DEFAULT_ALLOW_RCPT_ERRORS = false;
    public static final boolean DEFAULT_KEEP_ALIVE = true;
    public static final boolean DEFAULT_DISABLE_ESMTP = false;
    private static final boolean DEFAULT_ENABLE_DKIM = false;
    public static final String DEFAULT_USER_AGENT = "vertxmail";
    public static final boolean DEFAULT_ENABLE_PIPELINING = true;
    public static final boolean DEFAULT_MULTI_PART_ONLY = false;
    public static final long DEFAULT_MAILS_PER_CONNECTION = -1L;
    public static final int DEFAULT_POOL_CLEANER_PERIOD = 1000;
    public static final TimeUnit DEFAULT_POOL_CLEANER_PERIOD_TIMEOUT_UNIT = TimeUnit.MILLISECONDS;
    public static final int DEFAULT_KEEP_ALIVE_TIMEOUT = 300;
    public static final TimeUnit DEFAULT_KEEP_ALIVE_TIMEOUT_UNIT = TimeUnit.SECONDS;
    private String hostname = "localhost";
    private int port = 25;
    private StartTLSOptions starttls = DEFAULT_TLS;
    private LoginOption login = DEFAULT_LOGIN;
    private String authMethods;
    private String username;
    private String password;
    private String ownHostname;
    private int maxPoolSize = 10;
    private boolean keepAlive = true;
    private boolean allowRcptErrors = false;
    private boolean disableEsmtp = false;
    private String userAgent = "vertxmail";
    private boolean enableDKIM = false;
    private List<DKIMSignOptions> dkimSignOptions;
    private boolean pipelining = true;
    private boolean multiPartOnly = false;
    private int poolCleanerPeriod = 1000;
    private TimeUnit poolCleanerPeriodUnit = DEFAULT_POOL_CLEANER_PERIOD_TIMEOUT_UNIT;
    private int keepAliveTimeout = 300;
    private TimeUnit keepAliveTimeoutUnit = DEFAULT_KEEP_ALIVE_TIMEOUT_UNIT;
    private String ntDomain;
    private String workstation;
    private long maxMailsPerConnection = -1L;
    private static final Pattern A_TEXT_PATTERN = Pattern.compile("[a-zA-Z0-9!#$%&'*+-/=?^_`{|}~ ]+");

    public MailConfig() {
    }

    public MailConfig(String hostname) {
        this();
        this.hostname = hostname;
    }

    public MailConfig(String hostname, int port) {
        this();
        this.hostname = hostname;
        this.port = port;
    }

    public MailConfig(String hostname, int port, StartTLSOptions starttls, LoginOption login) {
        this(hostname, port);
        this.starttls = starttls;
        this.login = login;
    }

    public MailConfig(MailConfig other) {
        super((NetClientOptions)other);
        this.hostname = other.hostname;
        this.port = other.port;
        this.starttls = other.starttls;
        this.login = other.login;
        this.username = other.username;
        this.password = other.password;
        this.authMethods = other.authMethods;
        this.ownHostname = other.ownHostname;
        this.maxPoolSize = other.maxPoolSize;
        this.keepAlive = other.keepAlive;
        this.allowRcptErrors = other.allowRcptErrors;
        this.disableEsmtp = other.disableEsmtp;
        this.userAgent = other.userAgent;
        this.enableDKIM = other.enableDKIM;
        if (other.dkimSignOptions != null && !other.dkimSignOptions.isEmpty()) {
            this.dkimSignOptions = other.dkimSignOptions.stream().map(DKIMSignOptions::new).collect(Collectors.toList());
        }
        this.pipelining = other.pipelining;
        this.multiPartOnly = other.multiPartOnly;
        this.poolCleanerPeriod = other.poolCleanerPeriod;
        this.poolCleanerPeriodUnit = other.poolCleanerPeriodUnit;
        this.keepAliveTimeout = other.keepAliveTimeout;
        this.keepAliveTimeoutUnit = other.keepAliveTimeoutUnit;
        this.ntDomain = other.ntDomain;
        this.workstation = other.workstation;
        this.maxMailsPerConnection = other.maxMailsPerConnection;
    }

    public MailConfig(JsonObject config) {
        super(config);
        this.hostname = config.getString("hostname", DEFAULT_HOST);
        this.port = config.getInteger("port", Integer.valueOf(25));
        String starttlsOption = config.getString("starttls");
        this.starttls = starttlsOption != null ? StartTLSOptions.valueOf(starttlsOption.toUpperCase(Locale.ENGLISH)) : DEFAULT_TLS;
        String loginOption = config.getString("login");
        this.login = loginOption != null ? LoginOption.valueOf(loginOption.toUpperCase(Locale.ENGLISH)) : DEFAULT_LOGIN;
        this.username = config.getString("username");
        this.password = config.getString("password");
        if (config.containsKey("keyStore")) {
            this.setKeyStore(config.getString("keyStore"));
        }
        if (config.containsKey("keyStorePassword")) {
            this.setKeyStorePassword(config.getString("keyStorePassword"));
        }
        this.authMethods = config.getString("authMethods");
        this.ownHostname = config.getString("ownHostname");
        this.maxPoolSize = config.getInteger("maxPoolSize", Integer.valueOf(10));
        this.keepAlive = config.getBoolean("keepAlive", Boolean.valueOf(true));
        this.allowRcptErrors = config.getBoolean("allowRcptErrors", Boolean.valueOf(false));
        this.userAgent = config.getString("userAgent", DEFAULT_USER_AGENT);
        this.enableDKIM = config.getBoolean("enableDKIM", Boolean.valueOf(false));
        JsonArray dkimOps = config.getJsonArray("dkimSignOptions");
        if (dkimOps != null) {
            this.dkimSignOptions = new ArrayList<DKIMSignOptions>();
            dkimOps.stream().map(dkim -> new DKIMSignOptions((JsonObject)dkim)).forEach(this.dkimSignOptions::add);
        }
        this.pipelining = config.getBoolean("pipelining", Boolean.valueOf(true));
        this.multiPartOnly = config.getBoolean("multiPartOnly", Boolean.valueOf(false));
        this.poolCleanerPeriod = config.getInteger("poolCleanerPeriod", Integer.valueOf(1000));
        this.keepAliveTimeout = config.getInteger("keepAliveTimeout", Integer.valueOf(300));
        Object keepAliveTU = config.getValue("keepAliveTimeoutUnit");
        this.keepAliveTimeoutUnit = keepAliveTU instanceof String ? TimeUnit.valueOf((String)keepAliveTU) : DEFAULT_KEEP_ALIVE_TIMEOUT_UNIT;
        Object poolCleanerU = config.getValue("poolCleanerPeriodUnit");
        this.poolCleanerPeriodUnit = keepAliveTU instanceof String ? TimeUnit.valueOf((String)poolCleanerU) : DEFAULT_POOL_CLEANER_PERIOD_TIMEOUT_UNIT;
        this.ntDomain = config.getString("ntDomain");
        this.workstation = config.getString("workstation");
        this.maxMailsPerConnection = config.getLong("maxMailsPerConnection", Long.valueOf(-1L));
    }

    public MailConfig setSendBufferSize(int sendBufferSize) {
        super.setSendBufferSize(sendBufferSize);
        return this;
    }

    public MailConfig setReceiveBufferSize(int receiveBufferSize) {
        super.setReceiveBufferSize(receiveBufferSize);
        return this;
    }

    public MailConfig setReuseAddress(boolean reuseAddress) {
        super.setReuseAddress(reuseAddress);
        return this;
    }

    public MailConfig setReusePort(boolean reusePort) {
        super.setReusePort(reusePort);
        return this;
    }

    public MailConfig setTrafficClass(int trafficClass) {
        super.setTrafficClass(trafficClass);
        return this;
    }

    public MailConfig setTcpNoDelay(boolean tcpNoDelay) {
        super.setTcpNoDelay(tcpNoDelay);
        return this;
    }

    public MailConfig setTcpKeepAlive(boolean tcpKeepAlive) {
        super.setTcpKeepAlive(tcpKeepAlive);
        return this;
    }

    public MailConfig setSoLinger(int soLinger) {
        super.setSoLinger(soLinger);
        return this;
    }

    public MailConfig setIdleTimeout(int idleTimeout) {
        super.setIdleTimeout(idleTimeout);
        return this;
    }

    public MailConfig setIdleTimeoutUnit(TimeUnit idleTimeoutUnit) {
        super.setIdleTimeoutUnit(idleTimeoutUnit);
        return this;
    }

    public MailConfig setKeyCertOptions(KeyCertOptions options) {
        super.setKeyCertOptions(options);
        return this;
    }

    public MailConfig setKeyStoreOptions(JksOptions options) {
        super.setKeyStoreOptions(options);
        return this;
    }

    public MailConfig setPfxKeyCertOptions(PfxOptions options) {
        super.setPfxKeyCertOptions(options);
        return this;
    }

    public MailConfig setPemKeyCertOptions(PemKeyCertOptions options) {
        super.setPemKeyCertOptions(options);
        return this;
    }

    public MailConfig setTrustOptions(TrustOptions options) {
        super.setTrustOptions(options);
        return this;
    }

    public MailConfig setTrustStoreOptions(JksOptions options) {
        super.setTrustStoreOptions(options);
        return this;
    }

    public MailConfig setPemTrustOptions(PemTrustOptions options) {
        super.setPemTrustOptions(options);
        return this;
    }

    public MailConfig setPfxTrustOptions(PfxOptions options) {
        super.setPfxTrustOptions(options);
        return this;
    }

    public MailConfig addEnabledCipherSuite(String suite) {
        super.addEnabledCipherSuite(suite);
        return this;
    }

    public MailConfig addEnabledSecureTransportProtocol(String protocol) {
        super.addEnabledSecureTransportProtocol(protocol);
        return this;
    }

    public MailConfig removeEnabledSecureTransportProtocol(String protocol) {
        super.removeEnabledSecureTransportProtocol(protocol);
        return this;
    }

    public MailConfig setUseAlpn(boolean useAlpn) {
        super.setUseAlpn(useAlpn);
        return this;
    }

    public MailConfig setSslEngineOptions(SSLEngineOptions sslEngineOptions) {
        super.setSslEngineOptions(sslEngineOptions);
        return this;
    }

    public MailConfig setJdkSslEngineOptions(JdkSSLEngineOptions sslEngineOptions) {
        super.setJdkSslEngineOptions(sslEngineOptions);
        return this;
    }

    public MailConfig setTcpFastOpen(boolean tcpFastOpen) {
        super.setTcpFastOpen(tcpFastOpen);
        return this;
    }

    public MailConfig setTcpCork(boolean tcpCork) {
        super.setTcpCork(tcpCork);
        return this;
    }

    public MailConfig setTcpQuickAck(boolean tcpQuickAck) {
        super.setTcpQuickAck(tcpQuickAck);
        return this;
    }

    public MailConfig setOpenSslEngineOptions(OpenSSLEngineOptions sslEngineOptions) {
        super.setOpenSslEngineOptions(sslEngineOptions);
        return this;
    }

    public MailConfig addCrlPath(String crlPath) throws NullPointerException {
        super.addCrlPath(crlPath);
        return this;
    }

    public MailConfig addCrlValue(Buffer crlValue) throws NullPointerException {
        super.addCrlValue(crlValue);
        return this;
    }

    public MailConfig setConnectTimeout(int connectTimeout) {
        super.setConnectTimeout(connectTimeout);
        return this;
    }

    public MailConfig setMetricsName(String metricsName) {
        super.setMetricsName(metricsName);
        return this;
    }

    public MailConfig setReconnectAttempts(int attempts) {
        super.setReconnectAttempts(attempts);
        return this;
    }

    public MailConfig setReconnectInterval(long interval) {
        super.setReconnectInterval(interval);
        return this;
    }

    public MailConfig setHostnameVerificationAlgorithm(String hostnameVerificationAlgorithm) {
        super.setHostnameVerificationAlgorithm(hostnameVerificationAlgorithm);
        return this;
    }

    public MailConfig setLogActivity(boolean logEnabled) {
        super.setLogActivity(logEnabled);
        return this;
    }

    public MailConfig setProxyOptions(ProxyOptions proxyOptions) {
        super.setProxyOptions(proxyOptions);
        return this;
    }

    public MailConfig setLocalAddress(String localAddress) {
        super.setLocalAddress(localAddress);
        return this;
    }

    public MailConfig setSslHandshakeTimeout(long sslHandshakeTimeout) {
        super.setSslHandshakeTimeout(sslHandshakeTimeout);
        return this;
    }

    public MailConfig setSslHandshakeTimeoutUnit(TimeUnit sslHandshakeTimeoutUnit) {
        super.setSslHandshakeTimeoutUnit(sslHandshakeTimeoutUnit);
        return this;
    }

    public String getHostname() {
        return this.hostname;
    }

    public MailConfig setHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public MailConfig setPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port must be >=0 && <= 65535");
        }
        this.port = port;
        return this;
    }

    public StartTLSOptions getStarttls() {
        return this.starttls;
    }

    public MailConfig setStarttls(StartTLSOptions starttls) {
        this.starttls = starttls;
        return this;
    }

    public LoginOption getLogin() {
        return this.login;
    }

    public MailConfig setLogin(LoginOption login) {
        this.login = login;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public MailConfig setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public MailConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    public MailConfig setSsl(boolean isSsl) {
        super.setSsl(isSsl);
        return this;
    }

    public MailConfig setEnabledSecureTransportProtocols(Set<String> enabledSecureTransportProtocols) {
        super.setEnabledSecureTransportProtocols(enabledSecureTransportProtocols);
        return this;
    }

    public MailConfig setTrustAll(boolean trustAll) {
        super.setTrustAll(trustAll);
        return this;
    }

    @Deprecated
    public String getKeyStore() {
        String keyStore = null;
        JksOptions options = this.getTrustStoreOptions();
        if (options != null) {
            keyStore = options.getPath();
        }
        return keyStore;
    }

    @Deprecated
    public MailConfig setKeyStore(String keyStore) {
        JksOptions options = this.getTrustStoreOptions();
        if (options == null) {
            options = new JksOptions();
            this.setTrustOptions((TrustOptions)options);
        }
        options.setPath(keyStore);
        return this;
    }

    @Deprecated
    public String getKeyStorePassword() {
        String keyStorePassword = null;
        JksOptions options = this.getTrustStoreOptions();
        if (options != null) {
            keyStorePassword = options.getPassword();
        }
        return keyStorePassword;
    }

    @Deprecated
    public MailConfig setKeyStorePassword(String keyStorePassword) {
        JksOptions options = this.getTrustStoreOptions();
        if (options == null) {
            options = new JksOptions();
            this.setTrustOptions((TrustOptions)options);
        }
        options.setPassword(keyStorePassword);
        return this;
    }

    public String getAuthMethods() {
        return this.authMethods;
    }

    public MailConfig setAuthMethods(String authMethods) {
        this.authMethods = authMethods;
        return this;
    }

    public String getOwnHostname() {
        return this.ownHostname;
    }

    public MailConfig setOwnHostname(String ownHostname) {
        this.ownHostname = ownHostname;
        return this;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public MailConfig setMaxPoolSize(int maxPoolSize) {
        if (maxPoolSize < 1) {
            throw new IllegalArgumentException("maxPoolSize must be > 0");
        }
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public MailConfig setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public boolean isAllowRcptErrors() {
        return this.allowRcptErrors;
    }

    public MailConfig setAllowRcptErrors(boolean allowRcptErrors) {
        this.allowRcptErrors = allowRcptErrors;
        return this;
    }

    public boolean isDisableEsmtp() {
        return this.disableEsmtp;
    }

    public MailConfig setDisableEsmtp(boolean disableEsmtp) {
        this.disableEsmtp = disableEsmtp;
        return this;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public MailConfig setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        if (this.userAgent == null) {
            this.userAgent = DEFAULT_USER_AGENT;
        }
        if (this.userAgent.length() > 40) {
            throw new IllegalArgumentException("Length of Mail User Agent should be less than 40");
        }
        if (!A_TEXT_PATTERN.matcher(this.userAgent).matches()) {
            throw new IllegalArgumentException("Not a valid User Agent name");
        }
        return this;
    }

    public boolean isEnableDKIM() {
        return this.enableDKIM;
    }

    public MailConfig setEnableDKIM(boolean enableDKIM) {
        this.enableDKIM = enableDKIM;
        return this;
    }

    public List<DKIMSignOptions> getDKIMSignOptions() {
        return this.dkimSignOptions;
    }

    public MailConfig addDKIMSignOption(DKIMSignOptions dkimSignOptions) {
        Objects.requireNonNull(dkimSignOptions);
        if (this.dkimSignOptions == null) {
            this.dkimSignOptions = new ArrayList<DKIMSignOptions>();
        }
        if (!this.dkimSignOptions.contains(dkimSignOptions)) {
            this.dkimSignOptions.add(dkimSignOptions);
        }
        return this;
    }

    public MailConfig setDKIMSignOptions(List<DKIMSignOptions> dkimSignOptions) {
        this.dkimSignOptions = dkimSignOptions;
        return this;
    }

    public MailConfig setDKIMSignOption(DKIMSignOptions dkimSignOptions) {
        Objects.requireNonNull(dkimSignOptions);
        this.dkimSignOptions = Collections.singletonList(dkimSignOptions);
        return this;
    }

    public DKIMSignOptions getDKIMSignOption() {
        return this.dkimSignOptions == null || this.dkimSignOptions.isEmpty() ? null : this.dkimSignOptions.get(0);
    }

    public boolean isPipelining() {
        return this.pipelining;
    }

    public MailConfig setPipelining(boolean pipelining) {
        this.pipelining = pipelining;
        return this;
    }

    public boolean isMultiPartOnly() {
        return this.multiPartOnly;
    }

    public MailConfig setMultiPartOnly(boolean multiPartOnly) {
        this.multiPartOnly = multiPartOnly;
        return this;
    }

    public int getPoolCleanerPeriod() {
        return this.poolCleanerPeriod;
    }

    public MailConfig setPoolCleanerPeriod(int poolCleanerPeriod) {
        this.poolCleanerPeriod = poolCleanerPeriod;
        return this;
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public MailConfig setKeepAliveTimeout(int keepAliveTimeout) {
        if (keepAliveTimeout < 0) {
            throw new IllegalArgumentException("keepAliveTimeout must be >= 0");
        }
        this.keepAliveTimeout = keepAliveTimeout;
        return this;
    }

    public TimeUnit getPoolCleanerPeriodUnit() {
        return this.poolCleanerPeriodUnit;
    }

    public MailConfig setPoolCleanerPeriodUnit(TimeUnit poolCleanerPeriodUnit) {
        this.poolCleanerPeriodUnit = poolCleanerPeriodUnit;
        return this;
    }

    public TimeUnit getKeepAliveTimeoutUnit() {
        return this.keepAliveTimeoutUnit;
    }

    public MailConfig setKeepAliveTimeoutUnit(TimeUnit keepAliveTimeoutUnit) {
        this.keepAliveTimeoutUnit = keepAliveTimeoutUnit;
        return this;
    }

    public String getNtDomain() {
        return this.ntDomain;
    }

    public MailConfig setNtDomain(String ntDomain) {
        this.ntDomain = ntDomain;
        return this;
    }

    public String getWorkstation() {
        return this.workstation;
    }

    public MailConfig setWorkstation(String workstation) {
        this.workstation = workstation;
        return this;
    }

    public MailConfig setMaxMailsPerConnection(long maxMailsPerConnection) {
        this.maxMailsPerConnection = maxMailsPerConnection;
        return this;
    }

    public long getMaxMailsPerConnection() {
        return this.maxMailsPerConnection;
    }

    public JsonObject toJson() {
        JsonObject json = super.toJson();
        if (this.hostname != null) {
            json.put("hostname", (Object)this.hostname);
        }
        json.put("port", (Object)this.port);
        if (this.starttls != null) {
            json.put("starttls", (Object)this.starttls);
        }
        if (this.login != null) {
            json.put("login", (Object)this.login);
        }
        if (this.username != null) {
            json.put("username", (Object)this.username);
        }
        if (this.password != null) {
            json.put("password", (Object)this.password);
        }
        if (this.authMethods != null) {
            json.put("authMethods", (Object)this.authMethods);
        }
        if (this.ownHostname != null) {
            json.put("ownHostname", (Object)this.ownHostname);
        }
        json.put("maxPoolSize", (Object)this.maxPoolSize);
        if (!this.keepAlive) {
            json.put("keepAlive", (Object)false);
        }
        if (this.allowRcptErrors) {
            json.put("allowRcptErrors", (Object)true);
        }
        if (this.disableEsmtp) {
            json.put("disableEsmtp", (Object)true);
        }
        if (this.userAgent != null) {
            json.put("userAgent", (Object)this.userAgent);
        }
        if (this.enableDKIM) {
            json.put("enableDKIM", (Object)true);
        }
        if (this.dkimSignOptions != null) {
            JsonArray array = new JsonArray();
            this.dkimSignOptions.forEach(arg_0 -> ((JsonArray)array).add(arg_0));
            json.put("dkimSignOptions", (Object)array);
        }
        json.put("pipelining", (Object)this.pipelining);
        json.put("multiFormatOnly", (Object)this.multiPartOnly);
        json.put("poolCleanerPeriod", (Object)this.poolCleanerPeriod);
        json.put("keepAliveTimeout", (Object)this.keepAliveTimeout);
        json.put("poolCleanerPeriodUnit", (Object)this.poolCleanerPeriodUnit.name());
        json.put("keepAliveTimeoutUnit", (Object)this.keepAliveTimeoutUnit.name());
        if (this.ntDomain != null) {
            json.put("ntDomain", (Object)this.ntDomain);
        }
        if (this.workstation != null) {
            json.put("workstation", (Object)this.workstation);
        }
        json.put("maxMailsPerConnection", (Object)this.maxMailsPerConnection);
        return json;
    }

    private List<Object> getList() {
        return Arrays.asList(new Object[]{this.hostname, this.port, this.starttls, this.login, this.username, this.password, this.authMethods, this.ownHostname, this.maxPoolSize, this.keepAlive, this.allowRcptErrors, this.disableEsmtp, this.userAgent, this.enableDKIM, this.dkimSignOptions, this.pipelining, this.multiPartOnly, this.poolCleanerPeriod, this.keepAliveTimeout, this.poolCleanerPeriodUnit, this.keepAliveTimeoutUnit, this.ntDomain, this.workstation, this.maxMailsPerConnection});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NetClientOptions)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MailConfig that = (MailConfig)((Object)o);
        return this.getList().equals(that.getList());
    }

    public int hashCode() {
        int result = super.hashCode();
        return 31 * result + this.getList().hashCode();
    }
}

