/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.NodeConverter;
import java.util.Map;
import java.util.Objects;

@DataObject
@JsonGen(publicConverter=false)
public class Node {
    private String id;
    private String node;
    private String address;
    private String lanAddress;
    private String wanAddress;
    private String datacenter;
    private Map<String, String> nodeMeta;

    public Node() {
    }

    public Node(Node other) {
        this.id = other.id;
        this.node = other.node;
        this.address = other.address;
        this.lanAddress = other.lanAddress;
        this.wanAddress = other.wanAddress;
        this.datacenter = other.datacenter;
        this.nodeMeta = other.nodeMeta;
    }

    public Node(JsonObject json) {
        NodeConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        NodeConverter.toJson(this, jsonObject);
        return jsonObject;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.node;
    }

    public String getAddress() {
        return this.address;
    }

    public String getLanAddress() {
        return this.lanAddress;
    }

    public String getWanAddress() {
        return this.wanAddress;
    }

    public String getDatacenter() {
        return this.datacenter;
    }

    public Map<String, String> getNodeMeta() {
        return this.nodeMeta;
    }

    public Node setId(String id) {
        this.id = id;
        return this;
    }

    public Node setName(String node) {
        this.node = node;
        return this;
    }

    public Node setAddress(String address) {
        this.address = address;
        return this;
    }

    public Node setLanAddress(String lanAddress) {
        this.lanAddress = lanAddress;
        return this;
    }

    public Node setWanAddress(String wanAddress) {
        this.wanAddress = wanAddress;
        return this;
    }

    public Node setDatacenter(String datacenter) {
        this.datacenter = datacenter;
        return this;
    }

    public Node setNodeMeta(Map<String, String> nodeMeta) {
        this.nodeMeta = nodeMeta;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node1 = (Node)o;
        if (!Objects.equals(this.id, node1.id)) {
            return false;
        }
        if (!Objects.equals(this.node, node1.node)) {
            return false;
        }
        if (!Objects.equals(this.address, node1.address)) {
            return false;
        }
        if (!Objects.equals(this.lanAddress, node1.lanAddress)) {
            return false;
        }
        if (!Objects.equals(this.wanAddress, node1.wanAddress)) {
            return false;
        }
        if (!Objects.equals(this.datacenter, node1.datacenter)) {
            return false;
        }
        return Objects.equals(this.nodeMeta, node1.nodeMeta);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.node != null ? this.node.hashCode() : 0);
        result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
        result = 31 * result + (this.lanAddress != null ? this.lanAddress.hashCode() : 0);
        result = 31 * result + (this.wanAddress != null ? this.wanAddress.hashCode() : 0);
        result = 31 * result + (this.datacenter != null ? this.datacenter.hashCode() : 0);
        result = 31 * result + (this.nodeMeta != null ? this.nodeMeta.hashCode() : 0);
        return result;
    }
}

