/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.AclToken;
import io.vertx.ext.consul.BlockingQueryOptions;
import io.vertx.ext.consul.Check;
import io.vertx.ext.consul.CheckList;
import io.vertx.ext.consul.CheckOptions;
import io.vertx.ext.consul.CheckQueryOptions;
import io.vertx.ext.consul.CheckStatus;
import io.vertx.ext.consul.ConsulClientOptions;
import io.vertx.ext.consul.CoordinateList;
import io.vertx.ext.consul.DcCoordinates;
import io.vertx.ext.consul.Event;
import io.vertx.ext.consul.EventList;
import io.vertx.ext.consul.EventListOptions;
import io.vertx.ext.consul.EventOptions;
import io.vertx.ext.consul.HealthState;
import io.vertx.ext.consul.KeyValue;
import io.vertx.ext.consul.KeyValueList;
import io.vertx.ext.consul.KeyValueOptions;
import io.vertx.ext.consul.MaintenanceOptions;
import io.vertx.ext.consul.Node;
import io.vertx.ext.consul.NodeList;
import io.vertx.ext.consul.NodeQueryOptions;
import io.vertx.ext.consul.PreparedQueryDefinition;
import io.vertx.ext.consul.PreparedQueryExecuteOptions;
import io.vertx.ext.consul.PreparedQueryExecuteResponse;
import io.vertx.ext.consul.Service;
import io.vertx.ext.consul.ServiceEntryList;
import io.vertx.ext.consul.ServiceList;
import io.vertx.ext.consul.ServiceOptions;
import io.vertx.ext.consul.ServiceQueryOptions;
import io.vertx.ext.consul.Session;
import io.vertx.ext.consul.SessionList;
import io.vertx.ext.consul.SessionOptions;
import io.vertx.ext.consul.TxnRequest;
import io.vertx.ext.consul.TxnResponse;
import io.vertx.ext.consul.impl.ConsulClientImpl;
import io.vertx.ext.consul.policy.AclPolicy;
import io.vertx.ext.consul.token.CloneAclTokenOptions;
import java.util.List;

@VertxGen
public interface ConsulClient {
    public static ConsulClient create(Vertx vertx) {
        return new ConsulClientImpl(vertx, new ConsulClientOptions());
    }

    public static ConsulClient create(Vertx vertx, ConsulClientOptions options) {
        return new ConsulClientImpl(vertx, options);
    }

    @Fluent
    public ConsulClient agentInfo(Handler<AsyncResult<JsonObject>> var1);

    public Future<JsonObject> agentInfo();

    @Fluent
    public ConsulClient coordinateNodes(Handler<AsyncResult<CoordinateList>> var1);

    public Future<CoordinateList> coordinateNodes();

    @Fluent
    public ConsulClient coordinateNodesWithOptions(BlockingQueryOptions var1, Handler<AsyncResult<CoordinateList>> var2);

    public Future<CoordinateList> coordinateNodesWithOptions(BlockingQueryOptions var1);

    @Fluent
    public ConsulClient coordinateDatacenters(Handler<AsyncResult<List<DcCoordinates>>> var1);

    public Future<List<DcCoordinates>> coordinateDatacenters();

    @Fluent
    public ConsulClient getKeys(String var1, Handler<AsyncResult<List<String>>> var2);

    public Future<List<String>> getKeys(String var1);

    @Fluent
    public ConsulClient getKeysWithOptions(String var1, BlockingQueryOptions var2, Handler<AsyncResult<List<String>>> var3);

    public Future<List<String>> getKeysWithOptions(String var1, BlockingQueryOptions var2);

    @Fluent
    public ConsulClient getValue(String var1, Handler<AsyncResult<KeyValue>> var2);

    public Future<KeyValue> getValue(String var1);

    @Fluent
    public ConsulClient getValueWithOptions(String var1, BlockingQueryOptions var2, Handler<AsyncResult<KeyValue>> var3);

    public Future<KeyValue> getValueWithOptions(String var1, BlockingQueryOptions var2);

    @Fluent
    public ConsulClient deleteValue(String var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> deleteValue(String var1);

    @Fluent
    public ConsulClient getValues(String var1, Handler<AsyncResult<KeyValueList>> var2);

    public Future<KeyValueList> getValues(String var1);

    @Fluent
    public ConsulClient getValuesWithOptions(String var1, BlockingQueryOptions var2, Handler<AsyncResult<KeyValueList>> var3);

    public Future<KeyValueList> getValuesWithOptions(String var1, BlockingQueryOptions var2);

    @Fluent
    public ConsulClient deleteValues(String var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> deleteValues(String var1);

    @Fluent
    public ConsulClient putValue(String var1, String var2, Handler<AsyncResult<Boolean>> var3);

    public Future<Boolean> putValue(String var1, String var2);

    @Fluent
    public ConsulClient putValueWithOptions(String var1, String var2, KeyValueOptions var3, Handler<AsyncResult<Boolean>> var4);

    public Future<Boolean> putValueWithOptions(String var1, String var2, KeyValueOptions var3);

    @Fluent
    public ConsulClient transaction(TxnRequest var1, Handler<AsyncResult<TxnResponse>> var2);

    public Future<TxnResponse> transaction(TxnRequest var1);

    @Fluent
    public ConsulClient createAclPolicy(AclPolicy var1, Handler<AsyncResult<String>> var2);

    public Future<String> createAclPolicy(AclPolicy var1);

    @Fluent
    public ConsulClient readPolicy(String var1, Handler<AsyncResult<AclPolicy>> var2);

    public Future<AclPolicy> readPolicy(String var1);

    @Fluent
    public ConsulClient readPolicyByName(String var1, Handler<AsyncResult<AclPolicy>> var2);

    public Future<AclPolicy> readPolicyByName(String var1);

    @Fluent
    public ConsulClient updatePolicy(String var1, AclPolicy var2, Handler<AsyncResult<AclPolicy>> var3);

    public Future<AclPolicy> updatePolicy(String var1, AclPolicy var2);

    public ConsulClient deletePolicy(String var1, Handler<AsyncResult<Boolean>> var2);

    public Future<Boolean> deletePolicy(String var1);

    public ConsulClient getAclPolicies(Handler<AsyncResult<List<AclPolicy>>> var1);

    public Future<List<AclPolicy>> getAclPolicies();

    @Fluent
    public ConsulClient createAclToken(io.vertx.ext.consul.token.AclToken var1, Handler<AsyncResult<io.vertx.ext.consul.token.AclToken>> var2);

    public Future<io.vertx.ext.consul.token.AclToken> createAclToken(io.vertx.ext.consul.token.AclToken var1);

    @Fluent
    public ConsulClient updateAclToken(String var1, io.vertx.ext.consul.token.AclToken var2, Handler<AsyncResult<io.vertx.ext.consul.token.AclToken>> var3);

    public Future<io.vertx.ext.consul.token.AclToken> updateAclToken(String var1, io.vertx.ext.consul.token.AclToken var2);

    @Fluent
    public ConsulClient cloneAclToken(String var1, CloneAclTokenOptions var2, Handler<AsyncResult<io.vertx.ext.consul.token.AclToken>> var3);

    public Future<io.vertx.ext.consul.token.AclToken> cloneAclToken(String var1, CloneAclTokenOptions var2);

    @Fluent
    public ConsulClient getAclTokens(Handler<AsyncResult<List<io.vertx.ext.consul.token.AclToken>>> var1);

    public Future<List<io.vertx.ext.consul.token.AclToken>> getAclTokens();

    @Fluent
    public ConsulClient readAclToken(String var1, Handler<AsyncResult<io.vertx.ext.consul.token.AclToken>> var2);

    public Future<io.vertx.ext.consul.token.AclToken> readAclToken(String var1);

    @Fluent
    public ConsulClient deleteAclToken(String var1, Handler<AsyncResult<Boolean>> var2);

    public Future<Boolean> deleteAclToken(String var1);

    @Fluent
    @Deprecated
    public ConsulClient createAclToken(AclToken var1, Handler<AsyncResult<String>> var2);

    @Deprecated
    public Future<String> createAclToken(AclToken var1);

    @Fluent
    @Deprecated
    public ConsulClient updateAclToken(AclToken var1, Handler<AsyncResult<String>> var2);

    @Deprecated
    public Future<String> updateAclToken(AclToken var1);

    @Fluent
    @Deprecated
    public ConsulClient cloneAclToken(String var1, Handler<AsyncResult<String>> var2);

    @Deprecated
    public Future<String> cloneAclToken(String var1);

    @Fluent
    @Deprecated
    public ConsulClient listAclTokens(Handler<AsyncResult<List<AclToken>>> var1);

    @Deprecated
    public Future<List<AclToken>> listAclTokens();

    @Fluent
    @Deprecated
    public ConsulClient infoAclToken(String var1, Handler<AsyncResult<AclToken>> var2);

    @Deprecated
    public Future<AclToken> infoAclToken(String var1);

    @Fluent
    @Deprecated
    public ConsulClient destroyAclToken(String var1, Handler<AsyncResult<Void>> var2);

    @Deprecated
    public Future<Void> destroyAclToken(String var1);

    @Fluent
    public ConsulClient fireEvent(String var1, Handler<AsyncResult<Event>> var2);

    public Future<Event> fireEvent(String var1);

    @Fluent
    public ConsulClient fireEventWithOptions(String var1, EventOptions var2, Handler<AsyncResult<Event>> var3);

    public Future<Event> fireEventWithOptions(String var1, EventOptions var2);

    @Fluent
    public ConsulClient listEvents(Handler<AsyncResult<EventList>> var1);

    public Future<EventList> listEvents();

    @Fluent
    public ConsulClient listEventsWithOptions(EventListOptions var1, Handler<AsyncResult<EventList>> var2);

    public Future<EventList> listEventsWithOptions(EventListOptions var1);

    @Fluent
    public ConsulClient registerService(ServiceOptions var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> registerService(ServiceOptions var1);

    @Fluent
    public ConsulClient maintenanceService(MaintenanceOptions var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> maintenanceService(MaintenanceOptions var1);

    @Fluent
    public ConsulClient deregisterService(String var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> deregisterService(String var1);

    @Fluent
    public ConsulClient catalogServiceNodes(String var1, Handler<AsyncResult<ServiceList>> var2);

    public Future<ServiceList> catalogServiceNodes(String var1);

    @Fluent
    public ConsulClient catalogServiceNodesWithOptions(String var1, ServiceQueryOptions var2, Handler<AsyncResult<ServiceList>> var3);

    public Future<ServiceList> catalogServiceNodesWithOptions(String var1, ServiceQueryOptions var2);

    @Fluent
    public ConsulClient catalogDatacenters(Handler<AsyncResult<List<String>>> var1);

    public Future<List<String>> catalogDatacenters();

    @Fluent
    public ConsulClient catalogNodes(Handler<AsyncResult<NodeList>> var1);

    public Future<NodeList> catalogNodes();

    @Fluent
    public ConsulClient catalogNodesWithOptions(NodeQueryOptions var1, Handler<AsyncResult<NodeList>> var2);

    public Future<NodeList> catalogNodesWithOptions(NodeQueryOptions var1);

    @Fluent
    public ConsulClient healthChecks(String var1, Handler<AsyncResult<CheckList>> var2);

    public Future<CheckList> healthChecks(String var1);

    @Fluent
    public ConsulClient healthChecksWithOptions(String var1, CheckQueryOptions var2, Handler<AsyncResult<CheckList>> var3);

    public Future<CheckList> healthChecksWithOptions(String var1, CheckQueryOptions var2);

    @Fluent
    public ConsulClient healthState(HealthState var1, Handler<AsyncResult<CheckList>> var2);

    public Future<CheckList> healthState(HealthState var1);

    @Fluent
    public ConsulClient healthStateWithOptions(HealthState var1, CheckQueryOptions var2, Handler<AsyncResult<CheckList>> var3);

    public Future<CheckList> healthStateWithOptions(HealthState var1, CheckQueryOptions var2);

    @Fluent
    public ConsulClient healthServiceNodes(String var1, boolean var2, Handler<AsyncResult<ServiceEntryList>> var3);

    public Future<ServiceEntryList> healthServiceNodes(String var1, boolean var2);

    @Fluent
    public ConsulClient healthServiceNodesWithOptions(String var1, boolean var2, ServiceQueryOptions var3, Handler<AsyncResult<ServiceEntryList>> var4);

    public Future<ServiceEntryList> healthServiceNodesWithOptions(String var1, boolean var2, ServiceQueryOptions var3);

    @Fluent
    public ConsulClient healthNodesWithOptions(String var1, CheckQueryOptions var2, Handler<AsyncResult<CheckList>> var3);

    public Future<CheckList> healthNodesWithOptions(String var1, CheckQueryOptions var2);

    @Fluent
    public ConsulClient catalogServices(Handler<AsyncResult<ServiceList>> var1);

    public Future<ServiceList> catalogServices();

    @Fluent
    public ConsulClient catalogServicesWithOptions(BlockingQueryOptions var1, Handler<AsyncResult<ServiceList>> var2);

    public Future<ServiceList> catalogServicesWithOptions(BlockingQueryOptions var1);

    @Fluent
    public ConsulClient catalogNodeServices(String var1, Handler<AsyncResult<ServiceList>> var2);

    public Future<ServiceList> catalogNodeServices(String var1);

    @Fluent
    public ConsulClient catalogNodeServicesWithOptions(String var1, BlockingQueryOptions var2, Handler<AsyncResult<ServiceList>> var3);

    public Future<ServiceList> catalogNodeServicesWithOptions(String var1, BlockingQueryOptions var2);

    @Fluent
    public ConsulClient localServices(Handler<AsyncResult<List<Service>>> var1);

    public Future<List<Service>> localServices();

    @Fluent
    public ConsulClient localChecks(Handler<AsyncResult<List<Check>>> var1);

    public Future<List<Check>> localChecks();

    @Fluent
    public ConsulClient registerCheck(CheckOptions var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> registerCheck(CheckOptions var1);

    @Fluent
    public ConsulClient deregisterCheck(String var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> deregisterCheck(String var1);

    @Fluent
    public ConsulClient passCheck(String var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> passCheck(String var1);

    @Fluent
    public ConsulClient passCheckWithNote(String var1, String var2, Handler<AsyncResult<Void>> var3);

    public Future<Void> passCheckWithNote(String var1, String var2);

    @Fluent
    public ConsulClient warnCheck(String var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> warnCheck(String var1);

    @Fluent
    public ConsulClient warnCheckWithNote(String var1, String var2, Handler<AsyncResult<Void>> var3);

    public Future<Void> warnCheckWithNote(String var1, String var2);

    @Fluent
    public ConsulClient failCheck(String var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> failCheck(String var1);

    @Fluent
    public ConsulClient failCheckWithNote(String var1, String var2, Handler<AsyncResult<Void>> var3);

    public Future<Void> failCheckWithNote(String var1, String var2);

    @Fluent
    public ConsulClient updateCheck(String var1, CheckStatus var2, Handler<AsyncResult<Void>> var3);

    public Future<Void> updateCheck(String var1, CheckStatus var2);

    @Fluent
    public ConsulClient updateCheckWithNote(String var1, CheckStatus var2, String var3, Handler<AsyncResult<Void>> var4);

    public Future<Void> updateCheckWithNote(String var1, CheckStatus var2, String var3);

    @Fluent
    public ConsulClient leaderStatus(Handler<AsyncResult<String>> var1);

    public Future<String> leaderStatus();

    @Fluent
    public ConsulClient peersStatus(Handler<AsyncResult<List<String>>> var1);

    public Future<List<String>> peersStatus();

    @Fluent
    public ConsulClient createSession(Handler<AsyncResult<String>> var1);

    public Future<String> createSession();

    @Fluent
    public ConsulClient createSessionWithOptions(SessionOptions var1, Handler<AsyncResult<String>> var2);

    public Future<String> createSessionWithOptions(SessionOptions var1);

    @Fluent
    public ConsulClient infoSession(String var1, Handler<AsyncResult<Session>> var2);

    public Future<Session> infoSession(String var1);

    @Fluent
    public ConsulClient infoSessionWithOptions(String var1, BlockingQueryOptions var2, Handler<AsyncResult<Session>> var3);

    public Future<Session> infoSessionWithOptions(String var1, BlockingQueryOptions var2);

    @Fluent
    public ConsulClient renewSession(String var1, Handler<AsyncResult<Session>> var2);

    public Future<Session> renewSession(String var1);

    @Fluent
    public ConsulClient listSessions(Handler<AsyncResult<SessionList>> var1);

    public Future<SessionList> listSessions();

    @Fluent
    public ConsulClient listSessionsWithOptions(BlockingQueryOptions var1, Handler<AsyncResult<SessionList>> var2);

    public Future<SessionList> listSessionsWithOptions(BlockingQueryOptions var1);

    @Fluent
    public ConsulClient listNodeSessions(String var1, Handler<AsyncResult<SessionList>> var2);

    public Future<SessionList> listNodeSessions(String var1);

    @Fluent
    public ConsulClient listNodeSessionsWithOptions(String var1, BlockingQueryOptions var2, Handler<AsyncResult<SessionList>> var3);

    public Future<SessionList> listNodeSessionsWithOptions(String var1, BlockingQueryOptions var2);

    @Fluent
    public ConsulClient destroySession(String var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> destroySession(String var1);

    @Fluent
    public ConsulClient createPreparedQuery(PreparedQueryDefinition var1, Handler<AsyncResult<String>> var2);

    public Future<String> createPreparedQuery(PreparedQueryDefinition var1);

    @Fluent
    public ConsulClient getPreparedQuery(String var1, Handler<AsyncResult<PreparedQueryDefinition>> var2);

    public Future<PreparedQueryDefinition> getPreparedQuery(String var1);

    @Fluent
    public ConsulClient getAllPreparedQueries(Handler<AsyncResult<List<PreparedQueryDefinition>>> var1);

    public Future<List<PreparedQueryDefinition>> getAllPreparedQueries();

    @Fluent
    public ConsulClient updatePreparedQuery(PreparedQueryDefinition var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> updatePreparedQuery(PreparedQueryDefinition var1);

    @Fluent
    public ConsulClient deletePreparedQuery(String var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> deletePreparedQuery(String var1);

    @Fluent
    public ConsulClient executePreparedQuery(String var1, Handler<AsyncResult<PreparedQueryExecuteResponse>> var2);

    public Future<PreparedQueryExecuteResponse> executePreparedQuery(String var1);

    @Fluent
    public ConsulClient executePreparedQueryWithOptions(String var1, PreparedQueryExecuteOptions var2, Handler<AsyncResult<PreparedQueryExecuteResponse>> var3);

    public Future<PreparedQueryExecuteResponse> executePreparedQueryWithOptions(String var1, PreparedQueryExecuteOptions var2);

    @Fluent
    public ConsulClient registerCatalogService(Node var1, ServiceOptions var2, Handler<AsyncResult<Void>> var3);

    @Fluent
    public ConsulClient deregisterCatalogService(String var1, String var2, Handler<AsyncResult<Void>> var3);

    public void close();
}

