/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.CheckOptionsConverter;
import io.vertx.ext.consul.CheckStatus;
import java.util.List;
import java.util.Map;

@DataObject(generateConverter=true)
public class CheckOptions {
    private String id;
    private String name;
    private List<String> scriptArgs;
    private String http;
    private Map<String, List<String>> header;
    private String ttl;
    private String tcp;
    private String grpc;
    private boolean grpcTls;
    private boolean tlsSkipVerify;
    private String interval;
    private String notes;
    private String serviceId;
    private String deregisterAfter;
    private CheckStatus status;

    public CheckOptions() {
    }

    public CheckOptions(CheckOptions options) {
        this.id = options.id;
        this.name = options.name;
        this.scriptArgs = options.scriptArgs;
        this.http = options.http;
        this.header = options.header;
        this.ttl = options.ttl;
        this.tcp = options.tcp;
        this.interval = options.interval;
        this.notes = options.notes;
    }

    public CheckOptions(JsonObject options) {
        CheckOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)options, this);
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        CheckOptionsConverter.toJson(this, jsonObject);
        return jsonObject;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public CheckOptions setServiceId(String serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    public CheckStatus getStatus() {
        return this.status;
    }

    public CheckOptions setStatus(CheckStatus status) {
        this.status = status;
        return this;
    }

    public List<String> getScriptArgs() {
        return this.scriptArgs;
    }

    public CheckOptions setScriptArgs(List<String> scriptArgs) {
        this.scriptArgs = scriptArgs;
        return this;
    }

    public String getHttp() {
        return this.http;
    }

    public CheckOptions setHttp(String http) {
        this.http = http;
        return this;
    }

    public Map<String, List<String>> getHeaders() {
        return this.header;
    }

    public CheckOptions setHeaders(Map<String, List<String>> header) {
        this.header = header;
        return this;
    }

    public String getGrpc() {
        return this.grpc;
    }

    public CheckOptions setGrpc(String grpc) {
        this.grpc = grpc;
        return this;
    }

    public boolean isGrpcTls() {
        return this.grpcTls;
    }

    public CheckOptions setGrpcTls(boolean grpcTls) {
        this.grpcTls = grpcTls;
        return this;
    }

    public boolean isTlsSkipVerify() {
        return this.tlsSkipVerify;
    }

    public CheckOptions setTlsSkipVerify(boolean tlsSkipVerify) {
        this.tlsSkipVerify = tlsSkipVerify;
        return this;
    }

    public String getTtl() {
        return this.ttl;
    }

    public CheckOptions setTtl(String ttl) {
        this.ttl = ttl;
        return this;
    }

    public String getTcp() {
        return this.tcp;
    }

    public CheckOptions setTcp(String tcp) {
        this.tcp = tcp;
        return this;
    }

    public String getInterval() {
        return this.interval;
    }

    public CheckOptions setInterval(String interval) {
        this.interval = interval;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public CheckOptions setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public CheckOptions setName(String name) {
        this.name = name;
        return this;
    }

    public String getNotes() {
        return this.notes;
    }

    public CheckOptions setNotes(String notes) {
        this.notes = notes;
        return this;
    }

    public String getDeregisterAfter() {
        return this.deregisterAfter;
    }

    public CheckOptions setDeregisterAfter(String deregisterAfter) {
        this.deregisterAfter = deregisterAfter;
        return this;
    }
}

