/*
 * Decompiled with CFR 0.152.
 */
package glide.utils;

import glide.api.models.GlideString;
import java.util.ArrayList;
import java.util.Map;

public class ArgsBuilder {
    ArrayList<GlideString> argumentsList = new ArrayList();

    public <ArgType> ArgsBuilder add(ArgType[] args) {
        for (ArgType arg : args) {
            this.argumentsList.add(GlideString.of(arg));
        }
        return this;
    }

    public <ArgType> ArgsBuilder add(ArgType arg) {
        this.argumentsList.add(GlideString.of(arg));
        return this;
    }

    public <ArgType> ArgsBuilder addIf(ArgType[] args, boolean condition) {
        if (condition) {
            for (ArgType arg : args) {
                this.argumentsList.add(GlideString.of(arg));
            }
        }
        return this;
    }

    public <ArgType> ArgsBuilder addIf(ArgType arg, boolean condition) {
        if (condition) {
            this.argumentsList.add(GlideString.of(arg));
        }
        return this;
    }

    public ArgsBuilder add(String[] args) {
        for (String arg : args) {
            this.argumentsList.add(GlideString.of(arg));
        }
        return this;
    }

    public ArgsBuilder add(int[] args) {
        for (int arg : args) {
            this.argumentsList.add(GlideString.of(arg));
        }
        return this;
    }

    public GlideString[] toArray() {
        return this.argumentsList.toArray(new GlideString[0]);
    }

    public static <ArgType> void checkTypeOrThrow(ArgType arg) {
        if (arg instanceof String || arg instanceof GlideString) {
            return;
        }
        throw new IllegalArgumentException("Expected String or GlideString");
    }

    public static <ArgType> void checkTypeOrThrow(ArgType[] args) {
        if (args.length == 0) {
            return;
        }
        ArgsBuilder.checkTypeOrThrow(args[0]);
    }

    public static <ArgType> void checkTypeOrThrow(Map<ArgType, ArgType> argsMap) {
        if (argsMap.isEmpty()) {
            return;
        }
        ArgType arg = argsMap.keySet().iterator().next();
        ArgsBuilder.checkTypeOrThrow(arg);
    }

    public static ArgsBuilder newArgsBuilder() {
        return new ArgsBuilder();
    }
}

