/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.configuration;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import glide.api.models.exceptions.RequestException;
import lombok.Generated;
import lombok.NonNull;

public class RequestRoutingConfiguration {

    public static class ByAddressRoute
    implements SingleNodeRoute {
        private final String host;
        private final int port;

        @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Constructor validates input and throws immediately on malformed address")
        public ByAddressRoute(@NonNull String host, int port) {
            if (host == null) {
                throw new NullPointerException("host is marked non-null but is null");
            }
            this.host = host;
            this.port = port;
        }

        @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Constructor parses string and fails fast on invalid port format")
        public ByAddressRoute(@NonNull String host) {
            if (host == null) {
                throw new NullPointerException("host is marked non-null but is null");
            }
            String[] split = host.split(":");
            if (split.length < 2) {
                throw new RequestException("No port provided, and host is not in the expected format 'hostname:port'. Received: " + host);
            }
            this.host = split[0];
            try {
                this.port = Integer.parseInt(split[1]);
            }
            catch (NumberFormatException e) {
                throw new RequestException("Port must be a valid integer. Received: " + split[1]);
            }
        }

        @Generated
        public String getHost() {
            return this.host;
        }

        @Generated
        public int getPort() {
            return this.port;
        }
    }

    public static class SlotKeyRoute
    implements SingleNodeRoute {
        private final String slotKey;
        private final SlotType slotType;

        public SlotKeyRoute(String slotKey, SlotType slotType) {
            this.slotKey = slotKey;
            this.slotType = slotType;
        }

        @Generated
        public String getSlotKey() {
            return this.slotKey;
        }

        @Generated
        public SlotType getSlotType() {
            return this.slotType;
        }
    }

    public static class SlotIdRoute
    implements SingleNodeRoute {
        private final int slotId;
        private final SlotType slotType;

        public SlotIdRoute(int slotId, SlotType slotType) {
            this.slotId = slotId;
            this.slotType = slotType;
        }

        @Generated
        public int getSlotId() {
            return this.slotId;
        }

        @Generated
        public SlotType getSlotType() {
            return this.slotType;
        }
    }

    public static enum SlotType {
        PRIMARY,
        REPLICA;

    }

    public static enum SimpleMultiNodeRoute implements MultiNodeRoute
    {
        ALL_NODES(0),
        ALL_PRIMARIES(1);

        private final int ordinal;

        @Generated
        private SimpleMultiNodeRoute(int ordinal) {
            this.ordinal = ordinal;
        }

        @Generated
        public int getOrdinal() {
            return this.ordinal;
        }
    }

    public static enum SimpleSingleNodeRoute implements SingleNodeRoute
    {
        RANDOM(2);

        private final int ordinal;

        @Generated
        private SimpleSingleNodeRoute(int ordinal) {
            this.ordinal = ordinal;
        }

        @Generated
        public int getOrdinal() {
            return this.ordinal;
        }
    }

    public static interface MultiNodeRoute
    extends Route {
    }

    public static interface SingleNodeRoute
    extends Route {
    }

    public static interface Route {
    }
}

