/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;

public class GlideString
implements Comparable<GlideString> {
    private byte[] bytes;
    private String string = null;
    private final AtomicBoolean conversionChecked = new AtomicBoolean(false);

    private GlideString() {
    }

    public static GlideString of(String string) {
        GlideString res = new GlideString();
        res.string = string;
        res.bytes = string.getBytes(StandardCharsets.UTF_8);
        return res;
    }

    public static GlideString of(byte[] bytes) {
        GlideString res = new GlideString();
        res.bytes = (byte[])bytes.clone();
        return res;
    }

    public static <ArgType> GlideString of(ArgType o) {
        if (o instanceof GlideString) {
            return (GlideString)o;
        }
        if (o instanceof byte[]) {
            return GlideString.of((byte[])o);
        }
        if (o instanceof String) {
            return GlideString.of((String)o);
        }
        GlideString res = new GlideString();
        res.string = o.toString();
        res.bytes = res.string.getBytes(StandardCharsets.UTF_8);
        return res;
    }

    public static GlideString gs(String string) {
        return GlideString.of(string);
    }

    public static GlideString gs(byte[] bytes) {
        return GlideString.of(bytes);
    }

    public byte[] getBytes() {
        return (byte[])this.bytes.clone();
    }

    public String toString() {
        return this.getString();
    }

    public String getString() {
        if (this.string != null) {
            return this.string;
        }
        if (this.canConvertToString()) {
            return this.string;
        }
        return String.format("Value not convertible to string: byte[] %d", Arrays.hashCode(this.bytes));
    }

    @Override
    public int compareTo(GlideString o) {
        return Arrays.compare(this.bytes, o.bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canConvertToString() {
        if (this.string != null) {
            return true;
        }
        if (this.conversionChecked.get()) {
            return false;
        }
        GlideString glideString = this;
        synchronized (glideString) {
            if (this.conversionChecked.get()) {
                return false;
            }
            try {
                String tmpStr = new String(this.bytes, StandardCharsets.UTF_8);
                if (Arrays.equals(this.bytes, tmpStr.getBytes(StandardCharsets.UTF_8))) {
                    this.string = tmpStr;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.conversionChecked.set(true);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GlideString)) {
            return false;
        }
        GlideString that = (GlideString)o;
        return Arrays.equals(this.bytes, that.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public GlideString concat(GlideString other) {
        byte[] concatenatedBytes = new byte[this.bytes.length + other.bytes.length];
        System.arraycopy(this.bytes, 0, concatenatedBytes, 0, this.bytes.length);
        System.arraycopy(other.bytes, 0, concatenatedBytes, this.bytes.length, other.bytes.length);
        return GlideString.of(concatenatedBytes);
    }
}

