/*
 * Decompiled with CFR 0.152.
 */
package io.v.x.ref.services.syncbase.server.interfaces;

import com.google.common.base.Function;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.security.access.Tag;
import io.v.v23.services.syncbase.BlobRef;
import io.v.v23.services.syncbase.Id;
import io.v.v23.services.syncbase.SyncgroupMemberInfo;
import io.v.v23.vdl.ServerSendStream;
import io.v.v23.vdl.ServerStream;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup;
import io.v.x.ref.services.syncbase.server.interfaces.ChunkData;
import io.v.x.ref.services.syncbase.server.interfaces.ChunkHash;
import io.v.x.ref.services.syncbase.server.interfaces.DeltaFinalResp;
import io.v.x.ref.services.syncbase.server.interfaces.DeltaReq;
import io.v.x.ref.services.syncbase.server.interfaces.DeltaResp;
import io.v.x.ref.services.syncbase.server.interfaces.GenVector;
import io.v.x.ref.services.syncbase.server.interfaces.SgPriorities;
import io.v.x.ref.services.syncbase.server.interfaces.Signpost;
import io.v.x.ref.services.syncbase.server.interfaces.SyncServer;
import io.v.x.ref.services.syncbase.server.interfaces.Syncgroup;
import io.v.x.ref.services.syncbase.server.interfaces.TimeReq;
import io.v.x.ref.services.syncbase.server.interfaces.TimeResp;
import java.lang.reflect.Type;
import java.util.ArrayList;

public final class SyncServerWrapper {
    private final SyncServer server;

    public SyncServerWrapper(SyncServer server) {
        this.server = server;
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)TimeReq.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)TimeResp.class))));
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        methods.add(new Method("getTime", "// GetTime returns metadata related to the Syncbase virtual clock, including// system clock values, last NTP timestamp, num reboots, etc.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)DeltaReq.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)DeltaFinalResp.class))));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("getDeltas", "// GetDeltas returns the responder's current generation vectors and all// the missing log records when compared to the initiator's generation// vectors for one Database for either syncgroup metadata or data.// The final result (in DeltaFinalResp) currently includes the// syncgroup priorities for blob ownership for the server.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Syncgroup.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<GenVector>(){}.getType())));
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("publishSyncgroup", "// PublishSyncgroup is invoked on the syncgroup name (typically served// by a \"central\" peer) to publish the syncgroup.  It takes the name of// Syncbase doing the publishing (the publisher) and returns the name// of the Syncbase where the syncgroup is published (the publishee).// This allows the publisher and the publishee to learn of each other.// When a syncgroup is published, the publishee is given the syncgroup// metadata, its current version at the publisher, and the current// syncgroup generation vector.  The generation vector serves as a// checkpoint at the time of publishing.  The publishing proceeds// asynchronously, and the publishee learns the syncgroup history// through the routine p2p sync process and determines when it has// caught up to the level of knowledge at the time of publishing using// the checkpointed generation vector.  Until that point, the publishee// locally deems the syncgroup to be in a pending state and does not// mutate it.  Thus it locally rejects syncgroup joins or updates to// its spec until it is caught up on the syncgroup history.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Id.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Id.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)SyncgroupMemberInfo.class))));
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Syncgroup.class))));
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        outArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<GenVector>(){}.getType())));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("joinSyncgroupAtAdmin", "// JoinSyncgroupAtAdmin is invoked by a prospective syncgroup member's// Syncbase on a syncgroup admin. It checks whether the requestor is// allowed to join the named syncgroup, and if so, adds the requestor to// the syncgroup.  It returns a copy of the updated syncgroup metadata,// its version, and the syncgroup generation vector at the time of the// join.  Similar to the PublishSyncgroup scenario, the joiner at that// point does not have the syncgroup history and locally deems it to be// in a pending state and does not mutate it.  This means it rejects// local updates to the syncgroup spec or, if it were also an admin on// the syncgroup, it would reject syncgroup joins until it is caught up// on the syncgroup history through p2p sync.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BlobRef.class))));
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Long.class))));
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Signpost.class))));
        tags = new ArrayList();
        methods.add(new Method("haveBlob", "// HaveBlob verifies that the peer has the requested blob, and if// present, returns its size.  Otherwise, it returns -1, and the location// hints (the Signpost) that the peer has for the blob, filtered to// include only data the caller is permitted to see:// + Device D reveals a syncgroup SG to the caller C iff//   - D is in SG, and//   - SG is in the Signpost, and//   - at least one of://     - SG is not private, or//     - C has permission to join SG.// + Device D reveals a location hint L to caller C iff//   there is a syncgroup SG such that//   - D is in SG, and//   - SG is in the Signpost, and//   - L is in SG, and//   - at least one of://     - SG is not private, or//     - C has permission to join SG, or//     - L is a blob server in SG.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BlobRef.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<SgPriorities>(){}.getType())));
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<BlobSharesBySyncgroup>(){}.getType())));
        tags = new ArrayList();
        methods.add(new Method("fetchBlob", "// FetchBlob fetches the requested blob.// It returns a number of blob ownership shares that the server hopes// the client will accept using the AcceptedBlobOwnership() call.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BlobRef.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<SgPriorities>(){}.getType())));
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<BlobSharesBySyncgroup>(){}.getType())));
        tags = new ArrayList();
        methods.add(new Method("fetchBlobRecipe", "// Methods for incremental blob transfer. The transfer starts with the// receiver making a FetchBlobRecipe call to the sender for a given// BlobRef. The sender, in turn, sends the chunk hashes of all the// chunks that make up the requested blob (blob recipe). The receiver// looks up the chunk hashes in its local blob store, and identifies the// missing ones. The receiver then fetches the missing chunks using a// FetchChunks call from the sender. Finally, the receiver finishes the// blob fetch by combining the chunks obtained over the network with the// already available local chunks as per the blob recipe.// callerName is the syncbase Id of the caller, expressed as a string.// FetchBlobRecipe returns a number of blob ownership shares that the// server hopes the client will accept for each syncgroup using the// AcceptedBlobOwnership() call.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        tags = new ArrayList();
        methods.add(new Method("fetchChunks", "", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BlobRef.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<BlobSharesBySyncgroup>(){}.getType())));
        outArgs = new ArrayList();
        tags = new ArrayList();
        methods.add(new Method("requestTakeBlob", "// RequestTakeBlob indicates that the caller wishes the server to take// some blob ownership shares for various syncgroups for the specified blob.// If the server chooses to act on the request, it may call FetchBlob/FetchBlobRecipe,// and ultimately AcceptedBlobOwnership().// callerName is the syncbase Id of the caller, expressed as a string.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BlobRef.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<BlobSharesBySyncgroup>(){}.getType())));
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Boolean.class))));
        tags = new ArrayList();
        methods.add(new Method("acceptedBlobOwnership", "// AcceptedBlobOwnership tells the server that the client callerName (a// syncbase Id expressed as a string) has accepted blob ownership of a// specified number of shares for blob br.  The server may decrement// its share count by up to this number.  It is safe for the server to// decrement its share count by fewer than the number of shares another// device has taken responsibility for, but unsafe to decrement it by// more than that that number.  It returns a hint as to whether the// server is likely to keep the blob itself, plus its syncbase Id// expressed as a string.", inArgs, outArgs, null, null, tags));
        return new Interface("Sync", "io.v.x.ref.services.syncbase.server.interfaces", "// Sync defines methods for data exchange between Syncbases.// TODO(hpucha): Flesh this out further.", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("acceptedBlobOwnership".equals(method)) {
            try {
                return new VdlValue[0];
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"acceptedBlobOwnership\": %s", e.getMessage()));
            }
        }
        if ("fetchBlob".equals(method)) {
            try {
                return new VdlValue[0];
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"fetchBlob\": %s", e.getMessage()));
            }
        }
        if ("fetchBlobRecipe".equals(method)) {
            try {
                return new VdlValue[0];
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"fetchBlobRecipe\": %s", e.getMessage()));
            }
        }
        if ("fetchChunks".equals(method)) {
            try {
                return new VdlValue[0];
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"fetchChunks\": %s", e.getMessage()));
            }
        }
        if ("getDeltas".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"getDeltas\": %s", e.getMessage()));
            }
        }
        if ("getTime".equals(method)) {
            try {
                return new VdlValue[0];
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"getTime\": %s", e.getMessage()));
            }
        }
        if ("haveBlob".equals(method)) {
            try {
                return new VdlValue[0];
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"haveBlob\": %s", e.getMessage()));
            }
        }
        if ("joinSyncgroupAtAdmin".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"joinSyncgroupAtAdmin\": %s", e.getMessage()));
            }
        }
        if ("publishSyncgroup".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"publishSyncgroup\": %s", e.getMessage()));
            }
        }
        if ("requestTakeBlob".equals(method)) {
            try {
                return new VdlValue[0];
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"requestTakeBlob\": %s", e.getMessage()));
            }
        }
        return null;
    }

    public ListenableFuture<TimeResp> getTime(VContext _ctx, StreamServerCall _call, TimeReq req, String initiator) {
        return this.server.getTime(_ctx, _call, req, initiator);
    }

    public ListenableFuture<DeltaFinalResp> getDeltas(VContext _ctx, final StreamServerCall _call, DeltaReq req, String initiator) {
        ServerStream<DeltaResp, Void> _stream = new ServerStream<DeltaResp, Void>(){

            @Override
            public ListenableFuture<Void> send(DeltaResp _item) {
                Class<DeltaResp> _type = DeltaResp.class;
                return _call.send(_item, (Type)((Object)_type));
            }

            @Override
            public ListenableFuture<Void> recv() {
                Class<Void> _type = Void.class;
                return Futures.transform(_call.recv((Type)((Object)_type)), (Function)new Function<Object, Void>(){

                    public Void apply(Object result) {
                        return (Void)result;
                    }
                });
            }
        };
        return this.server.getDeltas(_ctx, _call, req, initiator, (ServerSendStream<DeltaResp>)_stream);
    }

    public ListenableFuture<String> publishSyncgroup(VContext _ctx, StreamServerCall _call, String publisher, Syncgroup sg, String version, GenVector genvec) {
        return this.server.publishSyncgroup(_ctx, _call, publisher, sg, version, genvec);
    }

    public ListenableFuture<SyncServer.JoinSyncgroupAtAdminOut> joinSyncgroupAtAdmin(VContext _ctx, StreamServerCall _call, Id dbId, Id sgId, String joinerName, SyncgroupMemberInfo myInfo) {
        return this.server.joinSyncgroupAtAdmin(_ctx, _call, dbId, sgId, joinerName, myInfo);
    }

    public ListenableFuture<SyncServer.HaveBlobOut> haveBlob(VContext _ctx, StreamServerCall _call, BlobRef br) {
        return this.server.haveBlob(_ctx, _call, br);
    }

    public ListenableFuture<BlobSharesBySyncgroup> fetchBlob(VContext _ctx, final StreamServerCall _call, BlobRef br, SgPriorities mySgPriorities) {
        ServerStream<byte[], Void> _stream = new ServerStream<byte[], Void>(){

            @Override
            public ListenableFuture<Void> send(byte[] _item) {
                Class<byte[]> _type = byte[].class;
                return _call.send(_item, (Type)((Object)_type));
            }

            @Override
            public ListenableFuture<Void> recv() {
                Class<Void> _type = Void.class;
                return Futures.transform(_call.recv((Type)((Object)_type)), (Function)new Function<Object, Void>(){

                    public Void apply(Object result) {
                        return (Void)result;
                    }
                });
            }
        };
        return this.server.fetchBlob(_ctx, _call, br, mySgPriorities, (ServerSendStream<byte[]>)_stream);
    }

    public ListenableFuture<BlobSharesBySyncgroup> fetchBlobRecipe(VContext _ctx, final StreamServerCall _call, BlobRef br, String callerName, SgPriorities mySgPriorities) {
        ServerStream<ChunkHash, Void> _stream = new ServerStream<ChunkHash, Void>(){

            @Override
            public ListenableFuture<Void> send(ChunkHash _item) {
                Class<ChunkHash> _type = ChunkHash.class;
                return _call.send(_item, (Type)((Object)_type));
            }

            @Override
            public ListenableFuture<Void> recv() {
                Class<Void> _type = Void.class;
                return Futures.transform(_call.recv((Type)((Object)_type)), (Function)new Function<Object, Void>(){

                    public Void apply(Object result) {
                        return (Void)result;
                    }
                });
            }
        };
        return this.server.fetchBlobRecipe(_ctx, _call, br, callerName, mySgPriorities, (ServerSendStream<ChunkHash>)_stream);
    }

    public ListenableFuture<Void> fetchChunks(VContext _ctx, final StreamServerCall _call) {
        ServerStream<ChunkData, ChunkHash> _stream = new ServerStream<ChunkData, ChunkHash>(){

            @Override
            public ListenableFuture<Void> send(ChunkData _item) {
                Class<ChunkData> _type = ChunkData.class;
                return _call.send(_item, (Type)((Object)_type));
            }

            @Override
            public ListenableFuture<ChunkHash> recv() {
                Class<ChunkHash> _type = ChunkHash.class;
                return Futures.transform(_call.recv((Type)((Object)_type)), (Function)new Function<Object, ChunkHash>(){

                    public ChunkHash apply(Object result) {
                        return (ChunkHash)result;
                    }
                });
            }
        };
        return this.server.fetchChunks(_ctx, _call, _stream);
    }

    public ListenableFuture<Void> requestTakeBlob(VContext _ctx, StreamServerCall _call, BlobRef br, String callerName, BlobSharesBySyncgroup shares) {
        return this.server.requestTakeBlob(_ctx, _call, br, callerName, shares);
    }

    public ListenableFuture<SyncServer.AcceptedBlobOwnershipOut> acceptedBlobOwnership(VContext _ctx, StreamServerCall _call, BlobRef br, String callerName, BlobSharesBySyncgroup shares) {
        return this.server.acceptedBlobOwnership(_ctx, _call, br, callerName, shares);
    }
}

