/*
 * Decompiled with CFR 0.152.
 */
package io.v.x.ref.services.syncbase.server.interfaces;

import com.google.common.base.Function;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.Options;
import io.v.v23.V;
import io.v.v23.VFutures;
import io.v.v23.context.VContext;
import io.v.v23.options.RpcOptions;
import io.v.v23.rpc.Client;
import io.v.v23.rpc.ClientCall;
import io.v.v23.services.syncbase.BlobRef;
import io.v.v23.services.syncbase.Id;
import io.v.v23.services.syncbase.SyncgroupMemberInfo;
import io.v.v23.vdl.ClientRecvStream;
import io.v.v23.vdl.ClientStream;
import io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup;
import io.v.x.ref.services.syncbase.server.interfaces.ChunkData;
import io.v.x.ref.services.syncbase.server.interfaces.ChunkHash;
import io.v.x.ref.services.syncbase.server.interfaces.DeltaFinalResp;
import io.v.x.ref.services.syncbase.server.interfaces.DeltaReq;
import io.v.x.ref.services.syncbase.server.interfaces.DeltaResp;
import io.v.x.ref.services.syncbase.server.interfaces.GenVector;
import io.v.x.ref.services.syncbase.server.interfaces.SgPriorities;
import io.v.x.ref.services.syncbase.server.interfaces.Signpost;
import io.v.x.ref.services.syncbase.server.interfaces.SyncClient;
import io.v.x.ref.services.syncbase.server.interfaces.Syncgroup;
import io.v.x.ref.services.syncbase.server.interfaces.TimeReq;
import io.v.x.ref.services.syncbase.server.interfaces.TimeResp;
import java.lang.reflect.Type;

final class SyncClientImpl
implements SyncClient {
    private final Client client;
    private final String vName;

    public SyncClientImpl(Client client, String vName) {
        this.client = client;
        this.vName = vName;
    }

    private Client getClient(VContext context) {
        return this.client != null ? this.client : V.getClient(context);
    }

    @Override
    public ListenableFuture<TimeResp> getTime(VContext _context, TimeReq req, String initiator) {
        return this.getTime(_context, req, initiator, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<TimeResp> getTime(VContext _context, TimeReq req, String initiator, Options _opts) {
        return this.getTime(_context, req, initiator, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<TimeResp> getTime(VContext _context, TimeReq req, String initiator, RpcOptions _opts) {
        Object[] _args = new Object[]{req, initiator};
        Type[] _argTypes = new Type[]{TimeReq.class, String.class};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "getTime", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, TimeResp>(){

            public ListenableFuture<TimeResp> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{TimeResp.class};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], TimeResp>(){

                    public TimeResp apply(Object[] _results) {
                        return (TimeResp)_results[0];
                    }
                });
            }
        }));
    }

    @Override
    public ClientRecvStream<DeltaResp, DeltaFinalResp> getDeltas(VContext _context, DeltaReq req, String initiator) {
        return this.getDeltas(_context, req, initiator, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ClientRecvStream<DeltaResp, DeltaFinalResp> getDeltas(VContext _context, DeltaReq req, String initiator, Options _opts) {
        return this.getDeltas(_context, req, initiator, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ClientRecvStream<DeltaResp, DeltaFinalResp> getDeltas(final VContext _context, DeltaReq req, String initiator, RpcOptions _opts) {
        Object[] _args = new Object[]{req, initiator};
        Type[] _argTypes = new Type[]{DeltaReq.class, String.class};
        final ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "getDeltas", _args, _argTypes, _opts);
        return new ClientStream<Void, DeltaResp, DeltaFinalResp>(){

            @Override
            public ListenableFuture<Void> send(final Void item) {
                final Class<Void> type = Void.class;
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return _call.send(item, type);
                    }
                }));
            }

            @Override
            public ListenableFuture<Void> close() {
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return _call.closeSend();
                    }
                }));
            }

            @Override
            public ListenableFuture<DeltaResp> recv() {
                final Class<DeltaResp> recvType = DeltaResp.class;
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, DeltaResp>(){

                    public ListenableFuture<DeltaResp> apply(ClientCall _call) throws Exception {
                        return Futures.transform(_call.recv(recvType), (Function)new Function<Object, DeltaResp>(){

                            public DeltaResp apply(Object result) {
                                return (DeltaResp)result;
                            }
                        });
                    }
                }));
            }

            @Override
            public ListenableFuture<DeltaFinalResp> finish() {
                final Type[] resultTypes = new Type[]{DeltaFinalResp.class};
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, DeltaFinalResp>(){

                    public ListenableFuture<DeltaFinalResp> apply(ClientCall _call) throws Exception {
                        return Futures.transform(_call.finish(resultTypes), (Function)new Function<Object[], DeltaFinalResp>(){

                            public DeltaFinalResp apply(Object[] _results) {
                                return (DeltaFinalResp)_results[0];
                            }
                        });
                    }
                }));
            }
        };
    }

    @Override
    public ListenableFuture<String> publishSyncgroup(VContext _context, String publisher, Syncgroup sg, String version, GenVector genvec) {
        return this.publishSyncgroup(_context, publisher, sg, version, genvec, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<String> publishSyncgroup(VContext _context, String publisher, Syncgroup sg, String version, GenVector genvec, Options _opts) {
        return this.publishSyncgroup(_context, publisher, sg, version, genvec, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<String> publishSyncgroup(VContext _context, String publisher, Syncgroup sg, String version, GenVector genvec, RpcOptions _opts) {
        Object[] _args = new Object[]{publisher, sg, version, genvec};
        Type[] _argTypes = new Type[]{String.class, Syncgroup.class, String.class, new TypeToken<GenVector>(){}.getType()};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "publishSyncgroup", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, String>(){

            public ListenableFuture<String> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{String.class};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], String>(){

                    public String apply(Object[] _results) {
                        return (String)_results[0];
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<SyncClient.JoinSyncgroupAtAdminOut> joinSyncgroupAtAdmin(VContext _context, Id dbId, Id sgId, String joinerName, SyncgroupMemberInfo myInfo) {
        return this.joinSyncgroupAtAdmin(_context, dbId, sgId, joinerName, myInfo, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<SyncClient.JoinSyncgroupAtAdminOut> joinSyncgroupAtAdmin(VContext _context, Id dbId, Id sgId, String joinerName, SyncgroupMemberInfo myInfo, Options _opts) {
        return this.joinSyncgroupAtAdmin(_context, dbId, sgId, joinerName, myInfo, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<SyncClient.JoinSyncgroupAtAdminOut> joinSyncgroupAtAdmin(VContext _context, Id dbId, Id sgId, String joinerName, SyncgroupMemberInfo myInfo, RpcOptions _opts) {
        Object[] _args = new Object[]{dbId, sgId, joinerName, myInfo};
        Type[] _argTypes = new Type[]{Id.class, Id.class, String.class, SyncgroupMemberInfo.class};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "joinSyncgroupAtAdmin", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, SyncClient.JoinSyncgroupAtAdminOut>(){

            public ListenableFuture<SyncClient.JoinSyncgroupAtAdminOut> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{Syncgroup.class, String.class, new TypeToken<GenVector>(){}.getType()};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], SyncClient.JoinSyncgroupAtAdminOut>(){

                    public SyncClient.JoinSyncgroupAtAdminOut apply(Object[] _results) {
                        SyncClient.JoinSyncgroupAtAdminOut _ret = new SyncClient.JoinSyncgroupAtAdminOut();
                        _ret.sg = (Syncgroup)_results[0];
                        _ret.version = (String)_results[1];
                        _ret.genvec = (GenVector)_results[2];
                        return _ret;
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<SyncClient.HaveBlobOut> haveBlob(VContext _context, BlobRef br) {
        return this.haveBlob(_context, br, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<SyncClient.HaveBlobOut> haveBlob(VContext _context, BlobRef br, Options _opts) {
        return this.haveBlob(_context, br, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<SyncClient.HaveBlobOut> haveBlob(VContext _context, BlobRef br, RpcOptions _opts) {
        Object[] _args = new Object[]{br};
        Type[] _argTypes = new Type[]{BlobRef.class};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "haveBlob", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, SyncClient.HaveBlobOut>(){

            public ListenableFuture<SyncClient.HaveBlobOut> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{Long.class, Signpost.class};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], SyncClient.HaveBlobOut>(){

                    public SyncClient.HaveBlobOut apply(Object[] _results) {
                        SyncClient.HaveBlobOut _ret = new SyncClient.HaveBlobOut();
                        _ret.size = (Long)_results[0];
                        _ret.signpost = (Signpost)_results[1];
                        return _ret;
                    }
                });
            }
        }));
    }

    @Override
    public ClientRecvStream<byte[], BlobSharesBySyncgroup> fetchBlob(VContext _context, BlobRef br, SgPriorities mySgPriorities) {
        return this.fetchBlob(_context, br, mySgPriorities, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ClientRecvStream<byte[], BlobSharesBySyncgroup> fetchBlob(VContext _context, BlobRef br, SgPriorities mySgPriorities, Options _opts) {
        return this.fetchBlob(_context, br, mySgPriorities, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ClientRecvStream<byte[], BlobSharesBySyncgroup> fetchBlob(final VContext _context, BlobRef br, SgPriorities mySgPriorities, RpcOptions _opts) {
        Object[] _args = new Object[]{br, mySgPriorities};
        Type[] _argTypes = new Type[]{BlobRef.class, new TypeToken<SgPriorities>(){}.getType()};
        final ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "fetchBlob", _args, _argTypes, _opts);
        return new ClientStream<Void, byte[], BlobSharesBySyncgroup>(){

            @Override
            public ListenableFuture<Void> send(final Void item) {
                final Class<Void> type = Void.class;
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return _call.send(item, type);
                    }
                }));
            }

            @Override
            public ListenableFuture<Void> close() {
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return _call.closeSend();
                    }
                }));
            }

            @Override
            public ListenableFuture<byte[]> recv() {
                final Class<byte[]> recvType = byte[].class;
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, byte[]>(){

                    public ListenableFuture<byte[]> apply(ClientCall _call) throws Exception {
                        return Futures.transform(_call.recv(recvType), (Function)new Function<Object, byte[]>(){

                            public byte[] apply(Object result) {
                                return (byte[])result;
                            }
                        });
                    }
                }));
            }

            @Override
            public ListenableFuture<BlobSharesBySyncgroup> finish() {
                final Type[] resultTypes = new Type[]{new TypeToken<BlobSharesBySyncgroup>(){}.getType()};
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, BlobSharesBySyncgroup>(){

                    public ListenableFuture<BlobSharesBySyncgroup> apply(ClientCall _call) throws Exception {
                        return Futures.transform(_call.finish(resultTypes), (Function)new Function<Object[], BlobSharesBySyncgroup>(){

                            public BlobSharesBySyncgroup apply(Object[] _results) {
                                return (BlobSharesBySyncgroup)_results[0];
                            }
                        });
                    }
                }));
            }
        };
    }

    @Override
    public ClientRecvStream<ChunkHash, BlobSharesBySyncgroup> fetchBlobRecipe(VContext _context, BlobRef br, String callerName, SgPriorities mySgPriorities) {
        return this.fetchBlobRecipe(_context, br, callerName, mySgPriorities, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ClientRecvStream<ChunkHash, BlobSharesBySyncgroup> fetchBlobRecipe(VContext _context, BlobRef br, String callerName, SgPriorities mySgPriorities, Options _opts) {
        return this.fetchBlobRecipe(_context, br, callerName, mySgPriorities, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ClientRecvStream<ChunkHash, BlobSharesBySyncgroup> fetchBlobRecipe(final VContext _context, BlobRef br, String callerName, SgPriorities mySgPriorities, RpcOptions _opts) {
        Object[] _args = new Object[]{br, callerName, mySgPriorities};
        Type[] _argTypes = new Type[]{BlobRef.class, String.class, new TypeToken<SgPriorities>(){}.getType()};
        final ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "fetchBlobRecipe", _args, _argTypes, _opts);
        return new ClientStream<Void, ChunkHash, BlobSharesBySyncgroup>(){

            @Override
            public ListenableFuture<Void> send(final Void item) {
                final Class<Void> type = Void.class;
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return _call.send(item, type);
                    }
                }));
            }

            @Override
            public ListenableFuture<Void> close() {
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return _call.closeSend();
                    }
                }));
            }

            @Override
            public ListenableFuture<ChunkHash> recv() {
                final Class<ChunkHash> recvType = ChunkHash.class;
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, ChunkHash>(){

                    public ListenableFuture<ChunkHash> apply(ClientCall _call) throws Exception {
                        return Futures.transform(_call.recv(recvType), (Function)new Function<Object, ChunkHash>(){

                            public ChunkHash apply(Object result) {
                                return (ChunkHash)result;
                            }
                        });
                    }
                }));
            }

            @Override
            public ListenableFuture<BlobSharesBySyncgroup> finish() {
                final Type[] resultTypes = new Type[]{new TypeToken<BlobSharesBySyncgroup>(){}.getType()};
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, BlobSharesBySyncgroup>(){

                    public ListenableFuture<BlobSharesBySyncgroup> apply(ClientCall _call) throws Exception {
                        return Futures.transform(_call.finish(resultTypes), (Function)new Function<Object[], BlobSharesBySyncgroup>(){

                            public BlobSharesBySyncgroup apply(Object[] _results) {
                                return (BlobSharesBySyncgroup)_results[0];
                            }
                        });
                    }
                }));
            }
        };
    }

    @Override
    public ClientStream<ChunkHash, ChunkData, Void> fetchChunks(VContext _context) {
        return this.fetchChunks(_context, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ClientStream<ChunkHash, ChunkData, Void> fetchChunks(VContext _context, Options _opts) {
        return this.fetchChunks(_context, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ClientStream<ChunkHash, ChunkData, Void> fetchChunks(final VContext _context, RpcOptions _opts) {
        Object[] _args = new Object[]{};
        Type[] _argTypes = new Type[]{};
        final ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "fetchChunks", _args, _argTypes, _opts);
        return new ClientStream<ChunkHash, ChunkData, Void>(){

            @Override
            public ListenableFuture<Void> send(final ChunkHash item) {
                final Class<ChunkHash> type = ChunkHash.class;
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return _call.send(item, type);
                    }
                }));
            }

            @Override
            public ListenableFuture<Void> close() {
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return _call.closeSend();
                    }
                }));
            }

            @Override
            public ListenableFuture<ChunkData> recv() {
                final Class<ChunkData> recvType = ChunkData.class;
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, ChunkData>(){

                    public ListenableFuture<ChunkData> apply(ClientCall _call) throws Exception {
                        return Futures.transform(_call.recv(recvType), (Function)new Function<Object, ChunkData>(){

                            public ChunkData apply(Object result) {
                                return (ChunkData)result;
                            }
                        });
                    }
                }));
            }

            @Override
            public ListenableFuture<Void> finish() {
                final Type[] resultTypes = new Type[]{};
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return Futures.transform(_call.finish(resultTypes), (Function)new Function<Object[], Void>(){

                            public Void apply(Object[] _results) {
                                return null;
                            }
                        });
                    }
                }));
            }
        };
    }

    @Override
    public ListenableFuture<Void> requestTakeBlob(VContext _context, BlobRef br, String callerName, BlobSharesBySyncgroup shares) {
        return this.requestTakeBlob(_context, br, callerName, shares, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> requestTakeBlob(VContext _context, BlobRef br, String callerName, BlobSharesBySyncgroup shares, Options _opts) {
        return this.requestTakeBlob(_context, br, callerName, shares, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Void> requestTakeBlob(VContext _context, BlobRef br, String callerName, BlobSharesBySyncgroup shares, RpcOptions _opts) {
        Object[] _args = new Object[]{br, callerName, shares};
        Type[] _argTypes = new Type[]{BlobRef.class, String.class, new TypeToken<BlobSharesBySyncgroup>(){}.getType()};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "requestTakeBlob", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

            public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Void>(){

                    public Void apply(Object[] _results) {
                        return null;
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<SyncClient.AcceptedBlobOwnershipOut> acceptedBlobOwnership(VContext _context, BlobRef br, String callerName, BlobSharesBySyncgroup shares) {
        return this.acceptedBlobOwnership(_context, br, callerName, shares, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<SyncClient.AcceptedBlobOwnershipOut> acceptedBlobOwnership(VContext _context, BlobRef br, String callerName, BlobSharesBySyncgroup shares, Options _opts) {
        return this.acceptedBlobOwnership(_context, br, callerName, shares, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<SyncClient.AcceptedBlobOwnershipOut> acceptedBlobOwnership(VContext _context, BlobRef br, String callerName, BlobSharesBySyncgroup shares, RpcOptions _opts) {
        Object[] _args = new Object[]{br, callerName, shares};
        Type[] _argTypes = new Type[]{BlobRef.class, String.class, new TypeToken<BlobSharesBySyncgroup>(){}.getType()};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "acceptedBlobOwnership", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, SyncClient.AcceptedBlobOwnershipOut>(){

            public ListenableFuture<SyncClient.AcceptedBlobOwnershipOut> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{String.class, Boolean.class};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], SyncClient.AcceptedBlobOwnershipOut>(){

                    public SyncClient.AcceptedBlobOwnershipOut apply(Object[] _results) {
                        SyncClient.AcceptedBlobOwnershipOut _ret = new SyncClient.AcceptedBlobOwnershipOut();
                        _ret.serverName = (String)_results[0];
                        _ret.keepingBlob = (Boolean)_results[1];
                        return _ret;
                    }
                });
            }
        }));
    }
}

