/*
 * Decompiled with CFR 0.152.
 */
package io.v.x.ref.services.repository;

import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.security.access.Permissions;
import io.v.v23.security.access.Tag;
import io.v.v23.services.application.Envelope;
import io.v.v23.services.permissions.ObjectServer;
import io.v.v23.services.permissions.ObjectServerWrapper;
import io.v.v23.services.tidyable.TidyableServerWrapper;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import io.v.x.ref.services.repository.ApplicationServer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public final class ApplicationServerWrapper {
    private final ApplicationServer server;
    private final ObjectServerWrapper wrapperObject;
    private final TidyableServerWrapper wrapperTidyable;
    private final io.v.v23.services.repository.ApplicationServerWrapper wrapperApplication;

    public ApplicationServerWrapper(ApplicationServer server) {
        this.server = server;
        this.wrapperObject = new ObjectServerWrapper(server);
        this.wrapperTidyable = new TidyableServerWrapper(server);
        this.wrapperApplication = new io.v.v23.services.repository.ApplicationServerWrapper(server);
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Envelope.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Boolean.class))));
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("put", "// Put adds the given application envelope for the given profile and// application version (required, and specified through the object name// suffix).//// An error is returned if an envelope already exists, unless the// overwrite option is set.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("remove", "// Remove removes the application envelope for the given profile// name and application version (specified through the object name// suffix).//// If no version is specified as part of the suffix, the method removes// all versions for the given profile.//// If the profile is the string \"*\", all profiles are removed for the// given version (or for all versions if the version is not specified).", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<List<String>>(){}.getType())));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("profiles", "// Profiles returns the supported profiles for the application version// specified through the object name suffix.  If the version is not// specified, Profiles returns the union of profiles across all// versions.", inArgs, outArgs, null, null, tags));
        return new Interface("Application", "io.v.x.ref.services.repository", "// Application describes an application repository internally. Besides the// public Application interface, it allows adding and removing application// envelopes, as well as querying for a list of supported profiles.", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("profiles".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"profiles\": %s", e.getMessage()));
            }
        }
        if ("put".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"put\": %s", e.getMessage()));
            }
        }
        if ("remove".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"remove\": %s", e.getMessage()));
            }
        }
        VdlValue[] tags = this.wrapperObject.getMethodTags(method);
        if (tags != null) {
            return tags;
        }
        tags = this.wrapperTidyable.getMethodTags(method);
        if (tags != null) {
            return tags;
        }
        tags = this.wrapperApplication.getMethodTags(method);
        if (tags != null) {
            return tags;
        }
        return null;
    }

    public ListenableFuture<Void> put(VContext _ctx, StreamServerCall _call, String Profile, Envelope Envelope2, boolean Overwrite) {
        return this.server.put(_ctx, _call, Profile, Envelope2, Overwrite);
    }

    public ListenableFuture<Void> remove(VContext _ctx, StreamServerCall _call, String Profile) {
        return this.server.remove(_ctx, _call, Profile);
    }

    public ListenableFuture<List<String>> profiles(VContext _ctx, StreamServerCall _call) {
        return this.server.profiles(_ctx, _call);
    }

    public ListenableFuture<ObjectServer.GetPermissionsOut> getPermissions(VContext ctx, StreamServerCall call) throws VException {
        return this.wrapperObject.getPermissions(ctx, call);
    }

    public ListenableFuture<Void> setPermissions(VContext ctx, StreamServerCall call, Permissions perms, String version) throws VException {
        return this.wrapperObject.setPermissions(ctx, call, perms, version);
    }

    public ListenableFuture<Envelope> match(VContext ctx, StreamServerCall call, List<String> profiles) throws VException {
        return this.wrapperApplication.match(ctx, call, profiles);
    }

    public ListenableFuture<Void> tidyNow(VContext ctx, StreamServerCall call) throws VException {
        return this.wrapperTidyable.tidyNow(ctx, call);
    }
}

