/*
 * Decompiled with CFR 0.152.
 */
package io.v.x.ref.services.cluster;

import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.security.Blessings;
import io.v.v23.security.access.Tag;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import io.v.x.ref.services.cluster.ClusterAgentAdminServer;
import io.v.x.ref.services.cluster.ClusterAgentServerWrapper;
import java.lang.reflect.Type;
import java.util.ArrayList;

public final class ClusterAgentAdminServerWrapper {
    private final ClusterAgentAdminServer server;
    private final ClusterAgentServerWrapper wrapperClusterAgent;

    public ClusterAgentAdminServerWrapper(ClusterAgentAdminServer server) {
        this.server = server;
        this.wrapperClusterAgent = new ClusterAgentServerWrapper(server);
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)));
        methods.add(new Method("newSecret", "// Creates a new \"secret\" that can be used to retrieve extensions// of the blessings granted on this RPC, e.g. with the rpc.Granter// ClientCallOpt in Go.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)));
        methods.add(new Method("forgetSecret", "// Forgets a secret and its associated blessings.", inArgs, outArgs, null, null, tags));
        return new Interface("ClusterAgentAdmin", "io.v.x.ref.services.cluster", "", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("forgetSecret".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"forgetSecret\": %s", e.getMessage()));
            }
        }
        if ("newSecret".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"newSecret\": %s", e.getMessage()));
            }
        }
        VdlValue[] tags = this.wrapperClusterAgent.getMethodTags(method);
        if (tags != null) {
            return tags;
        }
        return null;
    }

    public ListenableFuture<String> newSecret(VContext _ctx, StreamServerCall _call) {
        return this.server.newSecret(_ctx, _call);
    }

    public ListenableFuture<Void> forgetSecret(VContext _ctx, StreamServerCall _call, String secret) {
        return this.server.forgetSecret(_ctx, _call, secret);
    }

    public ListenableFuture<Blessings> seekBlessings(VContext ctx, StreamServerCall call, String secret) throws VException {
        return this.wrapperClusterAgent.seekBlessings(ctx, call, secret);
    }
}

