/*
 * Decompiled with CFR 0.152.
 */
package io.v.x.ref.runtime.internal.rpc.stress;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.security.access.Tag;
import io.v.v23.vdl.ServerStream;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import io.v.x.ref.runtime.internal.rpc.stress.StressServer;
import io.v.x.ref.runtime.internal.rpc.stress.SumArg;
import io.v.x.ref.runtime.internal.rpc.stress.SumStats;
import java.lang.reflect.Type;
import java.util.ArrayList;

public final class StressServerWrapper {
    private final StressServer server;

    public StressServerWrapper(StressServer server) {
        this.server = server;
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)byte[].class))));
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)byte[].class))));
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("echo", "// Echo returns the payload that it receives.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)SumArg.class))));
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)byte[].class))));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("sum", "// Do returns the checksum of the payload that it receives.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("sumStream", "// DoStream returns the checksum of the payload that it receives via the stream.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)SumStats.class))));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("getSumStats", "// GetSumStats returns the stats on the Sum calls that the server received.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)));
        methods.add(new Method("stop", "// Stop stops the server.", inArgs, outArgs, null, null, tags));
        return new Interface("Stress", "io.v.x.ref.runtime.internal.rpc.stress", "", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("echo".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"echo\": %s", e.getMessage()));
            }
        }
        if ("getSumStats".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"getSumStats\": %s", e.getMessage()));
            }
        }
        if ("stop".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"stop\": %s", e.getMessage()));
            }
        }
        if ("sum".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"sum\": %s", e.getMessage()));
            }
        }
        if ("sumStream".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"sumStream\": %s", e.getMessage()));
            }
        }
        return null;
    }

    public ListenableFuture<byte[]> echo(VContext _ctx, StreamServerCall _call, byte[] Payload) {
        return this.server.echo(_ctx, _call, Payload);
    }

    public ListenableFuture<byte[]> sum(VContext _ctx, StreamServerCall _call, SumArg arg) {
        return this.server.sum(_ctx, _call, arg);
    }

    public ListenableFuture<Void> sumStream(VContext _ctx, final StreamServerCall _call) {
        ServerStream<byte[], SumArg> _stream = new ServerStream<byte[], SumArg>(){

            @Override
            public ListenableFuture<Void> send(byte[] _item) {
                Class<byte[]> _type = byte[].class;
                return _call.send(_item, (Type)((Object)_type));
            }

            @Override
            public ListenableFuture<SumArg> recv() {
                Class<SumArg> _type = SumArg.class;
                return Futures.transform(_call.recv((Type)((Object)_type)), (Function)new Function<Object, SumArg>(){

                    public SumArg apply(Object result) {
                        return (SumArg)result;
                    }
                });
            }
        };
        return this.server.sumStream(_ctx, _call, _stream);
    }

    public ListenableFuture<SumStats> getSumStats(VContext _ctx, StreamServerCall _call) {
        return this.server.getSumStats(_ctx, _call);
    }

    public ListenableFuture<Void> stop(VContext _ctx, StreamServerCall _call) {
        return this.server.stop(_ctx, _call);
    }
}

