/*
 * Decompiled with CFR 0.152.
 */
package io.v.x.ref.runtime.internal.rpc.benchmark;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.security.access.Tag;
import io.v.v23.vdl.ServerStream;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import io.v.x.ref.runtime.internal.rpc.benchmark.BenchmarkServer;
import java.lang.reflect.Type;
import java.util.ArrayList;

public final class BenchmarkServerWrapper {
    private final BenchmarkServer server;

    public BenchmarkServerWrapper(BenchmarkServer server) {
        this.server = server;
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)byte[].class))));
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)byte[].class))));
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("echo", "// Echo returns the payload that it receives.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("echoStream", "// EchoStream returns the payload that it receives via the stream.", inArgs, outArgs, null, null, tags));
        return new Interface("Benchmark", "io.v.x.ref.runtime.internal.rpc.benchmark", "", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("echo".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"echo\": %s", e.getMessage()));
            }
        }
        if ("echoStream".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"echoStream\": %s", e.getMessage()));
            }
        }
        return null;
    }

    public ListenableFuture<byte[]> echo(VContext _ctx, StreamServerCall _call, byte[] Payload) {
        return this.server.echo(_ctx, _call, Payload);
    }

    public ListenableFuture<Void> echoStream(VContext _ctx, final StreamServerCall _call) {
        ServerStream<byte[], byte[]> _stream = new ServerStream<byte[], byte[]>(){

            @Override
            public ListenableFuture<Void> send(byte[] _item) {
                Class<byte[]> _type = byte[].class;
                return _call.send(_item, (Type)((Object)_type));
            }

            @Override
            public ListenableFuture<byte[]> recv() {
                Class<byte[]> _type = byte[].class;
                return Futures.transform(_call.recv((Type)((Object)_type)), (Function)new Function<Object, byte[]>(){

                    public byte[] apply(Object result) {
                        return (byte[])result;
                    }
                });
            }
        };
        return this.server.echoStream(_ctx, _call, _stream);
    }
}

