/*
 * Decompiled with CFR 0.152.
 */
package io.v.x.ref.lib.vdl.testdata.arith;

import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import io.v.x.ref.lib.vdl.testdata.arith.AdvancedMathServerWrapper;
import io.v.x.ref.lib.vdl.testdata.arith.ArithServer;
import io.v.x.ref.lib.vdl.testdata.arith.ArithServerWrapper;
import io.v.x.ref.lib.vdl.testdata.arith.CalculatorServer;
import io.v.x.ref.lib.vdl.testdata.arith.TrigonometryServerWrapper;
import io.v.x.ref.lib.vdl.testdata.arith.exp.ExpServerWrapper;
import io.v.x.ref.lib.vdl.testdata.base.Args;
import io.v.x.ref.lib.vdl.testdata.base.NestedArgs;
import java.util.ArrayList;

public final class CalculatorServerWrapper {
    private final CalculatorServer server;
    private final ArithServerWrapper wrapperArith;
    private final TrigonometryServerWrapper wrapperTrigonometry;
    private final ExpServerWrapper wrapperExp;
    private final AdvancedMathServerWrapper wrapperAdvancedMath;

    public CalculatorServerWrapper(CalculatorServer server) {
        this.server = server;
        this.wrapperArith = new ArithServerWrapper(server);
        this.wrapperTrigonometry = new TrigonometryServerWrapper(server);
        this.wrapperExp = new ExpServerWrapper(server);
        this.wrapperAdvancedMath = new AdvancedMathServerWrapper(server);
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        methods.add(new Method("on", "", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)"offtag", String.class)));
        methods.add(new Method("off", "", inArgs, outArgs, null, null, tags));
        return new Interface("Calculator", "io.v.x.ref.lib.vdl.testdata.arith", "", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("off".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)"offtag", String.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"off\": %s", e.getMessage()));
            }
        }
        if ("on".equals(method)) {
            try {
                return new VdlValue[0];
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"on\": %s", e.getMessage()));
            }
        }
        VdlValue[] tags = this.wrapperArith.getMethodTags(method);
        if (tags != null) {
            return tags;
        }
        tags = this.wrapperTrigonometry.getMethodTags(method);
        if (tags != null) {
            return tags;
        }
        tags = this.wrapperExp.getMethodTags(method);
        if (tags != null) {
            return tags;
        }
        tags = this.wrapperAdvancedMath.getMethodTags(method);
        if (tags != null) {
            return tags;
        }
        return null;
    }

    public ListenableFuture<Void> on(VContext _ctx, StreamServerCall _call) {
        return this.server.on(_ctx, _call);
    }

    public ListenableFuture<Void> off(VContext _ctx, StreamServerCall _call) {
        return this.server.off(_ctx, _call);
    }

    public ListenableFuture<Double> exp(VContext ctx, StreamServerCall call, double x) throws VException {
        return this.wrapperExp.exp(ctx, call, x);
    }

    public ListenableFuture<Integer> add(VContext ctx, StreamServerCall call, int a, int b) throws VException {
        return this.wrapperArith.add(ctx, call, a, b);
    }

    public ListenableFuture<Void> count(VContext ctx, StreamServerCall call, int start) throws VException {
        return this.wrapperArith.count(ctx, call, start);
    }

    public ListenableFuture<ArithServer.DivModOut> divMod(VContext ctx, StreamServerCall call, int a, int b) throws VException {
        return this.wrapperArith.divMod(ctx, call, a, b);
    }

    public ListenableFuture<Void> genError(VContext ctx, StreamServerCall call) throws VException {
        return this.wrapperArith.genError(ctx, call);
    }

    public ListenableFuture<Integer> mul(VContext ctx, StreamServerCall call, NestedArgs nested) throws VException {
        return this.wrapperArith.mul(ctx, call, nested);
    }

    public ListenableFuture<VdlAny> quoteAny(VContext ctx, StreamServerCall call, VdlAny a) throws VException {
        return this.wrapperArith.quoteAny(ctx, call, a);
    }

    public ListenableFuture<Integer> streamingAdd(VContext ctx, StreamServerCall call) throws VException {
        return this.wrapperArith.streamingAdd(ctx, call);
    }

    public ListenableFuture<Integer> sub(VContext ctx, StreamServerCall call, Args args) throws VException {
        return this.wrapperArith.sub(ctx, call, args);
    }

    public ListenableFuture<Double> cosine(VContext ctx, StreamServerCall call, double angle) throws VException {
        return this.wrapperTrigonometry.cosine(ctx, call, angle);
    }

    public ListenableFuture<Double> sine(VContext ctx, StreamServerCall call, double angle) throws VException {
        return this.wrapperTrigonometry.sine(ctx, call, angle);
    }
}

