/*
 * Decompiled with CFR 0.152.
 */
package io.v.x.ref.lib.vdl.testdata.arith;

import com.google.common.base.Function;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.Options;
import io.v.v23.V;
import io.v.v23.VFutures;
import io.v.v23.context.VContext;
import io.v.v23.options.RpcOptions;
import io.v.v23.rpc.Client;
import io.v.v23.rpc.ClientCall;
import io.v.v23.vdl.ClientRecvStream;
import io.v.v23.vdl.ClientStream;
import io.v.v23.vdl.VdlAny;
import io.v.x.ref.lib.vdl.testdata.arith.AdvancedMathClient;
import io.v.x.ref.lib.vdl.testdata.arith.AdvancedMathClientFactory;
import io.v.x.ref.lib.vdl.testdata.arith.ArithClient;
import io.v.x.ref.lib.vdl.testdata.arith.ArithClientFactory;
import io.v.x.ref.lib.vdl.testdata.arith.CalculatorClient;
import io.v.x.ref.lib.vdl.testdata.arith.TrigonometryClient;
import io.v.x.ref.lib.vdl.testdata.arith.TrigonometryClientFactory;
import io.v.x.ref.lib.vdl.testdata.arith.exp.ExpClient;
import io.v.x.ref.lib.vdl.testdata.arith.exp.ExpClientFactory;
import io.v.x.ref.lib.vdl.testdata.base.Args;
import io.v.x.ref.lib.vdl.testdata.base.NestedArgs;
import java.lang.reflect.Type;

final class CalculatorClientImpl
implements CalculatorClient {
    private final Client client;
    private final String vName;
    private final ArithClient implArith;
    private final TrigonometryClient implTrigonometry;
    private final ExpClient implExp;
    private final AdvancedMathClient implAdvancedMath;

    public CalculatorClientImpl(Client client, String vName) {
        this.client = client;
        this.vName = vName;
        Options opts = new Options();
        opts.set("io.v.v23.CLIENT", client);
        this.implArith = ArithClientFactory.getArithClient(vName, opts);
        opts = new Options();
        opts.set("io.v.v23.CLIENT", client);
        this.implTrigonometry = TrigonometryClientFactory.getTrigonometryClient(vName, opts);
        opts = new Options();
        opts.set("io.v.v23.CLIENT", client);
        this.implExp = ExpClientFactory.getExpClient(vName, opts);
        opts = new Options();
        opts.set("io.v.v23.CLIENT", client);
        this.implAdvancedMath = AdvancedMathClientFactory.getAdvancedMathClient(vName, opts);
    }

    private Client getClient(VContext context) {
        return this.client != null ? this.client : V.getClient(context);
    }

    @Override
    public ListenableFuture<Void> on(VContext _context) {
        return this.on(_context, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> on(VContext _context, Options _opts) {
        return this.on(_context, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Void> on(VContext _context, RpcOptions _opts) {
        Object[] _args = new Object[]{};
        Type[] _argTypes = new Type[]{};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "on", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

            public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Void>(){

                    public Void apply(Object[] _results) {
                        return null;
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<Void> off(VContext _context) {
        return this.off(_context, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> off(VContext _context, Options _opts) {
        return this.off(_context, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Void> off(VContext _context, RpcOptions _opts) {
        Object[] _args = new Object[]{};
        Type[] _argTypes = new Type[]{};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "off", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

            public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Void>(){

                    public Void apply(Object[] _results) {
                        return null;
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<Double> exp(VContext _context, double x) {
        return this.implExp.exp(_context, x);
    }

    @Override
    @Deprecated
    public ListenableFuture<Double> exp(VContext _context, double x, Options _opts) {
        return this.implExp.exp(_context, x, _opts);
    }

    @Override
    public ListenableFuture<Double> exp(VContext _context, double x, RpcOptions _opts) {
        return this.implExp.exp(_context, x, _opts);
    }

    @Override
    public ListenableFuture<Integer> add(VContext _context, int a, int b) {
        return this.implArith.add(_context, a, b);
    }

    @Override
    @Deprecated
    public ListenableFuture<Integer> add(VContext _context, int a, int b, Options _opts) {
        return this.implArith.add(_context, a, b, _opts);
    }

    @Override
    public ListenableFuture<Integer> add(VContext _context, int a, int b, RpcOptions _opts) {
        return this.implArith.add(_context, a, b, _opts);
    }

    @Override
    public ClientRecvStream<Integer, Void> count(VContext _context, int start) {
        return this.implArith.count(_context, start);
    }

    @Override
    @Deprecated
    public ClientRecvStream<Integer, Void> count(VContext _context, int start, Options _opts) {
        return this.implArith.count(_context, start, _opts);
    }

    @Override
    public ClientRecvStream<Integer, Void> count(VContext _context, int start, RpcOptions _opts) {
        return this.implArith.count(_context, start, _opts);
    }

    @Override
    public ListenableFuture<ArithClient.DivModOut> divMod(VContext _context, int a, int b) {
        return this.implArith.divMod(_context, a, b);
    }

    @Override
    @Deprecated
    public ListenableFuture<ArithClient.DivModOut> divMod(VContext _context, int a, int b, Options _opts) {
        return this.implArith.divMod(_context, a, b, _opts);
    }

    @Override
    public ListenableFuture<ArithClient.DivModOut> divMod(VContext _context, int a, int b, RpcOptions _opts) {
        return this.implArith.divMod(_context, a, b, _opts);
    }

    @Override
    public ListenableFuture<Void> genError(VContext _context) {
        return this.implArith.genError(_context);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> genError(VContext _context, Options _opts) {
        return this.implArith.genError(_context, _opts);
    }

    @Override
    public ListenableFuture<Void> genError(VContext _context, RpcOptions _opts) {
        return this.implArith.genError(_context, _opts);
    }

    @Override
    public ListenableFuture<Integer> mul(VContext _context, NestedArgs nested) {
        return this.implArith.mul(_context, nested);
    }

    @Override
    @Deprecated
    public ListenableFuture<Integer> mul(VContext _context, NestedArgs nested, Options _opts) {
        return this.implArith.mul(_context, nested, _opts);
    }

    @Override
    public ListenableFuture<Integer> mul(VContext _context, NestedArgs nested, RpcOptions _opts) {
        return this.implArith.mul(_context, nested, _opts);
    }

    @Override
    public ListenableFuture<VdlAny> quoteAny(VContext _context, VdlAny a) {
        return this.implArith.quoteAny(_context, a);
    }

    @Override
    @Deprecated
    public ListenableFuture<VdlAny> quoteAny(VContext _context, VdlAny a, Options _opts) {
        return this.implArith.quoteAny(_context, a, _opts);
    }

    @Override
    public ListenableFuture<VdlAny> quoteAny(VContext _context, VdlAny a, RpcOptions _opts) {
        return this.implArith.quoteAny(_context, a, _opts);
    }

    @Override
    public ClientStream<Integer, Integer, Integer> streamingAdd(VContext _context) {
        return this.implArith.streamingAdd(_context);
    }

    @Override
    @Deprecated
    public ClientStream<Integer, Integer, Integer> streamingAdd(VContext _context, Options _opts) {
        return this.implArith.streamingAdd(_context, _opts);
    }

    @Override
    public ClientStream<Integer, Integer, Integer> streamingAdd(VContext _context, RpcOptions _opts) {
        return this.implArith.streamingAdd(_context, _opts);
    }

    @Override
    public ListenableFuture<Integer> sub(VContext _context, Args args) {
        return this.implArith.sub(_context, args);
    }

    @Override
    @Deprecated
    public ListenableFuture<Integer> sub(VContext _context, Args args, Options _opts) {
        return this.implArith.sub(_context, args, _opts);
    }

    @Override
    public ListenableFuture<Integer> sub(VContext _context, Args args, RpcOptions _opts) {
        return this.implArith.sub(_context, args, _opts);
    }

    @Override
    public ListenableFuture<Double> cosine(VContext _context, double angle) {
        return this.implTrigonometry.cosine(_context, angle);
    }

    @Override
    @Deprecated
    public ListenableFuture<Double> cosine(VContext _context, double angle, Options _opts) {
        return this.implTrigonometry.cosine(_context, angle, _opts);
    }

    @Override
    public ListenableFuture<Double> cosine(VContext _context, double angle, RpcOptions _opts) {
        return this.implTrigonometry.cosine(_context, angle, _opts);
    }

    @Override
    public ListenableFuture<Double> sine(VContext _context, double angle) {
        return this.implTrigonometry.sine(_context, angle);
    }

    @Override
    @Deprecated
    public ListenableFuture<Double> sine(VContext _context, double angle, Options _opts) {
        return this.implTrigonometry.sine(_context, angle, _opts);
    }

    @Override
    public ListenableFuture<Double> sine(VContext _context, double angle, RpcOptions _opts) {
        return this.implTrigonometry.sine(_context, angle, _opts);
    }
}

