/*
 * Decompiled with CFR 0.152.
 */
package io.v.x.ref.lib.vdl.testdata.arith;

import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.Options;
import io.v.v23.V;
import io.v.v23.context.VContext;
import io.v.v23.options.RpcOptions;
import io.v.v23.rpc.Client;
import io.v.x.ref.lib.vdl.testdata.arith.AdvancedMathClient;
import io.v.x.ref.lib.vdl.testdata.arith.TrigonometryClient;
import io.v.x.ref.lib.vdl.testdata.arith.TrigonometryClientFactory;
import io.v.x.ref.lib.vdl.testdata.arith.exp.ExpClient;
import io.v.x.ref.lib.vdl.testdata.arith.exp.ExpClientFactory;

final class AdvancedMathClientImpl
implements AdvancedMathClient {
    private final Client client;
    private final String vName;
    private final TrigonometryClient implTrigonometry;
    private final ExpClient implExp;

    public AdvancedMathClientImpl(Client client, String vName) {
        this.client = client;
        this.vName = vName;
        Options opts = new Options();
        opts.set("io.v.v23.CLIENT", client);
        this.implTrigonometry = TrigonometryClientFactory.getTrigonometryClient(vName, opts);
        opts = new Options();
        opts.set("io.v.v23.CLIENT", client);
        this.implExp = ExpClientFactory.getExpClient(vName, opts);
    }

    private Client getClient(VContext context) {
        return this.client != null ? this.client : V.getClient(context);
    }

    @Override
    public ListenableFuture<Double> exp(VContext _context, double x) {
        return this.implExp.exp(_context, x);
    }

    @Override
    @Deprecated
    public ListenableFuture<Double> exp(VContext _context, double x, Options _opts) {
        return this.implExp.exp(_context, x, _opts);
    }

    @Override
    public ListenableFuture<Double> exp(VContext _context, double x, RpcOptions _opts) {
        return this.implExp.exp(_context, x, _opts);
    }

    @Override
    public ListenableFuture<Double> cosine(VContext _context, double angle) {
        return this.implTrigonometry.cosine(_context, angle);
    }

    @Override
    @Deprecated
    public ListenableFuture<Double> cosine(VContext _context, double angle, Options _opts) {
        return this.implTrigonometry.cosine(_context, angle, _opts);
    }

    @Override
    public ListenableFuture<Double> cosine(VContext _context, double angle, RpcOptions _opts) {
        return this.implTrigonometry.cosine(_context, angle, _opts);
    }

    @Override
    public ListenableFuture<Double> sine(VContext _context, double angle) {
        return this.implTrigonometry.sine(_context, angle);
    }

    @Override
    @Deprecated
    public ListenableFuture<Double> sine(VContext _context, double angle, Options _opts) {
        return this.implTrigonometry.sine(_context, angle, _opts);
    }

    @Override
    public ListenableFuture<Double> sine(VContext _context, double angle, RpcOptions _opts) {
        return this.implTrigonometry.sine(_context, angle, _opts);
    }
}

