/*
 * Decompiled with CFR 0.152.
 */
package io.v.x.ref.lib.raft;

import com.google.common.base.Function;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.vdl.ServerRecvStream;
import io.v.v23.vdl.ServerStream;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import io.v.x.ref.lib.raft.Index;
import io.v.x.ref.lib.raft.LogEntry;
import io.v.x.ref.lib.raft.RaftProtoServer;
import io.v.x.ref.lib.raft.Term;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public final class RaftProtoServerWrapper {
    private final RaftProtoServer server;

    public RaftProtoServerWrapper(RaftProtoServer server) {
        this.server = server;
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        outArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<List<String>>(){}.getType())));
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        methods.add(new Method("members", "// Members returns the current set of ids of raft members.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        tags = new ArrayList();
        methods.add(new Method("leader", "// Leader returns the id of the current leader.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Term.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Term.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Index.class))));
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Term.class))));
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Boolean.class))));
        tags = new ArrayList();
        methods.add(new Method("requestVote", "// RequestVote starts a new round of voting.  It returns the server's current Term and true if// the server voted for the client.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Term.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Index.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Term.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Index.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<List<LogEntry>>(){}.getType())));
        outArgs = new ArrayList();
        tags = new ArrayList();
        methods.add(new Method("appendToLog", "// AppendToLog is sent by the leader to tell followers to append an entry.  If cmds// is empty, this is a keep alive message (at a random interval after a keep alive, followers// will initiate a new round of voting).//   term -- the current term of the sender//   leaderId -- the id of the sender//   prevIndex -- the index of the log entry immediately preceding cmds//   prevTerm -- the term of the log entry immediately preceding cmds.  The receiver must have//               received the previous index'd entry and it must have had the same term.  Otherwise//               an error is returned.//   leaderCommit -- the index of the last committed entry, i.e., the one a quorum has gauranteed//                   to have logged.//   cmds -- sequential log entries starting at prevIndex+1", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)byte[].class))));
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Term.class))));
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Index.class))));
        tags = new ArrayList();
        methods.add(new Method("append", "// Append is sent to the leader by followers.  Only the leader is allowed to send AppendToLog.// If a follower receives an Append() call it performs an Append() to the leader to run the actual// Raft algorithm.  The leader will respond after it has RaftClient.Apply()ed the command.//// Returns the term and index of the append entry or an error.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Index.class))));
        tags = new ArrayList();
        methods.add(new Method("committed", "// Committed returns the commit index of the leader.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Term.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Term.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Index.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        methods.add(new Method("installSnapshot", "// InstallSnapshot is sent from the leader to follower to install the given snapshot.  It is// sent when it becomes apparent that the leader does not have log entries needed by the follower// to progress.  'term' and 'index' represent the last LogEntry RaftClient.Apply()ed to the// snapshot.", inArgs, outArgs, null, null, tags));
        return new Interface("RaftProto", "io.v.x.ref.lib.raft", "// raftProto is used by the members of a raft set to communicate with each other.", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("append".equals(method)) {
            try {
                return new VdlValue[0];
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"append\": %s", e.getMessage()));
            }
        }
        if ("appendToLog".equals(method)) {
            try {
                return new VdlValue[0];
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"appendToLog\": %s", e.getMessage()));
            }
        }
        if ("committed".equals(method)) {
            try {
                return new VdlValue[0];
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"committed\": %s", e.getMessage()));
            }
        }
        if ("installSnapshot".equals(method)) {
            try {
                return new VdlValue[0];
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"installSnapshot\": %s", e.getMessage()));
            }
        }
        if ("leader".equals(method)) {
            try {
                return new VdlValue[0];
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"leader\": %s", e.getMessage()));
            }
        }
        if ("members".equals(method)) {
            try {
                return new VdlValue[0];
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"members\": %s", e.getMessage()));
            }
        }
        if ("requestVote".equals(method)) {
            try {
                return new VdlValue[0];
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"requestVote\": %s", e.getMessage()));
            }
        }
        return null;
    }

    public ListenableFuture<List<String>> members(VContext _ctx, StreamServerCall _call) {
        return this.server.members(_ctx, _call);
    }

    public ListenableFuture<String> leader(VContext _ctx, StreamServerCall _call) {
        return this.server.leader(_ctx, _call);
    }

    public ListenableFuture<RaftProtoServer.RequestVoteOut> requestVote(VContext _ctx, StreamServerCall _call, Term term, String candidateId, Term lastLogTerm, Index lastLogIndex) {
        return this.server.requestVote(_ctx, _call, term, candidateId, lastLogTerm, lastLogIndex);
    }

    public ListenableFuture<Void> appendToLog(VContext _ctx, StreamServerCall _call, Term term, String leaderId, Index prevIndex, Term prevTerm, Index leaderCommit, List<LogEntry> cmds) {
        return this.server.appendToLog(_ctx, _call, term, leaderId, prevIndex, prevTerm, leaderCommit, cmds);
    }

    public ListenableFuture<RaftProtoServer.AppendOut> append(VContext _ctx, StreamServerCall _call, byte[] cmd) {
        return this.server.append(_ctx, _call, cmd);
    }

    public ListenableFuture<Index> committed(VContext _ctx, StreamServerCall _call) {
        return this.server.committed(_ctx, _call);
    }

    public ListenableFuture<Void> installSnapshot(VContext _ctx, final StreamServerCall _call, Term term, String leaderId, Term appliedTerm, Index appliedIndex) {
        ServerStream<Void, byte[]> _stream = new ServerStream<Void, byte[]>(){

            @Override
            public ListenableFuture<Void> send(Void _item) {
                Class<Void> _type = Void.class;
                return _call.send(_item, (Type)((Object)_type));
            }

            @Override
            public ListenableFuture<byte[]> recv() {
                Class<byte[]> _type = byte[].class;
                return Futures.transform(_call.recv((Type)((Object)_type)), (Function)new Function<Object, byte[]>(){

                    public byte[] apply(Object result) {
                        return (byte[])result;
                    }
                });
            }
        };
        return this.server.installSnapshot(_ctx, _call, term, leaderId, appliedTerm, appliedIndex, (ServerRecvStream<byte[]>)_stream);
    }
}

