/*
 * Decompiled with CFR 0.152.
 */
package io.v.x.ref.lib.raft;

import com.google.common.base.Function;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.Options;
import io.v.v23.V;
import io.v.v23.VFutures;
import io.v.v23.context.VContext;
import io.v.v23.options.RpcOptions;
import io.v.v23.rpc.Client;
import io.v.v23.rpc.ClientCall;
import io.v.v23.vdl.ClientSendStream;
import io.v.v23.vdl.ClientStream;
import io.v.x.ref.lib.raft.Index;
import io.v.x.ref.lib.raft.LogEntry;
import io.v.x.ref.lib.raft.RaftProtoClient;
import io.v.x.ref.lib.raft.Term;
import java.lang.reflect.Type;
import java.util.List;

final class RaftProtoClientImpl
implements RaftProtoClient {
    private final Client client;
    private final String vName;

    public RaftProtoClientImpl(Client client, String vName) {
        this.client = client;
        this.vName = vName;
    }

    private Client getClient(VContext context) {
        return this.client != null ? this.client : V.getClient(context);
    }

    @Override
    public ListenableFuture<List<String>> members(VContext _context) {
        return this.members(_context, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<List<String>> members(VContext _context, Options _opts) {
        return this.members(_context, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<List<String>> members(VContext _context, RpcOptions _opts) {
        Object[] _args = new Object[]{};
        Type[] _argTypes = new Type[]{};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "members", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, List<String>>(){

            public ListenableFuture<List<String>> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{new TypeToken<List<String>>(){}.getType()};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], List<String>>(){

                    public List<String> apply(Object[] _results) {
                        return (List)_results[0];
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<String> leader(VContext _context) {
        return this.leader(_context, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<String> leader(VContext _context, Options _opts) {
        return this.leader(_context, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<String> leader(VContext _context, RpcOptions _opts) {
        Object[] _args = new Object[]{};
        Type[] _argTypes = new Type[]{};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "leader", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, String>(){

            public ListenableFuture<String> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{String.class};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], String>(){

                    public String apply(Object[] _results) {
                        return (String)_results[0];
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<RaftProtoClient.RequestVoteOut> requestVote(VContext _context, Term term, String candidateId, Term lastLogTerm, Index lastLogIndex) {
        return this.requestVote(_context, term, candidateId, lastLogTerm, lastLogIndex, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<RaftProtoClient.RequestVoteOut> requestVote(VContext _context, Term term, String candidateId, Term lastLogTerm, Index lastLogIndex, Options _opts) {
        return this.requestVote(_context, term, candidateId, lastLogTerm, lastLogIndex, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<RaftProtoClient.RequestVoteOut> requestVote(VContext _context, Term term, String candidateId, Term lastLogTerm, Index lastLogIndex, RpcOptions _opts) {
        Object[] _args = new Object[]{term, candidateId, lastLogTerm, lastLogIndex};
        Type[] _argTypes = new Type[]{Term.class, String.class, Term.class, Index.class};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "requestVote", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, RaftProtoClient.RequestVoteOut>(){

            public ListenableFuture<RaftProtoClient.RequestVoteOut> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{Term.class, Boolean.class};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], RaftProtoClient.RequestVoteOut>(){

                    public RaftProtoClient.RequestVoteOut apply(Object[] _results) {
                        RaftProtoClient.RequestVoteOut _ret = new RaftProtoClient.RequestVoteOut();
                        _ret.term = (Term)_results[0];
                        _ret.granted = (Boolean)_results[1];
                        return _ret;
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<Void> appendToLog(VContext _context, Term term, String leaderId, Index prevIndex, Term prevTerm, Index leaderCommit, List<LogEntry> cmds) {
        return this.appendToLog(_context, term, leaderId, prevIndex, prevTerm, leaderCommit, cmds, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> appendToLog(VContext _context, Term term, String leaderId, Index prevIndex, Term prevTerm, Index leaderCommit, List<LogEntry> cmds, Options _opts) {
        return this.appendToLog(_context, term, leaderId, prevIndex, prevTerm, leaderCommit, cmds, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Void> appendToLog(VContext _context, Term term, String leaderId, Index prevIndex, Term prevTerm, Index leaderCommit, List<LogEntry> cmds, RpcOptions _opts) {
        Object[] _args = new Object[]{term, leaderId, prevIndex, prevTerm, leaderCommit, cmds};
        Type[] _argTypes = new Type[]{Term.class, String.class, Index.class, Term.class, Index.class, new TypeToken<List<LogEntry>>(){}.getType()};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "appendToLog", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

            public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Void>(){

                    public Void apply(Object[] _results) {
                        return null;
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<RaftProtoClient.AppendOut> append(VContext _context, byte[] cmd) {
        return this.append(_context, cmd, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<RaftProtoClient.AppendOut> append(VContext _context, byte[] cmd, Options _opts) {
        return this.append(_context, cmd, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<RaftProtoClient.AppendOut> append(VContext _context, byte[] cmd, RpcOptions _opts) {
        Object[] _args = new Object[]{cmd};
        Type[] _argTypes = new Type[]{byte[].class};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "append", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, RaftProtoClient.AppendOut>(){

            public ListenableFuture<RaftProtoClient.AppendOut> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{Term.class, Index.class};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], RaftProtoClient.AppendOut>(){

                    public RaftProtoClient.AppendOut apply(Object[] _results) {
                        RaftProtoClient.AppendOut _ret = new RaftProtoClient.AppendOut();
                        _ret.term = (Term)_results[0];
                        _ret.index = (Index)_results[1];
                        return _ret;
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<Index> committed(VContext _context) {
        return this.committed(_context, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Index> committed(VContext _context, Options _opts) {
        return this.committed(_context, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Index> committed(VContext _context, RpcOptions _opts) {
        Object[] _args = new Object[]{};
        Type[] _argTypes = new Type[]{};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "committed", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Index>(){

            public ListenableFuture<Index> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{Index.class};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Index>(){

                    public Index apply(Object[] _results) {
                        return (Index)_results[0];
                    }
                });
            }
        }));
    }

    @Override
    public ClientSendStream<byte[], Void> installSnapshot(VContext _context, Term term, String leaderId, Term appliedTerm, Index appliedIndex) {
        return this.installSnapshot(_context, term, leaderId, appliedTerm, appliedIndex, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ClientSendStream<byte[], Void> installSnapshot(VContext _context, Term term, String leaderId, Term appliedTerm, Index appliedIndex, Options _opts) {
        return this.installSnapshot(_context, term, leaderId, appliedTerm, appliedIndex, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ClientSendStream<byte[], Void> installSnapshot(final VContext _context, Term term, String leaderId, Term appliedTerm, Index appliedIndex, RpcOptions _opts) {
        Object[] _args = new Object[]{term, leaderId, appliedTerm, appliedIndex};
        Type[] _argTypes = new Type[]{Term.class, String.class, Term.class, Index.class};
        final ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "installSnapshot", _args, _argTypes, _opts);
        return new ClientStream<byte[], Void, Void>(){

            @Override
            public ListenableFuture<Void> send(final byte[] item) {
                final Class<byte[]> type = byte[].class;
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return _call.send(item, type);
                    }
                }));
            }

            @Override
            public ListenableFuture<Void> close() {
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return _call.closeSend();
                    }
                }));
            }

            @Override
            public ListenableFuture<Void> recv() {
                final Class<Void> recvType = Void.class;
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return Futures.transform(_call.recv(recvType), (Function)new Function<Object, Void>(){

                            public Void apply(Object result) {
                                return (Void)result;
                            }
                        });
                    }
                }));
            }

            @Override
            public ListenableFuture<Void> finish() {
                final Type[] resultTypes = new Type[]{};
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return Futures.transform(_call.finish(resultTypes), (Function)new Function<Object[], Void>(){

                            public Void apply(Object[] _results) {
                                return null;
                            }
                        });
                    }
                }));
            }
        };
    }
}

