/*
 * Decompiled with CFR 0.152.
 */
package io.v.x.ref.lib.discovery;

import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.discovery.AdId;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.security.access.Tag;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import io.v.x.ref.lib.discovery.AdInfo;
import io.v.x.ref.lib.discovery.DirectoryServer;
import java.lang.reflect.Type;
import java.util.ArrayList;

public final class DirectoryServerWrapper {
    private final DirectoryServer server;

    public DirectoryServerWrapper(DirectoryServer server) {
        this.server = server;
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)AdId.class))));
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)AdInfo.class))));
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("lookup", "// Lookup returns the advertisement of the given service instance.//// The returned advertisement may not include all attachments.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)AdId.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)byte[].class))));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("getAttachment", "// GetAttachment returns the named attachment. Accessing non-existent attachment// is not an error - nil data is returned if not found.//// TODO(jhahn): Consider to return an error if not found.", inArgs, outArgs, null, null, tags));
        return new Interface("Directory", "io.v.x.ref.lib.discovery", "// Directory is the interface for advertisement directory service.", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("getAttachment".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"getAttachment\": %s", e.getMessage()));
            }
        }
        if ("lookup".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"lookup\": %s", e.getMessage()));
            }
        }
        return null;
    }

    public ListenableFuture<AdInfo> lookup(VContext _ctx, StreamServerCall _call, AdId id) {
        return this.server.lookup(_ctx, _call, id);
    }

    public ListenableFuture<byte[]> getAttachment(VContext _ctx, StreamServerCall _call, AdId id, String name) {
        return this.server.getAttachment(_ctx, _call, id, name);
    }
}

