/*
 * Decompiled with CFR 0.152.
 */
package io.v.x.ref.examples.tunnel;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.security.access.Tag;
import io.v.v23.vdl.ServerStream;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import io.v.x.ref.examples.tunnel.ClientShellPacket;
import io.v.x.ref.examples.tunnel.ServerShellPacket;
import io.v.x.ref.examples.tunnel.ShellOpts;
import io.v.x.ref.examples.tunnel.TunnelServer;
import java.lang.reflect.Type;
import java.util.ArrayList;

public final class TunnelServerWrapper {
    private final TunnelServer server;

    public TunnelServerWrapper(TunnelServer server) {
        this.server = server;
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)));
        methods.add(new Method("forward", "// The Forward method is used for network forwarding. All the data sent over// the byte stream is forwarded to the requested network address and all the// data received from that network connection is sent back on the reply// stream.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)));
        methods.add(new Method("reverseForward", "// The ReverseForward method is used for network forwarding from the server// back to the client. The server process listens on the requested network// address, forwarding all connections by calling Forwarder.Forward on the// caller.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)ShellOpts.class))));
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Integer.class))));
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)));
        methods.add(new Method("shell", "// The Shell method is used to either run shell commands remotely, or to open// an interactive shell. The data received over the byte stream is sent to the// shell's stdin, and the data received from the shell's stdout and stderr is// sent back in the reply stream. It returns the exit status of the shell// command as an integer exit code and a human readable string.", inArgs, outArgs, null, null, tags));
        return new Interface("Tunnel", "io.v.x.ref.examples.tunnel", "", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("forward".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"forward\": %s", e.getMessage()));
            }
        }
        if ("reverseForward".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"reverseForward\": %s", e.getMessage()));
            }
        }
        if ("shell".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"shell\": %s", e.getMessage()));
            }
        }
        return null;
    }

    public ListenableFuture<Void> forward(VContext _ctx, final StreamServerCall _call, String network, String address) {
        ServerStream<byte[], byte[]> _stream = new ServerStream<byte[], byte[]>(){

            @Override
            public ListenableFuture<Void> send(byte[] _item) {
                Class<byte[]> _type = byte[].class;
                return _call.send(_item, (Type)((Object)_type));
            }

            @Override
            public ListenableFuture<byte[]> recv() {
                Class<byte[]> _type = byte[].class;
                return Futures.transform(_call.recv((Type)((Object)_type)), (Function)new Function<Object, byte[]>(){

                    public byte[] apply(Object result) {
                        return (byte[])result;
                    }
                });
            }
        };
        return this.server.forward(_ctx, _call, network, address, _stream);
    }

    public ListenableFuture<Void> reverseForward(VContext _ctx, StreamServerCall _call, String network, String address) {
        return this.server.reverseForward(_ctx, _call, network, address);
    }

    public ListenableFuture<TunnelServer.ShellOut> shell(VContext _ctx, final StreamServerCall _call, String command, ShellOpts shellOpts) {
        ServerStream<ServerShellPacket, ClientShellPacket> _stream = new ServerStream<ServerShellPacket, ClientShellPacket>(){

            @Override
            public ListenableFuture<Void> send(ServerShellPacket _item) {
                Class<ServerShellPacket> _type = ServerShellPacket.class;
                return _call.send(_item, (Type)((Object)_type));
            }

            @Override
            public ListenableFuture<ClientShellPacket> recv() {
                Class<ClientShellPacket> _type = ClientShellPacket.class;
                return Futures.transform(_call.recv((Type)((Object)_type)), (Function)new Function<Object, ClientShellPacket>(){

                    public ClientShellPacket apply(Object result) {
                        return (ClientShellPacket)result;
                    }
                });
            }
        };
        return this.server.shell(_ctx, _call, command, shellOpts, _stream);
    }
}

