/*
 * Decompiled with CFR 0.152.
 */
package io.v.x.ref.examples.tunnel;

import com.google.common.base.Function;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.Options;
import io.v.v23.V;
import io.v.v23.VFutures;
import io.v.v23.context.VContext;
import io.v.v23.options.RpcOptions;
import io.v.v23.rpc.Client;
import io.v.v23.rpc.ClientCall;
import io.v.v23.vdl.ClientStream;
import io.v.x.ref.examples.tunnel.ClientShellPacket;
import io.v.x.ref.examples.tunnel.ServerShellPacket;
import io.v.x.ref.examples.tunnel.ShellOpts;
import io.v.x.ref.examples.tunnel.TunnelClient;
import java.lang.reflect.Type;

final class TunnelClientImpl
implements TunnelClient {
    private final Client client;
    private final String vName;

    public TunnelClientImpl(Client client, String vName) {
        this.client = client;
        this.vName = vName;
    }

    private Client getClient(VContext context) {
        return this.client != null ? this.client : V.getClient(context);
    }

    @Override
    public ClientStream<byte[], byte[], Void> forward(VContext _context, String network, String address) {
        return this.forward(_context, network, address, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ClientStream<byte[], byte[], Void> forward(VContext _context, String network, String address, Options _opts) {
        return this.forward(_context, network, address, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ClientStream<byte[], byte[], Void> forward(final VContext _context, String network, String address, RpcOptions _opts) {
        Object[] _args = new Object[]{network, address};
        Type[] _argTypes = new Type[]{String.class, String.class};
        final ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "forward", _args, _argTypes, _opts);
        return new ClientStream<byte[], byte[], Void>(){

            @Override
            public ListenableFuture<Void> send(final byte[] item) {
                final Class<byte[]> type = byte[].class;
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return _call.send(item, type);
                    }
                }));
            }

            @Override
            public ListenableFuture<Void> close() {
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return _call.closeSend();
                    }
                }));
            }

            @Override
            public ListenableFuture<byte[]> recv() {
                final Class<byte[]> recvType = byte[].class;
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, byte[]>(){

                    public ListenableFuture<byte[]> apply(ClientCall _call) throws Exception {
                        return Futures.transform(_call.recv(recvType), (Function)new Function<Object, byte[]>(){

                            public byte[] apply(Object result) {
                                return (byte[])result;
                            }
                        });
                    }
                }));
            }

            @Override
            public ListenableFuture<Void> finish() {
                final Type[] resultTypes = new Type[]{};
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return Futures.transform(_call.finish(resultTypes), (Function)new Function<Object[], Void>(){

                            public Void apply(Object[] _results) {
                                return null;
                            }
                        });
                    }
                }));
            }
        };
    }

    @Override
    public ListenableFuture<Void> reverseForward(VContext _context, String network, String address) {
        return this.reverseForward(_context, network, address, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> reverseForward(VContext _context, String network, String address, Options _opts) {
        return this.reverseForward(_context, network, address, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Void> reverseForward(VContext _context, String network, String address, RpcOptions _opts) {
        Object[] _args = new Object[]{network, address};
        Type[] _argTypes = new Type[]{String.class, String.class};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "reverseForward", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

            public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Void>(){

                    public Void apply(Object[] _results) {
                        return null;
                    }
                });
            }
        }));
    }

    @Override
    public ClientStream<ClientShellPacket, ServerShellPacket, TunnelClient.ShellOut> shell(VContext _context, String command, ShellOpts shellOpts) {
        return this.shell(_context, command, shellOpts, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ClientStream<ClientShellPacket, ServerShellPacket, TunnelClient.ShellOut> shell(VContext _context, String command, ShellOpts shellOpts, Options _opts) {
        return this.shell(_context, command, shellOpts, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ClientStream<ClientShellPacket, ServerShellPacket, TunnelClient.ShellOut> shell(final VContext _context, String command, ShellOpts shellOpts, RpcOptions _opts) {
        Object[] _args = new Object[]{command, shellOpts};
        Type[] _argTypes = new Type[]{String.class, ShellOpts.class};
        final ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "shell", _args, _argTypes, _opts);
        return new ClientStream<ClientShellPacket, ServerShellPacket, TunnelClient.ShellOut>(){

            @Override
            public ListenableFuture<Void> send(final ClientShellPacket item) {
                final Class<ClientShellPacket> type = ClientShellPacket.class;
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return _call.send(item, type);
                    }
                }));
            }

            @Override
            public ListenableFuture<Void> close() {
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return _call.closeSend();
                    }
                }));
            }

            @Override
            public ListenableFuture<ServerShellPacket> recv() {
                final Class<ServerShellPacket> recvType = ServerShellPacket.class;
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, ServerShellPacket>(){

                    public ListenableFuture<ServerShellPacket> apply(ClientCall _call) throws Exception {
                        return Futures.transform(_call.recv(recvType), (Function)new Function<Object, ServerShellPacket>(){

                            public ServerShellPacket apply(Object result) {
                                return (ServerShellPacket)result;
                            }
                        });
                    }
                }));
            }

            @Override
            public ListenableFuture<TunnelClient.ShellOut> finish() {
                final Type[] resultTypes = new Type[]{Integer.class, String.class};
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, TunnelClient.ShellOut>(){

                    public ListenableFuture<TunnelClient.ShellOut> apply(ClientCall _call) throws Exception {
                        return Futures.transform(_call.finish(resultTypes), (Function)new Function<Object[], TunnelClient.ShellOut>(){

                            public TunnelClient.ShellOut apply(Object[] _results) {
                                TunnelClient.ShellOut _ret = new TunnelClient.ShellOut();
                                _ret.exitCode = (Integer)_results[0];
                                _ret.exitMsg = (String)_results[1];
                                return _ret;
                            }
                        });
                    }
                }));
            }
        };
    }
}

