/*
 * Decompiled with CFR 0.152.
 */
package io.v.x.ref.examples.rps;

import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.Options;
import io.v.v23.V;
import io.v.v23.context.VContext;
import io.v.v23.options.RpcOptions;
import io.v.v23.rpc.Client;
import io.v.v23.vdl.ClientStream;
import io.v.x.ref.examples.rps.GameId;
import io.v.x.ref.examples.rps.GameOptions;
import io.v.x.ref.examples.rps.JudgeAction;
import io.v.x.ref.examples.rps.JudgeClient;
import io.v.x.ref.examples.rps.JudgeClientFactory;
import io.v.x.ref.examples.rps.PlayResult;
import io.v.x.ref.examples.rps.PlayerAction;
import io.v.x.ref.examples.rps.PlayerClient;
import io.v.x.ref.examples.rps.PlayerClientFactory;
import io.v.x.ref.examples.rps.RockPaperScissorsClient;
import io.v.x.ref.examples.rps.ScoreCard;
import io.v.x.ref.examples.rps.ScoreKeeperClient;
import io.v.x.ref.examples.rps.ScoreKeeperClientFactory;

final class RockPaperScissorsClientImpl
implements RockPaperScissorsClient {
    private final Client client;
    private final String vName;
    private final JudgeClient implJudge;
    private final PlayerClient implPlayer;
    private final ScoreKeeperClient implScoreKeeper;

    public RockPaperScissorsClientImpl(Client client, String vName) {
        this.client = client;
        this.vName = vName;
        Options opts = new Options();
        opts.set("io.v.v23.CLIENT", client);
        this.implJudge = JudgeClientFactory.getJudgeClient(vName, opts);
        opts = new Options();
        opts.set("io.v.v23.CLIENT", client);
        this.implPlayer = PlayerClientFactory.getPlayerClient(vName, opts);
        opts = new Options();
        opts.set("io.v.v23.CLIENT", client);
        this.implScoreKeeper = ScoreKeeperClientFactory.getScoreKeeperClient(vName, opts);
    }

    private Client getClient(VContext context) {
        return this.client != null ? this.client : V.getClient(context);
    }

    @Override
    public ListenableFuture<GameId> createGame(VContext _context, GameOptions Opts) {
        return this.implJudge.createGame(_context, Opts);
    }

    @Override
    @Deprecated
    public ListenableFuture<GameId> createGame(VContext _context, GameOptions Opts, Options _opts) {
        return this.implJudge.createGame(_context, Opts, _opts);
    }

    @Override
    public ListenableFuture<GameId> createGame(VContext _context, GameOptions Opts, RpcOptions _opts) {
        return this.implJudge.createGame(_context, Opts, _opts);
    }

    @Override
    public ClientStream<PlayerAction, JudgeAction, PlayResult> play(VContext _context, GameId Id2) {
        return this.implJudge.play(_context, Id2);
    }

    @Override
    @Deprecated
    public ClientStream<PlayerAction, JudgeAction, PlayResult> play(VContext _context, GameId Id2, Options _opts) {
        return this.implJudge.play(_context, Id2, _opts);
    }

    @Override
    public ClientStream<PlayerAction, JudgeAction, PlayResult> play(VContext _context, GameId Id2, RpcOptions _opts) {
        return this.implJudge.play(_context, Id2, _opts);
    }

    @Override
    public ListenableFuture<Void> challenge(VContext _context, String Address2, GameId Id2, GameOptions Opts) {
        return this.implPlayer.challenge(_context, Address2, Id2, Opts);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> challenge(VContext _context, String Address2, GameId Id2, GameOptions Opts, Options _opts) {
        return this.implPlayer.challenge(_context, Address2, Id2, Opts, _opts);
    }

    @Override
    public ListenableFuture<Void> challenge(VContext _context, String Address2, GameId Id2, GameOptions Opts, RpcOptions _opts) {
        return this.implPlayer.challenge(_context, Address2, Id2, Opts, _opts);
    }

    @Override
    public ListenableFuture<Void> record(VContext _context, ScoreCard Score2) {
        return this.implScoreKeeper.record(_context, Score2);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> record(VContext _context, ScoreCard Score2, Options _opts) {
        return this.implScoreKeeper.record(_context, Score2, _opts);
    }

    @Override
    public ListenableFuture<Void> record(VContext _context, ScoreCard Score2, RpcOptions _opts) {
        return this.implScoreKeeper.record(_context, Score2, _opts);
    }
}

