/*
 * Decompiled with CFR 0.152.
 */
package io.v.x.ref.examples.rps;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.security.access.Tag;
import io.v.v23.vdl.ServerStream;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import io.v.x.ref.examples.rps.GameId;
import io.v.x.ref.examples.rps.GameOptions;
import io.v.x.ref.examples.rps.JudgeAction;
import io.v.x.ref.examples.rps.JudgeServer;
import io.v.x.ref.examples.rps.PlayResult;
import io.v.x.ref.examples.rps.PlayerAction;
import java.lang.reflect.Type;
import java.util.ArrayList;

public final class JudgeServerWrapper {
    private final JudgeServer server;

    public JudgeServerWrapper(JudgeServer server) {
        this.server = server;
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)GameOptions.class))));
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)GameId.class))));
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("createGame", "// CreateGame creates a new game with the given game options and returns a game// identifier that can be used by the players to join the game.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)GameId.class))));
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)PlayResult.class))));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("play", "// Play lets a player join an existing game and play.", inArgs, outArgs, null, null, tags));
        return new Interface("Judge", "io.v.x.ref.examples.rps", "", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("createGame".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"createGame\": %s", e.getMessage()));
            }
        }
        if ("play".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"play\": %s", e.getMessage()));
            }
        }
        return null;
    }

    public ListenableFuture<GameId> createGame(VContext _ctx, StreamServerCall _call, GameOptions Opts) {
        return this.server.createGame(_ctx, _call, Opts);
    }

    public ListenableFuture<PlayResult> play(VContext _ctx, final StreamServerCall _call, GameId Id2) {
        ServerStream<JudgeAction, PlayerAction> _stream = new ServerStream<JudgeAction, PlayerAction>(){

            @Override
            public ListenableFuture<Void> send(JudgeAction _item) {
                Class<JudgeAction> _type = JudgeAction.class;
                return _call.send(_item, (Type)((Object)_type));
            }

            @Override
            public ListenableFuture<PlayerAction> recv() {
                Class<PlayerAction> _type = PlayerAction.class;
                return Futures.transform(_call.recv((Type)((Object)_type)), (Function)new Function<Object, PlayerAction>(){

                    public PlayerAction apply(Object result) {
                        return (PlayerAction)result;
                    }
                });
            }
        };
        return this.server.play(_ctx, _call, Id2, _stream);
    }
}

