/*
 * Decompiled with CFR 0.152.
 */
package io.v.x.jni.test.fortune;

import com.google.common.base.Function;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.security.access.Tag;
import io.v.v23.vdl.ServerStream;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import io.v.x.jni.test.fortune.FortuneServer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;

public final class FortuneServerWrapper {
    private final FortuneServer server;

    public FortuneServerWrapper(FortuneServer server) {
        this.server = server;
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("add", "// Add stores a fortune in the set used by Get.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("get", "// Get returns the last-added fortune.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<Map<String, String>>(){}.getType())));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("parameterizedGet", "// ParameterizedGet returns the last-added fortune as a map (which is a parameterized// type in Java).", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Integer.class))));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("streamingGet", "// StreamingGet returns a stream that can be used to obtain fortunes, and returns the// total number of items sent.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("multipleGet", "// MultipleGet returns the same fortune twice.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Integer.class))));
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Integer.class))));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("multipleStreamingGet", "// MultipleStreamingGet returns a stream that can be used to obtain fortunes, and returns// the total number of items sent, twice.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("getComplexError", "// GetComplexError returns (always!) ErrComplex.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        tags = new ArrayList();
        methods.add(new Method("noTags", "// NoTags is a method without tags.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("testServerCall", "// TestServerCall is a method used for testing that the server receives a// correct ServerCall.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("getServerThread", "// GetServerThread returns a name of the server thread that executes this method.", inArgs, outArgs, null, null, tags));
        return new Interface("Fortune", "io.v.x.jni.test.fortune", "// Fortune allows clients to Get and Add fortune strings.", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("add".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"add\": %s", e.getMessage()));
            }
        }
        if ("get".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"get\": %s", e.getMessage()));
            }
        }
        if ("getComplexError".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"getComplexError\": %s", e.getMessage()));
            }
        }
        if ("getServerThread".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"getServerThread\": %s", e.getMessage()));
            }
        }
        if ("multipleGet".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"multipleGet\": %s", e.getMessage()));
            }
        }
        if ("multipleStreamingGet".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"multipleStreamingGet\": %s", e.getMessage()));
            }
        }
        if ("noTags".equals(method)) {
            try {
                return new VdlValue[0];
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"noTags\": %s", e.getMessage()));
            }
        }
        if ("parameterizedGet".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"parameterizedGet\": %s", e.getMessage()));
            }
        }
        if ("streamingGet".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"streamingGet\": %s", e.getMessage()));
            }
        }
        if ("testServerCall".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"testServerCall\": %s", e.getMessage()));
            }
        }
        return null;
    }

    public ListenableFuture<Void> add(VContext _ctx, StreamServerCall _call, String Fortune) {
        return this.server.add(_ctx, _call, Fortune);
    }

    public ListenableFuture<String> get(VContext _ctx, StreamServerCall _call) {
        return this.server.get(_ctx, _call);
    }

    public ListenableFuture<Map<String, String>> parameterizedGet(VContext _ctx, StreamServerCall _call) {
        return this.server.parameterizedGet(_ctx, _call);
    }

    public ListenableFuture<Integer> streamingGet(VContext _ctx, final StreamServerCall _call) {
        ServerStream<String, Boolean> _stream = new ServerStream<String, Boolean>(){

            @Override
            public ListenableFuture<Void> send(String _item) {
                Class<String> _type = String.class;
                return _call.send(_item, (Type)((Object)_type));
            }

            @Override
            public ListenableFuture<Boolean> recv() {
                Class<Boolean> _type = Boolean.class;
                return Futures.transform(_call.recv((Type)((Object)_type)), (Function)new Function<Object, Boolean>(){

                    public Boolean apply(Object result) {
                        return (Boolean)result;
                    }
                });
            }
        };
        return this.server.streamingGet(_ctx, _call, _stream);
    }

    public ListenableFuture<FortuneServer.MultipleGetOut> multipleGet(VContext _ctx, StreamServerCall _call) {
        return this.server.multipleGet(_ctx, _call);
    }

    public ListenableFuture<FortuneServer.MultipleStreamingGetOut> multipleStreamingGet(VContext _ctx, final StreamServerCall _call) {
        ServerStream<String, Boolean> _stream = new ServerStream<String, Boolean>(){

            @Override
            public ListenableFuture<Void> send(String _item) {
                Class<String> _type = String.class;
                return _call.send(_item, (Type)((Object)_type));
            }

            @Override
            public ListenableFuture<Boolean> recv() {
                Class<Boolean> _type = Boolean.class;
                return Futures.transform(_call.recv((Type)((Object)_type)), (Function)new Function<Object, Boolean>(){

                    public Boolean apply(Object result) {
                        return (Boolean)result;
                    }
                });
            }
        };
        return this.server.multipleStreamingGet(_ctx, _call, _stream);
    }

    public ListenableFuture<Void> getComplexError(VContext _ctx, StreamServerCall _call) {
        return this.server.getComplexError(_ctx, _call);
    }

    public ListenableFuture<Void> noTags(VContext _ctx, StreamServerCall _call) {
        return this.server.noTags(_ctx, _call);
    }

    public ListenableFuture<Void> testServerCall(VContext _ctx, StreamServerCall _call) {
        return this.server.testServerCall(_ctx, _call);
    }

    public ListenableFuture<String> getServerThread(VContext _ctx, StreamServerCall _call) {
        return this.server.getServerThread(_ctx, _call);
    }
}

